/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedRollingWithArchiveRemovalTest {
    Context context = new ContextBase();
    EchoEncoder<Object> encoder = new EchoEncoder();
    static final String MONTHLY_DATE_PATTERN = "yyyy-MM";
    static final String MONTHLY_CROLOLOG_DATE_PATTERN = "yyyy/MM";
    static final String DAILY_DATE_PATTERN = "yyyy-MM-dd";
    static final String DAILY_CROLOLOG_DATE_PATTERN = "yyyy/MM/dd";
    static final long MILLIS_IN_MINUTE = 60000L;
    static final long MILLIS_IN_HOUR = 3600000L;
    static final long MILLIS_IN_DAY = 86400000L;
    static final long MILLIS_IN_MONTH = 2592000000L;
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDir = "target/test-output/" + this.diff + "/";
    int slashCount;
    TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp = new DefaultTimeBasedFileNamingAndTriggeringPolicy();

    @Before
    public void setUp() {
        this.context.setName("test");
    }

    @After
    public void tearDown() throws Exception {
    }

    int computeSlashCount(String datePattern) {
        int i;
        int fromIndex = 0;
        int count = 0;
        while ((i = datePattern.indexOf(47, fromIndex)) != -1) {
            ++count;
            fromIndex = i + 1;
            if (fromIndex < datePattern.length()) continue;
            break;
        }
        return count;
    }

    @Test
    public void montlyRollover() throws Exception {
        this.slashCount = this.computeSlashCount(MONTHLY_DATE_PATTERN);
        this.doRollover(this.randomOutputDir + "clean-%d{" + MONTHLY_DATE_PATTERN + "}.txt", 2592000000L, 20, 60);
        this.check(this.expectedCountWithoutFolders(20));
    }

    @Test
    public void montlyRolloverOverManyPeriods() throws Exception {
        System.out.println("randomOutputDir=" + this.randomOutputDir);
        this.slashCount = this.computeSlashCount(MONTHLY_CROLOLOG_DATE_PATTERN);
        int numPeriods = 40;
        int maxHistory = 2;
        this.doRollover(this.randomOutputDir + "/%d{" + MONTHLY_CROLOLOG_DATE_PATTERN + "}/clean.txt.zip", 2592000000L, maxHistory, numPeriods);
        int beginPeriod = Calendar.getInstance().get(2);
        boolean extraFolder = this.extraFolder(numPeriods, 12, beginPeriod, maxHistory);
        this.check(this.expectedCountWithFolders(2, extraFolder));
    }

    @Test
    public void dailyRollover() throws Exception {
        this.slashCount = this.computeSlashCount(DAILY_DATE_PATTERN);
        this.doRollover(this.randomOutputDir + "clean-%d{" + DAILY_DATE_PATTERN + "}.txt.zip", 86400000L, 5, 15);
        this.check(this.expectedCountWithoutFolders(5));
    }

    @Test
    public void dailyCronologRollover() throws Exception {
        this.slashCount = this.computeSlashCount(DAILY_CROLOLOG_DATE_PATTERN);
        this.doRollover(this.randomOutputDir + "/%d{" + DAILY_CROLOLOG_DATE_PATTERN + "}/clean.txt.zip", 86400000L, 8, 24);
        int expectedDirMin = 9 + this.slashCount;
        int expectDirMax = expectedDirMin + 1 + 1;
        this.expectedFileAndDirCount(9, expectedDirMin, expectDirMax);
    }

    @Test
    public void dailySizeBasedRollover() throws Exception {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = this.computeSlashCount(DAILY_DATE_PATTERN);
        this.doRollover(this.randomOutputDir + "/%d{" + DAILY_DATE_PATTERN + "}-clean.%i.zip", 86400000L, 5, 20);
        this.checkPatternCompliance(6 + this.slashCount, "\\d{4}-\\d{2}-\\d{2}-clean(\\.\\d)(.zip)?");
    }

    @Test
    public void dailyChronologSizeBasedRollover() throws Exception {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = 1;
        this.doRollover(this.randomOutputDir + "/%d{" + DAILY_DATE_PATTERN + "}/clean.%i.zip", 86400000L, 5, 20);
        this.checkDirPatternCompliance(6);
    }

    void doRollover(String fileNamePattern, long periodDurationInMillis, int maxHistory, int simulatedNumberOfPeriods) throws Exception {
        long currentTime = System.currentTimeMillis();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setEncoder(this.encoder);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern(fileNamePattern);
        tbrp.setMaxHistory(maxHistory);
        tbrp.setParent((FileAppender)rfa);
        tbrp.timeBasedFileNamingAndTriggeringPolicy = this.tbfnatp;
        tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(currentTime);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        int ticksPerPeriod = 512;
        long runLength = simulatedNumberOfPeriods * ticksPerPeriod;
        for (long i = 0L; i < runLength; ++i) {
            rfa.doAppend((Object)("Hello ----------------------------------------------------------" + i));
            tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(TimeBasedRollingWithArchiveRemovalTest.addTime(tbrp.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime(), periodDurationInMillis / (long)ticksPerPeriod));
            if (i % (long)(ticksPerPeriod / 2) != 0L) continue;
            this.waitForCompression((TimeBasedRollingPolicy<Object>)tbrp);
        }
        this.waitForCompression((TimeBasedRollingPolicy<Object>)tbrp);
        rfa.stop();
    }

    void waitForCompression(TimeBasedRollingPolicy<Object> tbrp) throws InterruptedException, ExecutionException, TimeoutException {
        if (tbrp.future != null && !tbrp.future.isDone()) {
            tbrp.future.get(200L, TimeUnit.MILLISECONDS);
        }
    }

    void findAllFoldersRecursively(File dir, List<File> fileList) {
        if (dir.isDirectory()) {
            File[] match;
            for (File f : match = dir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory();
                }
            })) {
                fileList.add(f);
                this.findAllFoldersRecursively(f, fileList);
            }
        }
    }

    void findAllInFolderRecursivelyByStringContains(File dir, List<File> fileList, final String pattern) {
        if (dir.isDirectory()) {
            File[] match;
            for (File f : match = dir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().contains(pattern);
                }
            })) {
                fileList.add(f);
                if (!f.isDirectory()) continue;
                this.findAllInFolderRecursivelyByStringContains(f, fileList, pattern);
            }
        }
    }

    void findFilesInFolderRecursivelyByPatterMatch(File dir, List<File> fileList, final String pattern) {
        if (dir.isDirectory()) {
            File[] match;
            for (File f : match = dir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().matches(pattern);
                }
            })) {
                if (f.isDirectory()) {
                    this.findFilesInFolderRecursivelyByPatterMatch(f, fileList, pattern);
                    continue;
                }
                fileList.add(f);
            }
        }
    }

    void findFoldersInFolderRecursively(File dir, List<File> fileList) {
        if (dir.isDirectory()) {
            File[] match;
            for (File f : match = dir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory();
                }
            })) {
                fileList.add(f);
                this.findFoldersInFolderRecursively(f, fileList);
            }
        }
    }

    int expectedCountWithoutFolders(int maxHistory) {
        return maxHistory + 1;
    }

    boolean extraFolder(int numPeriods, int periodsPerEra, int beginPeriod, int maxHistory) {
        int adjustedBegin = beginPeriod + 1;
        int remainder = (adjustedBegin + numPeriods) % periodsPerEra;
        return remainder < maxHistory + 1;
    }

    int expectedCountWithFolders(int maxHistory, boolean extraFolder) {
        int result = (maxHistory + 1) * 2 + this.slashCount;
        if (extraFolder) {
            ++result;
        }
        return result;
    }

    void check(int expectedCount) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findAllInFolderRecursivelyByStringContains(dir, fileList, "clean");
        Assert.assertEquals((long)expectedCount, (long)fileList.size());
    }

    void expectedFileAndDirCount(int expectedFileAndDirCount, int expectedDirCountMin, int expectedDirCountMax) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, fileList, "clean");
        ArrayList<File> dirList = new ArrayList<File>();
        this.findAllFoldersRecursively(dir, dirList);
        Assert.assertTrue((String)("expectedDirCountMin=" + expectedDirCountMin + ", expectedDirCountMax=" + expectedDirCountMax + " actual value=" + dirList.size()), (expectedDirCountMin <= dirList.size() && dirList.size() <= expectedDirCountMax ? 1 : 0) != 0);
    }

    void checkPatternCompliance(int expectedClassCount, String regex) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, fileList, regex);
        Set<String> set = this.groupByClass(fileList, regex);
        Assert.assertEquals((long)expectedClassCount, (long)set.size());
    }

    void checkDirPatternCompliance(int expectedClassCount) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findFoldersInFolderRecursively(dir, fileList);
        for (File f : fileList) {
            Assert.assertTrue((f.list().length >= 1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)expectedClassCount, (long)fileList.size());
    }

    Set<String> groupByClass(List<File> fileList, String regex) {
        Pattern p = Pattern.compile(regex);
        HashSet<String> set = new HashSet<String>();
        for (File f : fileList) {
            String n = f.getName();
            Matcher m = p.matcher(n);
            m.matches();
            int begin = m.start(1);
            String reduced = n.substring(0, begin);
            set.add(reduced);
        }
        System.out.println(set);
        return set;
    }

    static long addTime(long currentTime, long timeToWait) {
        return currentTime + timeToWait;
    }
}

