/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.spi.CyclicBufferTracker;
import ch.qos.logback.core.spi.CyclicBufferTrackerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBufferTrackerSimulator {
    CyclicBufferTrackerImpl<Object> realAppenderTracker = new CyclicBufferTrackerImpl();
    CyclicBufferTrackerImpl t_appenderTracker = new CyclicBufferTrackerImpl();
    List<SimulationEvent> scenario = new ArrayList<SimulationEvent>();
    List<String> keySpace = new ArrayList<String>();
    int maxTimestampInc;
    Random randomKeyGen = new Random(100L);
    Random random = new Random(11234L);

    CyclicBufferTrackerSimulator(int keySpaceLen, int maxTimestampInc) {
        this.maxTimestampInc = maxTimestampInc;
        HashMap<String, String> checkMap = new HashMap<String, String>();
        for (int i = 0; i < keySpaceLen; ++i) {
            String k = this.getRandomKeyStr();
            if (checkMap.containsKey(k)) {
                System.out.println("random key collision occured");
                k = k + "" + i;
            }
            this.keySpace.add(k);
            checkMap.put(k, k);
        }
    }

    private String getRandomKeyStr() {
        int ri = this.randomKeyGen.nextInt();
        String s = String.format("%X", ri);
        return s;
    }

    void buildScenario(int simLen) {
        long timestamp = 30000L;
        int keySpaceLen = this.keySpace.size();
        for (int i = 0; i < simLen; ++i) {
            int index = this.random.nextInt(keySpaceLen);
            String key = this.keySpace.get(index);
            this.scenario.add(new SimulationEvent(key, timestamp += (long)this.random.nextInt(this.maxTimestampInc)));
        }
    }

    public void dump() {
        for (SimulationEvent simeEvent : this.scenario) {
            System.out.println(simeEvent);
        }
    }

    void play(SimulationEvent simulationEvent, CyclicBufferTracker<Object> tracker) {
        String key = simulationEvent.key;
        long timestamp = simulationEvent.timestamp;
        tracker.get(key, timestamp);
    }

    public void simulate() {
        for (SimulationEvent simeEvent : this.scenario) {
            this.play(simeEvent, (CyclicBufferTracker<Object>)this.realAppenderTracker);
            this.play(simeEvent, (CyclicBufferTracker<Object>)this.t_appenderTracker);
        }
    }

    class SimulationEvent {
        public final String key;
        public final long timestamp;

        public SimulationEvent(String key, long timestamp) {
            this.key = key;
            this.timestamp = timestamp;
        }

        public String toString() {
            return "Event: k=" + this.key + ", timestamp=" + this.timestamp;
        }
    }
}

