/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.testUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileToBufferUtil {
    public static void readIntoList(File file, List<String> stringList) throws IOException {
        if (file.getName().endsWith(".gz")) {
            FileToBufferUtil.gzFileReadIntoList(file, stringList);
        } else {
            FileToBufferUtil.regularReadIntoList(file, stringList);
        }
    }

    public static void regularReadIntoList(File file, List<String> stringList) throws IOException {
        String line;
        FileInputStream fis = new FileInputStream(file);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        while ((line = in.readLine()) != null) {
            stringList.add(line);
        }
        in.close();
    }

    public static void gzFileReadIntoList(File file, List<String> stringList) throws IOException {
        String line;
        FileInputStream fis = new FileInputStream(file);
        GZIPInputStream gzis = new GZIPInputStream(fis);
        BufferedReader in = new BufferedReader(new InputStreamReader(gzis));
        while ((line = in.readLine()) != null) {
            stringList.add(line);
        }
        in.close();
    }
}

