/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.OptionTokenizer;
import ch.qos.logback.core.pattern.parser.ScanException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class OptionTokenizerTest {
    @Test
    public void testEmpty() throws ScanException {
        List ol = new OptionTokenizer("").tokenize();
        ArrayList witness = new ArrayList();
        Assert.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer(" ").tokenize();
        witness = new ArrayList();
        Assert.assertEquals(witness, (Object)ol);
    }

    @Test
    public void testSimple() throws ScanException {
        List ol = new OptionTokenizer("abc").tokenize();
        ArrayList<String> witness = new ArrayList<String>();
        witness.add("abc");
        Assert.assertEquals(witness, (Object)ol);
    }

    @Test
    public void testSingleQuote() throws ScanException {
        List ol = new OptionTokenizer("' '").tokenize();
        ArrayList<String> witness = new ArrayList<String>();
        witness.add(" ");
        Assert.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("' x\t'").tokenize();
        witness = new ArrayList();
        witness.add(" x\t");
        Assert.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("' x\\t'").tokenize();
        witness = new ArrayList();
        witness.add(" x\t");
        Assert.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("' x\\''").tokenize();
        witness = new ArrayList();
        witness.add(" x'");
        Assert.assertEquals(witness, (Object)ol);
    }

    @Test
    public void testDoubleQuote() throws ScanException {
        List ol = new OptionTokenizer("\" \"").tokenize();
        ArrayList<String> witness = new ArrayList<String>();
        witness.add(" ");
        Assert.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("\" x\t\"").tokenize();
        witness = new ArrayList();
        witness.add(" x\t");
        Assert.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("\" x\\t\"").tokenize();
        witness = new ArrayList();
        witness.add(" x\t");
        Assert.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("\" x\\\"\"").tokenize();
        witness = new ArrayList();
        witness.add(" x\"");
        Assert.assertEquals(witness, (Object)ol);
    }

    @Test
    public void testMultiple() throws ScanException {
        List ol = new OptionTokenizer("a, b").tokenize();
        ArrayList<String> witness = new ArrayList<String>();
        witness.add("a");
        witness.add("b");
        Assert.assertEquals(witness, (Object)ol);
    }
}

