/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.ScanException;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.pattern.util.AlmostAsIsEscapeUtil;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TokenStreamTest {
    @Test
    public void testEmpty() throws ScanException {
        try {
            new TokenStream("").tokenize();
            Assert.fail((String)"empty string not allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSingleLiteral() throws ScanException {
        List tl = new TokenStream("hello").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"hello"));
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testLiteralWithPercent() throws ScanException {
        List tl = new TokenStream("hello\\%world").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"hello%world"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("hello\\%").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"hello%"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("\\%").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"%"));
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testBasic() throws ScanException {
        List tl = new TokenStream("%c").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"c"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%a%b").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"a"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"b"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("xyz%-34c").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"xyz"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"-34"));
        witness.add(new Token(1004, (Object)"c"));
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testComplexNR() throws ScanException {
        List tl = new TokenStream("%d{1234} [%34.-67toto] %n").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"d"));
        ArrayList<String> ol = new ArrayList<String>();
        ol.add("1234");
        witness.add(new Token(1006, ol));
        witness.add(new Token(1000, (Object)" ["));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"34.-67"));
        witness.add(new Token(1004, (Object)"toto"));
        witness.add(new Token(1000, (Object)"] "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"n"));
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testEmptyP() throws ScanException {
        List tl = new TokenStream("()").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"("));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testEmptyP2() throws ScanException {
        List tl = new TokenStream("%()").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testEscape() throws ScanException {
        List tl = new TokenStream("\\%").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"%"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("\\%\\(\\t\\)\\r\\n").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"%(\t)\r\n"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("\\\\%x").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"\\"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x\\)").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(new Token(1000, (Object)")"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x\\_a").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(new Token(1000, (Object)"a"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x\\_%b").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"b"));
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testOptions() throws ScanException {
        List tl = new TokenStream("%x{t}").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        ArrayList<String> ol = new ArrayList<String>();
        ol.add("t");
        witness.add(new Token(1006, ol));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x{t,y}").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        ol = new ArrayList();
        ol.add("t");
        ol.add("y");
        witness.add(new Token(1006, ol));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x{\"hello world.\", \"12y  \"}").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        ol = new ArrayList();
        ol.add("hello world.");
        ol.add("12y  ");
        witness.add(new Token(1006, ol));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x{'opt}'}").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        ol = new ArrayList();
        ol.add("opt}");
        witness.add(new Token(1006, ol));
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testSimpleP() throws ScanException {
        List tl = new TokenStream("%(hello %class{.4?})").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        witness.add(new Token(1000, (Object)"hello "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"class"));
        ArrayList<String> ol = new ArrayList<String>();
        ol.add(".4?");
        witness.add(new Token(1006, ol));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testSimpleP2() throws ScanException {
        List tl = new TokenStream("X %a %-12.550(hello %class{.4?})").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"X "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"a"));
        witness.add(new Token(1000, (Object)" "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"-12.550"));
        witness.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        witness.add(new Token(1000, (Object)"hello "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"class"));
        ArrayList<String> ol = new ArrayList<String>();
        ol.add(".4?");
        witness.add(new Token(1006, ol));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testMultipleRecursion() throws ScanException {
        List tl = new TokenStream("%-1(%d %45(%class %file))").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"-1"));
        witness.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"d"));
        witness.add(new Token(1000, (Object)" "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"45"));
        witness.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"class"));
        witness.add(new Token(1000, (Object)" "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"file"));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testNested() throws ScanException {
        List tl = new TokenStream("%(%a%(%b))").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"a"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"b"));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testEscapedParanteheses() throws ScanException {
        List tl = new TokenStream("\\(%h\\)").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"("));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"h"));
        witness.add(new Token(1000, (Object)")"));
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("(%h\\)").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"("));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"h"));
        witness.add(new Token(1000, (Object)")"));
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void testWindowsLikeBackSlashes() throws ScanException {
        List tl = new TokenStream("c:\\hello\\world.%i", (IEscapeUtil)new AlmostAsIsEscapeUtil()).tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"c:\\hello\\world."));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"i"));
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void compositedKeyword() throws ScanException {
        List tl = new TokenStream("%d(A)", (IEscapeUtil)new AlmostAsIsEscapeUtil()).tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1005, (Object)"d"));
        witness.add(new Token(1000, (Object)"A"));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(witness, (Object)tl);
        tl = new TokenStream("a %subst(%b C)", (IEscapeUtil)new AlmostAsIsEscapeUtil()).tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"a "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1005, (Object)"subst"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"b"));
        witness.add(new Token(1000, (Object)" C"));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(witness, (Object)tl);
    }

    @Test
    public void compositedKeywordFollowedByOptions() throws ScanException {
        List tl = new TokenStream("%d(A){o}", (IEscapeUtil)new AlmostAsIsEscapeUtil()).tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1005, (Object)"d"));
        witness.add(new Token(1000, (Object)"A"));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        ArrayList<String> ol = new ArrayList<String>();
        ol.add("o");
        witness.add(new Token(1006, ol));
        Assert.assertEquals(witness, (Object)tl);
    }
}

