/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameUtilTest {
    Encoder<Object> encoder;
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);
    long currentTime = System.currentTimeMillis();
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDirAsStr = "target/test-output/" + this.diff + "/";
    protected File randomOutputDir = new File(this.randomOutputDirAsStr);

    @Before
    public void setUp() throws Exception {
        this.encoder = new EchoEncoder();
        this.randomOutputDir.mkdirs();
    }

    @Test
    public void renameToNonExistingDirectory() throws IOException, RolloverFailure {
        RenameUtil renameUtil = new RenameUtil();
        renameUtil.setContext(this.context);
        int diff2 = RandomUtil.getPositiveInt();
        File fromFile = File.createTempFile("from" + this.diff, "test", this.randomOutputDir);
        String randomTARGETDir = "target/test-output/" + diff2;
        renameUtil.rename(fromFile.toString(), new File(randomTARGETDir + "/to.test").toString());
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.context);
        Assert.assertTrue((boolean)this.statusChecker.isErrorFree());
    }
}

