/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public class ResilienceUtil {
    public static void verify(String logfile, String regexp, long totalSteps, double successRatioLowerBound) throws NumberFormatException, IOException {
        String line;
        FileReader fr = new FileReader(logfile);
        BufferedReader br = new BufferedReader(fr);
        Pattern p = Pattern.compile(regexp);
        int totalLines = 0;
        int oldNum = -1;
        int gaps = 0;
        while ((line = br.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            ++totalLines;
            String g = m.group(1);
            int num = Integer.parseInt(g);
            if (num != oldNum + 1) {
                ++gaps;
            }
            oldNum = num;
        }
        fr.close();
        br.close();
        int lowerLimit = (int)((double)totalSteps * successRatioLowerBound);
        Assert.assertTrue((String)("totalLines=" + totalLines + " less than " + lowerLimit), (totalLines > lowerLimit ? 1 : 0) != 0);
        Assert.assertTrue((String)("gaps=" + gaps + " less than 3"), (gaps >= 3 ? 1 : 0) != 0);
    }
}

