/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.pattern.parser.SamplePatternLayout;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OutputStreamAppenderTest {
    Context context = new ContextBase();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void smoke() {
        String FILE_HEADER = "FILE_HEADER ";
        String PRESENTATION_HEADER = "PRESENTATION_HEADER";
        String PRESENTATION_FOOTER = "PRESENTATION_FOOTER ";
        String FILE_FOOTER = "FILE_FOOTER";
        this.headerFooterCheck(FILE_HEADER, PRESENTATION_HEADER, PRESENTATION_FOOTER, FILE_FOOTER);
    }

    @Test
    public void nullFileHeader() {
        String FILE_HEADER = null;
        String PRESENTATION_HEADER = "PRESENTATION_HEADER";
        String PRESENTATION_FOOTER = "PRESENTATION_FOOTER ";
        String FILE_FOOTER = "FILE_FOOTER";
        this.headerFooterCheck(FILE_HEADER, PRESENTATION_HEADER, PRESENTATION_FOOTER, FILE_FOOTER);
    }

    @Test
    public void nullPresentationHeader() {
        String FILE_HEADER = "FILE_HEADER ";
        String PRESENTATION_HEADER = null;
        String PRESENTATION_FOOTER = "PRESENTATION_FOOTER ";
        String FILE_FOOTER = "FILE_FOOTER";
        this.headerFooterCheck(FILE_HEADER, PRESENTATION_HEADER, PRESENTATION_FOOTER, FILE_FOOTER);
    }

    @Test
    public void nullPresentationFooter() {
        String FILE_HEADER = "FILE_HEADER ";
        String PRESENTATION_HEADER = "PRESENTATION_HEADER";
        String PRESENTATION_FOOTER = null;
        String FILE_FOOTER = "FILE_FOOTER";
        this.headerFooterCheck(FILE_HEADER, PRESENTATION_HEADER, PRESENTATION_FOOTER, FILE_FOOTER);
    }

    @Test
    public void nullFileFooter() {
        String FILE_HEADER = "FILE_HEADER ";
        String PRESENTATION_HEADER = "PRESENTATION_HEADER";
        String PRESENTATION_FOOTER = "PRESENTATION_FOOTER ";
        String FILE_FOOTER = null;
        this.headerFooterCheck(FILE_HEADER, PRESENTATION_HEADER, PRESENTATION_FOOTER, FILE_FOOTER);
    }

    public void headerFooterCheck(String fileHeader, String presentationHeader, String presentationFooter, String fileFooter) {
        OutputStreamAppender wa = new OutputStreamAppender();
        wa.setContext(this.context);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SamplePatternLayout spl = new SamplePatternLayout();
        spl.setContext(this.context);
        spl.setFileHeader(fileHeader);
        spl.setPresentationHeader(presentationHeader);
        spl.setPresentationFooter(presentationFooter);
        spl.setFileFooter(fileFooter);
        spl.start();
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        encoder.setLayout(spl);
        encoder.setContext(this.context);
        wa.setEncoder((Encoder)encoder);
        wa.setOutputStream((OutputStream)baos);
        wa.start();
        wa.stop();
        String result = baos.toString();
        String expectedHeader = this.emtptyIfNull(fileHeader) + this.emtptyIfNull(presentationHeader);
        Assert.assertTrue((String)result, (boolean)result.startsWith(expectedHeader));
        String expectedFooter = this.emtptyIfNull(presentationFooter) + this.emtptyIfNull(fileFooter);
        Assert.assertTrue((String)result, (boolean)result.endsWith(expectedFooter));
    }

    String emtptyIfNull(String s) {
        return s == null ? "" : s;
    }
}

