/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBufferTracker_TImpl<E>
implements CyclicBufferTracker<E> {
    int bufferSize = 256;
    int maxNumBuffers = 64;
    List<TEntry> entryList = new LinkedList<TEntry>();
    long lastCheck = 0L;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
    }

    public int getMaxNumberOfBuffers() {
        return this.maxNumBuffers;
    }

    public void setMaxNumberOfBuffers(int maxNumBuffers) {
        this.maxNumBuffers = maxNumBuffers;
    }

    private TEntry getEntry(String k) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            TEntry te = this.entryList.get(i);
            if (!te.key.equals(k)) continue;
            return te;
        }
        return null;
    }

    List<String> keyList() {
        Collections.sort(this.entryList);
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < this.entryList.size(); ++i) {
            TEntry te = this.entryList.get(i);
            result.add(te.key);
        }
        return result;
    }

    public CyclicBuffer<E> getOrCreate(String key, long timestamp) {
        TEntry te = this.getEntry(key);
        if (te == null) {
            CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
            te = new TEntry(key, cb, timestamp);
            this.entryList.add(te);
            if (this.entryList.size() >= this.maxNumBuffers) {
                this.entryList.remove(0);
            }
            return cb;
        }
        te.timestamp = timestamp;
        Collections.sort(this.entryList);
        return te.value;
    }

    public void removeBuffer(String k) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            TEntry te = this.entryList.get(i);
            if (!te.key.equals(k)) continue;
            this.entryList.remove(i);
            return;
        }
    }

    private final boolean isEntryStale(TEntry entry, long now) {
        return entry.timestamp + 1800000L < now;
    }

    public void clearStaleBuffers(long now) {
        if (this.lastCheck + 1000L > now) {
            return;
        }
        this.lastCheck = now;
        Collections.sort(this.entryList);
        while (this.entryList.size() != 0 && this.isEntryStale(this.entryList.get(0), now)) {
            this.entryList.remove(0);
        }
    }

    public int size() {
        return this.entryList.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TEntry<E>
    implements Comparable {
        TEntry next;
        TEntry prev;
        String key;
        CyclicBuffer<E> value;
        long timestamp;

        TEntry(String k, CyclicBuffer<E> v, long timestamp) {
            this.key = k;
            this.value = v;
            this.timestamp = timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public int compareTo(Object o) {
            if (!(o instanceof TEntry)) {
                throw new IllegalArgumentException("arguments must be of type " + TEntry.class);
            }
            TEntry other = (TEntry)o;
            if (this.timestamp > other.timestamp) {
                return 1;
            }
            if (this.timestamp == other.timestamp) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TEntry other = (TEntry)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

