/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.helper.Compress;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Compare;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CompressTest
extends TestCase {
    Compress compress;
    Context context = new ContextBase();

    public CompressTest(String arg0) {
        super(arg0);
        this.compress = new Compress();
        this.compress.setContext(this.context);
    }

    public void setUp() throws IOException {
        File source = new File("src/test/input/compress1.copy");
        File dest = new File("src/test/input/compress1.txt");
        this.copy(source, dest);
        File target = new File("src/test/output/compress1.txt.gz");
        target.mkdirs();
        target.delete();
        source = new File("src/test/input/compress2.copy");
        dest = new File("src/test/input/compress2.txt");
        this.copy(source, dest);
        target = new File("src/test/output/compress2.txt.gz");
        target.mkdirs();
        target.delete();
        source = new File("src/test/input/compress3.copy");
        dest = new File("src/test/input/compress3.txt");
        this.copy(source, dest);
        target = new File("src/test/output/compress3.txt.zip");
        target.mkdirs();
        target.delete();
    }

    public void tearDown() {
    }

    public void test1() throws Exception {
        this.compress.GZCompress("src/test/input/compress1.txt", "src/test/output/compress1.txt.gz");
        StatusPrinter.print((StatusManager)this.context.getStatusManager());
        CompressTest.assertEquals((int)0, (int)this.context.getStatusManager().getCount());
        CompressTest.assertTrue((boolean)Compare.gzCompare("src/test/output/compress1.txt.gz", "src/test/witness/compress1.txt.gz"));
    }

    public void test2() throws Exception {
        this.compress.GZCompress("src/test/input/compress2.txt", "src/test/output/compress2.txt");
        StatusPrinter.print((StatusManager)this.context.getStatusManager());
        CompressTest.assertEquals((int)0, (int)this.context.getStatusManager().getCount());
        CompressTest.assertTrue((boolean)Compare.gzCompare("src/test/output/compress2.txt.gz", "src/test/witness/compress2.txt.gz"));
    }

    public void test3() throws Exception {
        this.compress.ZIPCompress("src/test/input/compress3.txt", "src/test/output/compress3.txt");
        StatusPrinter.print((StatusManager)this.context.getStatusManager());
        CompressTest.assertEquals((int)0, (int)this.context.getStatusManager().getCount());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new CompressTest("test1"));
        suite.addTest((Test)new CompressTest("test2"));
        suite.addTest((Test)new CompressTest("test3"));
        return suite;
    }

    private void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

