/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.BadBeginAction;
import ch.qos.logback.core.joran.action.BadEndAction;
import ch.qos.logback.core.joran.action.HelloAction;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.action.TouchAction;
import ch.qos.logback.core.joran.spi.Pattern;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SkippingInInterpreterTest
extends TestCase {
    HashMap<Pattern, Action> rulesMap = new HashMap();
    Context context = new ContextBase();

    public SkippingInInterpreterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    SAXParser createParser() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        return spf.newSAXParser();
    }

    public void testChildrenSkipping() throws Exception {
        this.rulesMap.put(new Pattern("test"), (Action)new NOPAction());
        this.rulesMap.put(new Pattern("test/badBegin"), new BadBeginAction());
        this.rulesMap.put(new Pattern("test/badBegin/touch"), new TouchAction());
        this.rulesMap.put(new Pattern("test/hello"), new HelloAction());
        TrivialConfigurator tc = new TrivialConfigurator(this.rulesMap);
        tc.setContext(this.context);
        tc.doConfigure("src/test/input/joran/exception1.xml");
        String str = this.context.getProperty("hello");
        SkippingInInterpreterTest.assertEquals((String)"Hello John Doe.", (String)str);
        String i = (String)this.context.getObject(TouchAction.KEY);
        SkippingInInterpreterTest.assertNull((Object)i);
    }

    public void testSkipSiblings() throws Exception {
        this.rulesMap.put(new Pattern("test"), (Action)new NOPAction());
        this.rulesMap.put(new Pattern("test/badEnd"), new BadEndAction());
        this.rulesMap.put(new Pattern("test/badEnd/touch"), new TouchAction());
        this.rulesMap.put(new Pattern("test/hello"), new HelloAction());
        TrivialConfigurator tc = new TrivialConfigurator(this.rulesMap);
        tc.setContext(this.context);
        tc.doConfigure("src/test/input/joran/badEnd1.xml");
        String str = this.context.getProperty("hello");
        SkippingInInterpreterTest.assertNull((Object)str);
        Integer i = (Integer)this.context.getObject(TouchAction.KEY);
        SkippingInInterpreterTest.assertEquals((int)2, (int)i);
    }

    public void testSkipSiblings2() throws Exception {
        this.rulesMap.put(new Pattern("test"), (Action)new NOPAction());
        this.rulesMap.put(new Pattern("test/isolate/badEnd"), new BadEndAction());
        this.rulesMap.put(new Pattern("*/touch"), new TouchAction());
        this.rulesMap.put(new Pattern("test/hello"), new HelloAction());
        TrivialConfigurator tc = new TrivialConfigurator(this.rulesMap);
        tc.setContext(this.context);
        tc.doConfigure("src/test/input/joran/badEnd2.xml");
        String str = this.context.getProperty("hello");
        SkippingInInterpreterTest.assertEquals((String)"Hello John Doe.", (String)str);
        Integer i = (Integer)this.context.getObject(TouchAction.KEY);
        SkippingInInterpreterTest.assertEquals((int)1, (int)i);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SkippingInInterpreterTest.class);
        return suite;
    }
}

