/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.IncAction;
import ch.qos.logback.core.joran.action.IncludeAction;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.xml.sax.SAXParseException;

public class IncludeActionTest
extends TestCase {
    static final String FILE_KEY = "testing";
    Context context = new ContextBase();
    TrivialConfigurator tc;
    static final String INCLUSION_DIR_PREFIX = "src/test/input/joran/inclusion/";
    static final String INCLUDE_BY_FILE = "src/test/input/joran/inclusion/includeByFile.xml";
    static final String INCLUDE_BY_URL = "src/test/input/joran/inclusion/includeByUrl.xml";
    static final String INCLUDE_BY_RESOURCE = "src/test/input/joran/inclusion/includeByResource.xml";
    static final String INCLUDED_FILE = "src/test/input/joran/inclusion/included.xml";
    static final String URL_TO_INCLUDE = "file:./src/test/input/joran/inclusion/included.xml";
    static final String INVALID = "src/test/input/joran/inclusion/invalid.xml";
    static final String INCLUDED_AS_RESOURCE = "input/joran/inclusion/includedAsResource.xml";

    public IncludeActionTest(String arg0) {
        super(arg0);
        HashMap<Pattern, Action> rulesMap = new HashMap<Pattern, Action>();
        rulesMap.put(new Pattern("x"), (Action)new NOPAction());
        rulesMap.put(new Pattern("x/inc"), new IncAction());
        rulesMap.put(new Pattern("x/include"), (Action)new IncludeAction());
        this.tc = new TrivialConfigurator(rulesMap);
        this.tc.setContext(this.context);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IncAction.beginCount = 0;
        IncAction.errorCount = 0;
        IncAction.endCount = 0;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.context = null;
        System.clearProperty(FILE_KEY);
    }

    public void testBasicFile() throws JoranException {
        System.setProperty(FILE_KEY, INCLUDED_FILE);
        this.tc.doConfigure(INCLUDE_BY_FILE);
        this.verifyConfig(2);
    }

    public void testBasicResource() throws JoranException {
        System.setProperty(FILE_KEY, INCLUDED_AS_RESOURCE);
        this.tc.doConfigure(INCLUDE_BY_RESOURCE);
        StatusPrinter.print((Context)this.context);
        this.verifyConfig(2);
    }

    public void testBasicURL() throws JoranException {
        System.setProperty(FILE_KEY, URL_TO_INCLUDE);
        this.tc.doConfigure(INCLUDE_BY_URL);
        StatusPrinter.print((Context)this.context);
        this.verifyConfig(2);
    }

    public void testNoFileFound() throws JoranException {
        System.setProperty(FILE_KEY, "toto");
        this.tc.doConfigure(INCLUDE_BY_FILE);
        IncludeActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getLevel());
        StatusChecker sc = new StatusChecker(this.context.getStatusManager());
        IncludeActionTest.assertTrue((boolean)sc.containsException(FileNotFoundException.class));
    }

    public void testWithCorruptFile() throws JoranException {
        System.setProperty(FILE_KEY, INVALID);
        this.tc.doConfigure(INCLUDE_BY_FILE);
        IncludeActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getLevel());
        StatusChecker sc = new StatusChecker(this.context.getStatusManager());
        IncludeActionTest.assertTrue((boolean)sc.containsException(SAXParseException.class));
    }

    public void testMalformedURL() throws JoranException {
        System.setProperty(FILE_KEY, "htp://logback.qos.ch");
        this.tc.doConfigure(INCLUDE_BY_URL);
        IncludeActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getLevel());
        StatusChecker sc = new StatusChecker(this.context.getStatusManager());
        IncludeActionTest.assertTrue((boolean)sc.containsException(MalformedURLException.class));
    }

    public void testUnknownURL() throws JoranException {
        System.setProperty(FILE_KEY, "http://logback2345.qos.ch");
        this.tc.doConfigure(INCLUDE_BY_URL);
        IncludeActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getLevel());
        StatusChecker sc = new StatusChecker(this.context.getStatusManager());
        IncludeActionTest.assertTrue((boolean)sc.containsException(UnknownHostException.class));
    }

    void verifyConfig(int expected) {
        IncludeActionTest.assertEquals((int)expected, (int)IncAction.beginCount);
        IncludeActionTest.assertEquals((int)expected, (int)IncAction.endCount);
    }
}

