/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.StopWatch;
import junit.framework.TestCase;

public class StopWatchTest
extends TestCase {
    public StopWatchTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBasic() throws InterruptedException {
        StopWatch sw = new StopWatch("testBasic");
        long d = sw.startTime + 10L;
        String s = sw.stop(d).toString();
        StopWatchTest.assertTrue((boolean)s.endsWith("10 nanoseconds."));
        d = sw.startTime + 9000L;
        s = sw.stop(d).toString();
        StopWatchTest.assertTrue((boolean)s.endsWith("9000 nanoseconds."));
        d = sw.startTime + 11000L;
        s = sw.stop(d).toString();
        StopWatchTest.assertTrue((boolean)s.endsWith("11 microseconds."));
        d = sw.startTime + 9000000L;
        s = sw.stop(d).toString();
        StopWatchTest.assertTrue((boolean)s.endsWith("9000 microseconds."));
        d = sw.startTime + 3000000000L;
        s = sw.stop(d).toString();
        StopWatchTest.assertTrue((boolean)s.endsWith("3000 milliseconds."));
        d = sw.startTime + 6000000000L;
        s = sw.stop(d).toString();
        StopWatchTest.assertTrue((boolean)s.endsWith("6.000 seconds."));
    }

    public void testSelectDurationUnitForDisplay() throws InterruptedException {
        StopWatch sw = new StopWatch("testBasic");
        StopWatchTest.assertEquals((Object)StopWatch.DurationUnit.NANOSECOND, (Object)sw.selectDurationUnitForDisplay(10L));
        StopWatchTest.assertEquals((Object)StopWatch.DurationUnit.NANOSECOND, (Object)sw.selectDurationUnitForDisplay(9000L));
        StopWatchTest.assertEquals((Object)StopWatch.DurationUnit.MICROSECOND, (Object)sw.selectDurationUnitForDisplay(11000L));
        StopWatchTest.assertEquals((Object)StopWatch.DurationUnit.MICROSECOND, (Object)sw.selectDurationUnitForDisplay(9000000L));
        StopWatchTest.assertEquals((Object)StopWatch.DurationUnit.MILLISSECOND, (Object)sw.selectDurationUnitForDisplay(11000000L));
        StopWatchTest.assertEquals((Object)StopWatch.DurationUnit.MILLISSECOND, (Object)sw.selectDurationUnitForDisplay(3000000000L));
        StopWatchTest.assertEquals((Object)StopWatch.DurationUnit.SECOND, (Object)sw.selectDurationUnitForDisplay(6000000000L));
    }
}

