/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.replay;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.replay.FruitContext;
import ch.qos.logback.core.joran.replay.FruitShell;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class FruitShellAction
extends Action {
    FruitShell fruitShell;
    private boolean inError = false;

    public void begin(InterpretationContext ec, String name, Attributes attributes) throws ActionException {
        this.fruitShell = new FruitShell();
        this.inError = false;
        try {
            this.fruitShell.setContext(this.context);
            String shellName = attributes.getValue("name");
            if (OptionHelper.isEmpty((String)shellName)) {
                this.addWarn("No appender name given for fruitShell].");
            } else {
                this.fruitShell.setName(shellName);
                this.addInfo("FruitShell named as [" + shellName + "]");
            }
            ec.pushObject((Object)this.fruitShell);
        }
        catch (Exception oops) {
            this.inError = true;
            this.addError("Could not create an FruitShell", oops);
            throw new ActionException(1, (Throwable)oops);
        }
    }

    public void end(InterpretationContext ec, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Object o = ec.peekObject();
        if (o != this.fruitShell) {
            this.addWarn("The object at the of the stack is not the fruitShell named [" + this.fruitShell.getName() + "] pushed earlier.");
        } else {
            this.addInfo("Popping fruitSHell named [" + this.fruitShell.getName() + "] from the object stack");
            ec.popObject();
            FruitContext fruitContext = (FruitContext)ec.getContext();
            fruitContext.addFruitShell(this.fruitShell);
        }
    }
}

