/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMTPAppenderBase<E>
extends AppenderBase<E> {
    protected Layout<E> layout;
    protected Layout<E> subjectLayout;
    private List<String> to = new ArrayList<String>();
    private String from;
    private String subjectStr = null;
    private String smtpHost;
    protected Message msg;
    protected EventEvaluator eventEvaluator;

    protected abstract Layout<E> makeSubjectLayout(String var1);

    @Override
    public void start() {
        Properties props = new Properties(System.getProperties());
        if (this.smtpHost != null) {
            props.put("mail.smtp.host", this.smtpHost);
        }
        Session session = Session.getInstance((Properties)props, null);
        this.msg = new MimeMessage(session);
        try {
            if (this.from != null) {
                this.msg.setFrom((Address)this.getAddress(this.from));
            } else {
                this.msg.setFrom();
            }
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
            this.subjectLayout = this.makeSubjectLayout(this.subjectStr);
            this.started = true;
        }
        catch (MessagingException e) {
            this.addError("Could not activate SMTPAppender options.", e);
        }
    }

    @Override
    protected void append(E eventObject) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(eventObject);
        try {
            if (this.eventEvaluator.evaluate(eventObject)) {
                this.sendBuffer(eventObject);
            }
        }
        catch (EvaluationException ex) {
            this.addError("SMTPAppender's EventEvaluator threw an Exception" + ex);
        }
    }

    protected abstract void subAppend(E var1);

    public boolean checkEntryConditions() {
        if (!this.started) {
            this.addError("Attempting to append to a non-started appender: " + this.getName());
            return false;
        }
        if (this.msg == null) {
            this.addError("Message object not configured.");
            return false;
        }
        if (this.eventEvaluator == null) {
            this.addError("No EventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.addError("No layout set for appender named [" + this.name + "]. For more information, please visit http://logback.qos.ch/codes.html#smtp_no_layout");
            return false;
        }
        return true;
    }

    @Override
    public synchronized void stop() {
        this.started = false;
    }

    InternetAddress getAddress(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            this.addError("Could not parse address [" + addressStr + "].", e);
            return null;
        }
    }

    InternetAddress[] parseAddress(List<String> addressList) {
        InternetAddress[] iaArray = new InternetAddress[addressList.size()];
        for (int i = 0; i < addressList.size(); ++i) {
            try {
                InternetAddress[] tmp = InternetAddress.parse((String)addressList.get(i), (boolean)true);
                iaArray[i] = tmp[0];
                continue;
            }
            catch (AddressException e) {
                this.addError("Could not parse address [" + addressList.get(i) + "].", e);
                return null;
            }
        }
        return iaArray;
    }

    public List<String> getTo() {
        return this.to;
    }

    protected void sendBuffer(E lastEventObject) {
        try {
            String presentationFooter;
            String presentationHeader;
            MimeBodyPart part = new MimeBodyPart();
            StringBuffer sbuf = new StringBuffer();
            String header = this.layout.getFileHeader();
            if (header != null) {
                sbuf.append(header);
            }
            if ((presentationHeader = this.layout.getPresentationHeader()) != null) {
                sbuf.append(presentationHeader);
            }
            this.fillBuffer(sbuf);
            String footer = this.layout.getFileFooter();
            if (footer != null) {
                sbuf.append(footer);
            }
            if ((presentationFooter = this.layout.getPresentationFooter()) != null) {
                sbuf.append(presentationFooter);
            }
            if (this.subjectLayout != null) {
                this.msg.setSubject(this.subjectLayout.doLayout(lastEventObject));
            }
            part.setContent((Object)sbuf.toString(), this.layout.getContentType());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            this.msg.setContent((Multipart)mp);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
        }
        catch (Exception e) {
            this.addError("Error occured while sending e-mail notification.", e);
        }
    }

    protected abstract void fillBuffer(StringBuffer var1);

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subjectStr;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSubject(String subject) {
        this.subjectStr = subject;
    }

    public void setSMTPHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void addTo(String to) {
        this.to.add(to);
    }

    public Message getMessage() {
        return this.msg;
    }

    public void setMessage(Message msg) {
        this.msg = msg;
    }

    public void setEvaluator(EventEvaluator eventEvaluator) {
        this.eventEvaluator = eventEvaluator;
    }

    @Override
    public Layout<E> getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }
}

