/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.CoreTestConstants;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileFilter;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t}g\u0001B\u0001\u0003\u00015\u0011\u0001\u0006V5nK\n\u000b7/\u001a3S_2d\u0017N\\4XSRD\u0017I]2iSZ,'+Z7pm\u0006dwl\u0015+fgRT!a\u0001\u0003\u0002\u000fI|G\u000e\\5oO*\u0011QAB\u0001\u0005G>\u0014XM\u0003\u0002\b\u0011\u00059An\\4cC\u000e\\'BA\u0005\u000b\u0003\r\txn\u001d\u0006\u0002\u0017\u0005\u00111\r[\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\tY1kY1mC>\u0013'.Z2u\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001C\u0004#\u0001\u0001\u0007I\u0011A\u0012\u0002\u000f\r|g\u000e^3yiV\tA\u0005\u0005\u0002&M5\tA!\u0003\u0002(\t\t91i\u001c8uKb$\bbB\u0015\u0001\u0001\u0004%\tAK\u0001\fG>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0002,]A\u0011q\u0003L\u0005\u0003[a\u0011A!\u00168ji\"9q\u0006KA\u0001\u0002\u0004!\u0013a\u0001=%c!1\u0011\u0007\u0001Q!\n\u0011\n\u0001bY8oi\u0016DH\u000f\t\u0005\bg\u0001\u0001\r\u0011\"\u00015\u0003\u001d)gnY8eKJ,\u0012!\u000e\t\u0004maRT\"A\u001c\u000b\u0005M\"\u0011BA\u001d8\u0005-)5\r[8F]\u000e|G-\u001a:\u0011\u0005]Y\u0014B\u0001\u001f\u0019\u0005\u0019\te.\u001f*fM\"9a\b\u0001a\u0001\n\u0003y\u0014aC3oG>$WM]0%KF$\"a\u000b!\t\u000f=j\u0014\u0011!a\u0001k!1!\t\u0001Q!\nU\n\u0001\"\u001a8d_\u0012,'\u000f\t\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0003QiuJ\u0014+I\u0019f{F)\u0011+F?B\u000bE\u000bV#S\u001dV\ta\t\u0005\u0002H\u0015:\u0011q\u0003S\u0005\u0003\u0013b\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011\n\u0007\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002$\u0002+5{e\n\u0016%M3~#\u0015\tV#`!\u0006#F+\u0012*OA!9\u0001\u000b\u0001b\u0001\n\u0003)\u0015!H'P\u001dRCE*W0D%>su\nT(H?\u0012\u000bE+R0Q\u0003R#VI\u0015(\t\rI\u0003\u0001\u0015!\u0003G\u0003yiuJ\u0014+I\u0019f{6IU(O\u001f2{ui\u0018#B)\u0016{\u0006+\u0011+U\u000bJs\u0005\u0005C\u0004U\u0001\t\u0007IQA#\u00027\u0011\u000b\u0015\nT-`\u0007J{ej\u0014'P\u000f~#\u0015\tV#`!\u0006#F+\u0012*O\u0011\u00191\u0006\u0001)A\u0007\r\u0006aB)Q%M3~\u001b%k\u0014(P\u0019>;u\fR!U\u000b~\u0003\u0016\t\u0016+F%:\u0003\u0003b\u0002-\u0001\u0005\u0004%\t!W\u0001\u0011\u001b&cE*S*`\u0013:{V*\u0013(V)\u0016+\u0012A\u0017\t\u0003/mK!\u0001\u0018\r\u0003\t1{gn\u001a\u0005\u0007=\u0002\u0001\u000b\u0011\u0002.\u0002#5KE\nT%T?&su,T%O+R+\u0005\u0005C\u0004a\u0001\t\u0007I\u0011A-\u0002\u001d5KE\nT%T?&su\fS(V%\"1!\r\u0001Q\u0001\ni\u000bq\"T%M\u0019&\u001bv,\u0013(`\u0011>+&\u000b\t\u0005\bI\u0002\u0011\r\u0011\"\u0001Z\u00035i\u0015\n\u0014'J'~Kej\u0018#B3\"1a\r\u0001Q\u0001\ni\u000ba\"T%M\u0019&\u001bv,\u0013(`\t\u0006K\u0006\u0005C\u0004i\u0001\t\u0007I\u0011A-\u0002\u001f5KE\nT%T?&su,T(O)\"CaA\u001b\u0001!\u0002\u0013Q\u0016\u0001E'J\u00192K5kX%O?6{e\n\u0016%!\u0011\u001da\u0007\u00011A\u0005\u00025\fA\u0001Z5gMV\ta\u000e\u0005\u0002\u0018_&\u0011\u0001\u000f\u0007\u0002\u0004\u0013:$\bb\u0002:\u0001\u0001\u0004%\ta]\u0001\tI&4gm\u0018\u0013fcR\u00111\u0006\u001e\u0005\b_E\f\t\u00111\u0001o\u0011\u00191\b\u0001)Q\u0005]\u0006)A-\u001b4gA!9\u0001\u0010\u0001a\u0001\n\u0003)\u0015a\u0004:b]\u0012|WnT;uaV$H)\u001b:\t\u000fi\u0004\u0001\u0019!C\u0001w\u0006\u0019\"/\u00198e_6|U\u000f\u001e9vi\u0012K'o\u0018\u0013fcR\u00111\u0006 \u0005\b_e\f\t\u00111\u0001G\u0011\u0019q\b\u0001)Q\u0005\r\u0006\u0001\"/\u00198e_6|U\u000f\u001e9vi\u0012K'\u000f\t\u0005\t\u0003\u0003\u0001\u0001\u0019!C\u0001[\u0006Q1\u000f\\1tQ\u000e{WO\u001c;\t\u0013\u0005\u0015\u0001\u00011A\u0005\u0002\u0005\u001d\u0011AD:mCND7i\\;oi~#S-\u001d\u000b\u0004W\u0005%\u0001\u0002C\u0018\u0002\u0004\u0005\u0005\t\u0019\u00018\t\u000f\u00055\u0001\u0001)Q\u0005]\u0006Y1\u000f\\1tQ\u000e{WO\u001c;!\u0011%\t\t\u0002\u0001a\u0001\n\u0003\t\u0019\"A\u0004uE\u001at\u0017\r\u001e9\u0016\u0005\u0005U\u0001\u0003\u0002\u0011\u0002\u0018iJ1!!\u0007\u0003\u0005\u0019\"\u0016.\\3CCN,GMR5mK:\u000bW.\u001b8h\u0003:$GK]5hO\u0016\u0014\u0018N\\4Q_2L7-\u001f\u0005\n\u0003;\u0001\u0001\u0019!C\u0001\u0003?\t1\u0002\u001e2g]\u0006$\bo\u0018\u0013fcR\u00191&!\t\t\u0013=\nY\"!AA\u0002\u0005U\u0001\u0002CA\u0013\u0001\u0001\u0006K!!\u0006\u0002\u0011Q\u0014gM\\1ua\u0002B\u0001\"!\u000b\u0001\u0005\u0004%\t!W\u0001\u0004]><\bbBA\u0017\u0001\u0001\u0006IAW\u0001\u0005]><\b\u0005C\u0004\u00022\u0001!\t!a\r\u0002\u000bM,G/\u00169\u0016\u0003-BC!a\f\u00028A!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012!\u00026v]&$(BAA!\u0003\ry'oZ\u0005\u0005\u0003\u000b\nYD\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003\u0013\u0002A\u0011AA&\u0003E\u0019w.\u001c9vi\u0016\u001cF.Y:i\u0007>,h\u000e\u001e\u000b\u0004]\u00065\u0003bBA(\u0003\u000f\u0002\rAR\u0001\fI\u0006$X\rU1ui\u0016\u0014h\u000eC\u0004\u0002T\u0001!\t!!\u0016\u0002#\u001d,g.T8oi2L(k\u001c7m_Z,'\u000fF\u0005,\u0003/\nY&a\u0018\u0002d!9\u0011\u0011LA)\u0001\u0004q\u0017AC7bq\"K7\u000f^8ss\"9\u0011QLA)\u0001\u0004q\u0017\u0001G:j[Vd\u0017\r^3e\u001dVl'-\u001a:PMB+'/[8eg\"9\u0011\u0011MA)\u0001\u0004q\u0017aD:uCJ$\u0018J\\1di&4\u0018\u000e^=\t\u000f\u0005\u0015\u0014\u0011\u000ba\u0001]\u0006!b.^7J]\u0006\u001cG/\u001b<jif\u0004VM]5pINDq!!\u001b\u0001\t\u0003\t\u0019$\u0001\bn_:$H.\u001f*pY2|g/\u001a:)\t\u0005\u001d\u0014Q\u000e\t\u0005\u0003s\ty'\u0003\u0003\u0002r\u0005m\"\u0001\u0002+fgRDq!!\u001e\u0001\t\u0003\t\u0019$\u0001\u0010n_:$\b\u000e\\=S_2dwN^3s\u001fZ,'/T1osB+'/[8eg\"\"\u00111OA7\u0011\u001d\tY\b\u0001C\u0001\u0003g\tQ\u0002Z1jYf\u0014v\u000e\u001c7pm\u0016\u0014\b\u0006BA=\u0003[Bq!!!\u0001\t\u0003\t\u0019$\u0001\u000feC&d\u0017PU8mY>4XM],ji\"\u001cVmY8oIBC\u0017m]3)\t\u0005}\u0014Q\u000e\u0005\b\u0003\u000f\u0003A\u0011AA\u001a\u0003U!\u0017-\u001b7z\u0007J|gn\u001c7pOJ{G\u000e\\8wKJDC!!\"\u0002n!9\u0011Q\u0012\u0001\u0005\u0002\u0005M\u0012A\u00063bS2L8+\u001b>f\u0005\u0006\u001cX\r\u001a*pY2|g/\u001a:)\t\u0005-\u0015Q\u000e\u0005\b\u0003'\u0003A\u0011AA\u001a\u0003}!\u0017-\u001b7z\u0007\"\u0014xN\\8m_\u001e\u001c\u0016N_3CCN,GMU8mY>4XM\u001d\u0015\u0005\u0003#\u000bi\u0007C\u0004\u0002\u001a\u0002!\t!a\r\u0002]\u0011\f\u0017\u000e\\=DQJ|gn\u001c7pONK'0\u001a\"bg\u0016$'k\u001c7m_Z,'oV5uQN+7m\u001c8e!\"\f7/\u001a\u0015\u0005\u0003/\u000bi\u0007C\u0004\u0002 \u0002!\t!a\r\u0002\u000b\u0012\f\u0017\u000e\\=DQJ|gn\u001c7pONK'0\u001a\"bg\u0016$'k\u001c7m_Z,'o\u00165f]2{wMR5mK:\fW.\u001a#pKNtu\u000e^\"p]R\f\u0017N\u001c#je\u0016\u001cGo\u001c:zQ\u0011\ti*!\u001c)\t\u0005u\u0015Q\u0015\t\u0005\u0003s\t9+\u0003\u0003\u0002*\u0006m\"AB%h]>\u0014X\rC\u0004\u0002.\u0002!\t!a,\u0002\u0017\u0015DHO]1G_2$WM\u001d\u000b\u000b\u0003c\u000b9,a/\u0002@\u0006\r\u0007cA\f\u00024&\u0019\u0011Q\u0017\r\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011XAV\u0001\u0004q\u0017A\u00038v[B+'/[8eg\"9\u0011QXAV\u0001\u0004q\u0017!\u00049fe&|Gm\u001d)fe\u0016\u0013\u0018\rC\u0004\u0002B\u0006-\u0006\u0019\u00018\u0002\u0017\t,w-\u001b8QKJLw\u000e\u001a\u0005\b\u00033\nY\u000b1\u0001o\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013\f\u0001$\u001a=qK\u000e$X\rZ\"pk:$x+\u001b;i\r>dG-\u001a:t)\u0015q\u00171ZAg\u0011\u001d\tI&!2A\u00029D\u0001\"!,\u0002F\u0002\u0007\u0011\u0011\u0017\u0005\b\u0003#\u0004A\u0011AAj\u0003\u001d\tG\r\u001a+j[\u0016$RAWAk\u00033Dq!a6\u0002P\u0002\u0007!,A\u0006dkJ\u0014XM\u001c;US6,\u0007bBAn\u0003\u001f\u0004\rAW\u0001\u000bi&lW\rV8XC&$\bbBAp\u0001\u0011\u0005\u0011\u0011]\u0001\u0013o\u0006LGOR8s\u0007>l\u0007O]3tg&|g\u000eF\u0002,\u0003GD\u0001\"!:\u0002^\u0002\u0007\u0011q]\u0001\u0005i\n\u0014\b\u000f\u0005\u0003!\u0003ST\u0014bAAv\u0005\t1B+[7f\u0005\u0006\u001cX\r\u001a*pY2Lgn\u001a)pY&\u001c\u0017\u0010C\u0004\u0002p\u0002!\t!!=\u0002\u0015\u0011|'k\u001c7m_Z,'\u000f\u0006\t\u0002t\u0006e\u00181`A\u0000\u0005\u0007\u0011)Aa\u0002\u0003\nA)q#!>[5&\u0019\u0011q\u001f\r\u0003\rQ+\b\u000f\\33\u0011\u001d\t9.!<A\u0002iCq!!@\u0002n\u0002\u0007a)A\bgS2,g*Y7f!\u0006$H/\u001a:o\u0011\u001d\u0011\t!!<A\u0002i\u000ba\u0003]3sS>$G)\u001e:bi&|g.\u00138NS2d\u0017n\u001d\u0005\b\u00033\ni\u000f1\u0001o\u0011\u001d\ti&!<A\u00029D\u0011\"!\u0019\u0002nB\u0005\t\u0019\u00018\t\u0013\u0005\u0015\u0014Q\u001eI\u0001\u0002\u0004q\u0007b\u0002B\u0007\u0001\u0011\u0005!qB\u0001\u001cKb\u0004Xm\u0019;fI\u000e{WO\u001c;XSRDw.\u001e;G_2$WM]:\u0015\u00079\u0014\t\u0002C\u0004\u0002Z\t-\u0001\u0019\u00018\t\u000f\tU\u0001\u0001\"\u0001\u0003\u0018\u0005\u0019r-\u001a8fe&\u001cg)\u001b8e\u001b\u0006$8\r[5oORY1F!\u0007\u00030\tM\"q\tB&\u0011!\u0011YBa\u0005A\u0002\tu\u0011!C7bi\u000eDg)\u001e8d!!9\"q\u0004B\u0012\r\u0006E\u0016b\u0001B\u00111\tIa)\u001e8di&|gN\r\t\u0005\u0005K\u0011Y#\u0004\u0002\u0003()\u0019!\u0011\u0006\n\u0002\u0005%|\u0017\u0002\u0002B\u0017\u0005O\u0011AAR5mK\"A!\u0011\u0007B\n\u0001\u0004\u0011\u0019#A\u0002eSJD\u0001B!\u000e\u0003\u0014\u0001\u0007!qG\u0001\tM&dW\rT5tiB1!\u0011\bB\"\u0005Gi!Aa\u000f\u000b\t\tu\"qH\u0001\b[V$\u0018M\u00197f\u0015\r\u0011\t\u0005G\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B#\u0005w\u0011!\u0002T5ti\n+hMZ3s\u0011%\u0011IEa\u0005\u0011\u0002\u0003\u0007a)A\u0004qCR$XM\u001d8\t\u0015\t5#1\u0003I\u0001\u0002\u0004\t\t,A\u0006j]\u000edW\u000fZ3ESJ\u001c\bb\u0002B)\u0001\u0011\u0005!1K\u0001\"M&tG-\u00117m\r>dG-\u001a:t\u0013:4u\u000e\u001c3feJ+7-\u001e:tSZ,G.\u001f\u000b\u0006W\tU#q\u000b\u0005\t\u0005c\u0011y\u00051\u0001\u0003$!A!Q\u0007B(\u0001\u0004\u00119\u0004C\u0004\u0003\\\u0001!\tA!\u0018\u0002W\u0019Lg\u000eZ!mY\u0012K'o](s'R\u0014\u0018N\\4D_:$\u0018-\u001b8t\r&dWm\u001d*fGV\u00148/\u001b<fYf$ra\u000bB0\u0005C\u0012\u0019\u0007\u0003\u0005\u00032\te\u0003\u0019\u0001B\u0012\u0011!\u0011)D!\u0017A\u0002\t]\u0002b\u0002B%\u00053\u0002\rA\u0012\u0005\b\u0005O\u0002A\u0011\u0001B5\u0003%2\u0017N\u001c3GS2,7/\u00138G_2$WM\u001d*fGV\u00148/\u001b<fYf\u0014\u0015\u0010U1ui\u0016\u0014X*\u0019;dQR91Fa\u001b\u0003n\t=\u0004\u0002\u0003B\u0019\u0005K\u0002\rAa\t\t\u0011\tU\"Q\ra\u0001\u0005oAqA!\u0013\u0003f\u0001\u0007a\tC\u0004\u0003t\u0001!\tA!\u001e\u0002/\u0015D\b/Z2uK\u00124\u0015\u000e\\3B]\u0012$\u0015N]\"pk:$HcB\u0016\u0003x\te$Q\u0010\u0005\b\u0005g\u0012\t\b1\u0001o\u0011\u001d\u0011YH!\u001dA\u00029\f1#\u001a=qK\u000e$X\r\u001a#je\u000e{WO\u001c;NS:DqAa \u0003r\u0001\u0007a.A\nfqB,7\r^3e\t&\u00148i\\;oi6\u000b\u0007\u0010C\u0004\u0003\u0004\u0002!\tA!\"\u0002\u000b\rDWmY6\u0015\u0007-\u00129\tC\u0004\u0003\n\n\u0005\u0005\u0019\u00018\u0002\u001b\u0015D\b/Z2uK\u0012\u001cu.\u001e8u\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u001f\u000bAb\u001a:pkB\u0014\u0015p\u00117bgN$bA!%\u0003\u0018\ne\u0005#\u0002B\u001d\u0005'3\u0015\u0002\u0002BK\u0005w\u00111aU3u\u0011!\u0011)Da#A\u0002\t]\u0002b\u0002BN\u0005\u0017\u0003\rAR\u0001\u0006e\u0016<W\r\u001f\u0005\b\u0005?\u0003A\u0011\u0001BQ\u0003Y\u0019\u0007.Z2l!\u0006$H/\u001a:o\u0007>l\u0007\u000f\\5b]\u000e,G#B\u0016\u0003$\n\u001d\u0006b\u0002BS\u0005;\u0003\rA\\\u0001\u0013Kb\u0004Xm\u0019;fI\u000ec\u0017m]:D_VtG\u000fC\u0004\u0003\u001c\nu\u0005\u0019\u0001$\t\u000f\t-\u0006\u0001\"\u0001\u0003.\u0006I2\r[3dW\u0012K'\u000fU1ui\u0016\u0014hnQ8na2L\u0017M\\2f)\rY#q\u0016\u0005\b\u0005K\u0013I\u000b1\u0001o\u0011%\u0011\u0019\fAI\u0001\n\u0003\u0011),\u0001\u000be_J{G\u000e\\8wKJ$C-\u001a4bk2$HEN\u000b\u0003\u0005oS3A\u001cB]W\t\u0011Y\f\u0005\u0003\u0003>\n\u001dWB\u0001B`\u0015\u0011\u0011\tMa1\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bc1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%'q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003Bg\u0001E\u0005I\u0011\u0001B[\u0003Q!wNU8mY>4XM\u001d\u0013eK\u001a\fW\u000f\u001c;%o!I!\u0011\u001b\u0001\u0012\u0002\u0013\u0005!1[\u0001\u001eO\u0016tWM]5d\r&tG-T1uG\"Lgn\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u001b\u0016\u0004\r\ne\u0006\"\u0003Bm\u0001E\u0005I\u0011\u0001Bn\u0003u9WM\\3sS\u000e4\u0015N\u001c3NCR\u001c\u0007.\u001b8hI\u0011,g-Y;mi\u0012*TC\u0001BoU\u0011\t\tL!/")
public class TimeBasedRollingWithArchiveRemoval_STest
implements ScalaObject {
    private Context context = new ContextBase();
    private EchoEncoder<Object> encoder = new EchoEncoder();
    private final String MONTHLY_DATE_PATTERN;
    private final String MONTHLY_CRONOLOG_DATE_PATTERN;
    private final String DAILY_CRONOLOG_DATE_PATTERN;
    private final long MILLIS_IN_MINUTE;
    private final long MILLIS_IN_HOUR = 60L * this.MILLIS_IN_MINUTE();
    private final long MILLIS_IN_DAY = 24L * this.MILLIS_IN_HOUR();
    private final long MILLIS_IN_MONTH = (long)(30.416666666666668 * (double)this.MILLIS_IN_DAY());
    private int diff;
    private String randomOutputDir;
    private int slashCount = 0;
    private TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
    private final long now = System.currentTimeMillis();

    public Context context() {
        return this.context;
    }

    public void context_$eq(Context context) {
        this.context = context;
    }

    public EchoEncoder<Object> encoder() {
        return this.encoder;
    }

    public void encoder_$eq(EchoEncoder<Object> echoEncoder) {
        this.encoder = echoEncoder;
    }

    public String MONTHLY_DATE_PATTERN() {
        return this.MONTHLY_DATE_PATTERN;
    }

    public String MONTHLY_CRONOLOG_DATE_PATTERN() {
        return this.MONTHLY_CRONOLOG_DATE_PATTERN;
    }

    public final String DAILY_CRONOLOG_DATE_PATTERN() {
        return this.DAILY_CRONOLOG_DATE_PATTERN;
    }

    public long MILLIS_IN_MINUTE() {
        return this.MILLIS_IN_MINUTE;
    }

    public long MILLIS_IN_HOUR() {
        return this.MILLIS_IN_HOUR;
    }

    public long MILLIS_IN_DAY() {
        return this.MILLIS_IN_DAY;
    }

    public long MILLIS_IN_MONTH() {
        return this.MILLIS_IN_MONTH;
    }

    public int diff() {
        return this.diff;
    }

    public void diff_$eq(int n) {
        this.diff = n;
    }

    public String randomOutputDir() {
        return this.randomOutputDir;
    }

    public void randomOutputDir_$eq(String string) {
        this.randomOutputDir = string;
    }

    public int slashCount() {
        return this.slashCount;
    }

    public void slashCount_$eq(int n) {
        this.slashCount = n;
    }

    public TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp() {
        return this.tbfnatp;
    }

    public void tbfnatp_$eq(TimeBasedFileNamingAndTriggeringPolicy<Object> timeBasedFileNamingAndTriggeringPolicy) {
        this.tbfnatp = timeBasedFileNamingAndTriggeringPolicy;
    }

    public long now() {
        return this.now;
    }

    @Before
    public void setUp() {
        this.context().setName("test");
        this.diff_$eq(RandomUtil.getPositiveInt());
        this.randomOutputDir_$eq(new StringBuilder().append((Object)CoreTestConstants.OUTPUT_DIR_PREFIX).append((Object)BoxesRunTime.boxToInteger((int)this.diff())).append((Object)"/").toString());
    }

    public int computeSlashCount(String datePattern) {
        return datePattern == null ? 0 : BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.augmentString(datePattern).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int count, char c) {
                return c == '/' ? count + 1 : count;
            }
        }));
    }

    public void genMontlyRollover(int maxHistory, int simulatedNumberOfPeriods, int startInactivity, int numInactivityPeriods) {
        this.slashCount_$eq(this.computeSlashCount(this.MONTHLY_DATE_PATTERN()));
        this.doRollover(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)this.MONTHLY_DATE_PATTERN()).append((Object)"}.txt").toString(), this.MILLIS_IN_MONTH(), maxHistory, simulatedNumberOfPeriods, startInactivity, numInactivityPeriods);
        this.check(this.expectedCountWithoutFolders(maxHistory));
    }

    @Test
    public void montlyRollover() {
        this.genMontlyRollover(20, 60, 0, 0);
        this.setUp();
        this.genMontlyRollover(6, 70, 30, 1);
        this.setUp();
        this.genMontlyRollover(6, 10, 3, 4);
    }

    @Test
    public void monthlyRolloverOverManyPeriods() {
        System.out.println(new StringBuilder().append((Object)"randomOutputDir=").append((Object)this.randomOutputDir()).toString());
        this.slashCount_$eq(this.computeSlashCount(this.MONTHLY_CRONOLOG_DATE_PATTERN()));
        int numPeriods = 40;
        int maxHistory = 2;
        Tuple2<Object, Object> tuple2 = this.doRollover(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)this.MONTHLY_CRONOLOG_DATE_PATTERN()).append((Object)"}/clean.txt.zip").toString(), this.MILLIS_IN_MONTH(), maxHistory, numPeriods, this.doRollover$default$6(), this.doRollover$default$7());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)tuple2._1()), BoxesRunTime.unboxToLong((Object)tuple2._2()));
            long startTime = sp2._1$mcJ$sp();
            long endTime = sp2._2$mcJ$sp();
            int differenceInMonths = RollingCalendar.diffInMonths((long)startTime, (long)endTime);
            int indexOfStartPeriod = Calendar.getInstance().get(2);
            boolean withExtraFolder = this.extraFolder(differenceInMonths, 12, indexOfStartPeriod, maxHistory);
            StatusPrinter.print((Context)this.context());
            this.check(this.expectedCountWithFolders(2, withExtraFolder));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void dailyRollover() {
        this.slashCount_$eq(this.computeSlashCount("yyyy-MM-dd"));
        this.doRollover(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt.zip").toString(), this.MILLIS_IN_DAY(), 5, 15, 6, 3);
        StatusPrinter.print((Context)this.context());
        this.check(this.expectedCountWithoutFolders(5));
    }

    @Test
    public void dailyRolloverWithSecondPhase() {
        this.slashCount_$eq(this.computeSlashCount("yyyy-MM-dd"));
        int maxHistory = 5;
        int simulatedNumberOfPeriods = maxHistory * 2;
        Tuple2<Object, Object> tuple2 = this.doRollover(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString(), this.MILLIS_IN_DAY(), maxHistory, maxHistory * 2, this.doRollover$default$6(), this.doRollover$default$7());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)tuple2._1()), BoxesRunTime.unboxToLong((Object)tuple2._2()));
            long startTime = sp2._1$mcJ$sp();
            long endTime = sp2._2$mcJ$sp();
            this.doRollover(endTime + this.MILLIS_IN_DAY() * 10L, new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString(), this.MILLIS_IN_DAY(), maxHistory, maxHistory, this.doRollover$default$6(), this.doRollover$default$7());
            this.check(this.expectedCountWithoutFolders(maxHistory));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void dailyCronologRollover() {
        this.slashCount_$eq(this.computeSlashCount(this.DAILY_CRONOLOG_DATE_PATTERN()));
        this.doRollover(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)this.DAILY_CRONOLOG_DATE_PATTERN()).append((Object)"}/clean.txt.zip").toString(), this.MILLIS_IN_DAY(), 8, 24, this.doRollover$default$6(), this.doRollover$default$7());
        int expectedDirMin = 9 + this.slashCount();
        int expectDirMax = expectedDirMin + 1 + 1;
        this.expectedFileAndDirCount(9, expectedDirMin, expectDirMax);
    }

    @Test
    public void dailySizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(this.computeSlashCount("yyyy-MM-dd"));
        this.doRollover(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}-clean.%i.zip").toString(), this.MILLIS_IN_DAY(), 5, 20, this.doRollover$default$6(), this.doRollover$default$7());
        this.checkPatternCompliance(6 + this.slashCount(), "\\d{4}-\\d{2}-\\d{2}-clean(\\.\\d)(.zip)?");
    }

    @Test
    public void dailyChronologSizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(1);
        this.doRollover(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}/clean.%i.zip").toString(), this.MILLIS_IN_DAY(), 5, 20, this.doRollover$default$6(), this.doRollover$default$7());
        this.checkDirPatternCompliance(6);
    }

    @Test
    public void dailyChronologSizeBasedRolloverWithSecondPhase() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(1);
        int maxHistory = 5;
        int simulatedNumberOfPeriods = maxHistory * 4;
        Tuple2<Object, Object> tuple2 = this.doRollover(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}/clean.%i").toString(), this.MILLIS_IN_DAY(), maxHistory, 3, this.doRollover$default$6(), this.doRollover$default$7());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)tuple2._1()), BoxesRunTime.unboxToLong((Object)tuple2._2()));
            long startTime = sp2._1$mcJ$sp();
            long endTime = sp2._2$mcJ$sp();
            this.doRollover(endTime + this.MILLIS_IN_DAY() * 7L, new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}/clean.%i").toString(), this.MILLIS_IN_DAY(), maxHistory, simulatedNumberOfPeriods, this.doRollover$default$6(), this.doRollover$default$7());
            this.checkDirPatternCompliance(maxHistory + 1);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Ignore
    @Test
    public void dailyChronologSizeBasedRolloverWhenLogFilenameDoesNotContainDirectory() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(1);
        this.doRollover(this.now(), "clean.%d{yyyy-MM-dd}.%i.zip", this.MILLIS_IN_DAY(), 5, 20, this.doRollover$default$6(), this.doRollover$default$7());
        this.checkDirPatternCompliance(6);
    }

    public boolean extraFolder(int numPeriods, int periodsPerEra, int beginPeriod, int maxHistory) {
        int valueOfLastMonth = (beginPeriod + numPeriods) % periodsPerEra;
        return valueOfLastMonth < maxHistory;
    }

    public int expectedCountWithFolders(int maxHistory, boolean extraFolder) {
        int numLogFiles = maxHistory + 1;
        int numLogFilesAndFolders = numLogFiles * 2;
        int result = numLogFilesAndFolders + this.slashCount();
        if (extraFolder) {
            ++result;
        }
        return result;
    }

    public long addTime(long currentTime, long timeToWait) {
        return currentTime + timeToWait;
    }

    public void waitForCompression(TimeBasedRollingPolicy<Object> tbrp) {
        if (tbrp.future != null && !tbrp.future.isDone()) {
            tbrp.future.get(800L, TimeUnit.MILLISECONDS);
        }
    }

    public Tuple2<Object, Object> doRollover(long currentTime, String fileNamePattern, long periodDurationInMillis$1, int maxHistory, int simulatedNumberOfPeriods, int startInactivity, int numInactivityPeriods) {
        long startTime = currentTime;
        ObjectRef rfa$1 = new ObjectRef((Object)new RollingFileAppender());
        ((RollingFileAppender)rfa$1.elem).setContext(this.context());
        ((RollingFileAppender)rfa$1.elem).setEncoder(this.encoder());
        ObjectRef tbrp$1 = new ObjectRef((Object)new TimeBasedRollingPolicy());
        ((TimeBasedRollingPolicy)tbrp$1.elem).setContext(this.context());
        ((TimeBasedRollingPolicy)tbrp$1.elem).setFileNamePattern(fileNamePattern);
        ((TimeBasedRollingPolicy)tbrp$1.elem).setMaxHistory(maxHistory);
        ((TimeBasedRollingPolicy)tbrp$1.elem).setParent((FileAppender)((RollingFileAppender)rfa$1.elem));
        ((TimeBasedRollingPolicy)tbrp$1.elem).timeBasedFileNamingAndTriggeringPolicy = this.tbfnatp();
        ((TimeBasedRollingPolicy)tbrp$1.elem).timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(currentTime);
        ((TimeBasedRollingPolicy)tbrp$1.elem).start();
        ((RollingFileAppender)rfa$1.elem).setRollingPolicy((RollingPolicy)((TimeBasedRollingPolicy)tbrp$1.elem));
        ((RollingFileAppender)rfa$1.elem).start();
        IntRef ticksPerPeriod$1 = new IntRef(512);
        int runLength = simulatedNumberOfPeriods * ticksPerPeriod$1.elem;
        int startInactivityIndex$1 = 1 + startInactivity * ticksPerPeriod$1.elem;
        int endInactivityIndex$1 = startInactivity + numInactivityPeriods * ticksPerPeriod$1.elem;
        Predef$.MODULE$.intWrapper(0).to(runLength).foreach$mVc$sp((Function1)new Serializable(this, periodDurationInMillis$1, rfa$1, tbrp$1, ticksPerPeriod$1, startInactivityIndex$1, endInactivityIndex$1){
            public static final long serialVersionUID;
            private final TimeBasedRollingWithArchiveRemoval_STest $outer;
            private final long periodDurationInMillis$1;
            private final ObjectRef rfa$1;
            private final ObjectRef tbrp$1;
            private final IntRef ticksPerPeriod$1;
            private final int startInactivityIndex$1;
            private final int endInactivityIndex$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                if (v1 < this.startInactivityIndex$1 || v1 > this.endInactivityIndex$1) {
                    ((RollingFileAppender)this.rfa$1.elem).doAppend((Object)new StringBuilder().append((Object)"Hello ----------------------------------------------------------").append((Object)BoxesRunTime.boxToInteger((int)v1)).toString());
                }
                ((TimeBasedRollingPolicy)this.tbrp$1.elem).timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.$outer.addTime(((TimeBasedRollingPolicy)this.tbrp$1.elem).timeBasedFileNamingAndTriggeringPolicy.getCurrentTime(), this.periodDurationInMillis$1 / (long)this.ticksPerPeriod$1.elem));
                if (v1 % (this.ticksPerPeriod$1.elem / 2) == 0) {
                    this.$outer.waitForCompression((TimeBasedRollingPolicy<Object>)((TimeBasedRollingPolicy)this.tbrp$1.elem));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.periodDurationInMillis$1 = l;
                this.rfa$1 = objectRef;
                this.tbrp$1 = objectRef2;
                this.ticksPerPeriod$1 = intRef;
                this.startInactivityIndex$1 = n;
                this.endInactivityIndex$1 = n2;
            }
        });
        this.waitForCompression((TimeBasedRollingPolicy<Object>)((TimeBasedRollingPolicy)tbrp$1.elem));
        ((RollingFileAppender)rfa$1.elem).stop();
        return new Tuple2.mcJJ.sp(startTime, ((TimeBasedRollingPolicy)tbrp$1.elem).timeBasedFileNamingAndTriggeringPolicy.getCurrentTime());
    }

    public int doRollover$default$7() {
        return 0;
    }

    public int doRollover$default$6() {
        return 0;
    }

    public int expectedCountWithoutFolders(int maxHistory) {
        return maxHistory + 1;
    }

    public void genericFindMatching(Function2<File, String, Object> matchFunc$1, File dir, ListBuffer<File> fileList$1, String pattern$1, boolean includeDirs$1) {
        if (dir.isDirectory()) {
            File[] match = dir.listFiles(new FileFilter(this, matchFunc$1, pattern$1){
                private final Function2 matchFunc$1;
                private final String pattern$1;

                public boolean accept(File f) {
                    return f.isDirectory() || BoxesRunTime.unboxToBoolean((Object)this.matchFunc$1.apply((Object)f, (Object)this.pattern$1));
                }
                {
                    this.matchFunc$1 = function2;
                    this.pattern$1 = string;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])match).foreach((Function1)new Serializable(this, matchFunc$1, fileList$1, pattern$1, includeDirs$1){
                public static final long serialVersionUID;
                private final TimeBasedRollingWithArchiveRemoval_STest $outer;
                private final Function2 matchFunc$1;
                private final ListBuffer fileList$1;
                private final String pattern$1;
                private final boolean includeDirs$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(File f) {
                    ListBuffer listBuffer;
                    if (f.isDirectory()) {
                        Object object = this.includeDirs$1 ? this.fileList$1.$plus$eq((Object)f) : BoxedUnit.UNIT;
                        this.$outer.genericFindMatching((Function2<File, String, Object>)this.matchFunc$1, f, (ListBuffer<File>)this.fileList$1, this.pattern$1, this.includeDirs$1);
                        listBuffer = BoxedUnit.UNIT;
                    } else {
                        listBuffer = this.fileList$1.$plus$eq((Object)f);
                    }
                    return listBuffer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.matchFunc$1 = function2;
                    this.fileList$1 = listBuffer;
                    this.pattern$1 = string;
                    this.includeDirs$1 = bl;
                }
            });
        }
    }

    public boolean genericFindMatching$default$5() {
        return false;
    }

    public String genericFindMatching$default$4() {
        return null;
    }

    public void findAllFoldersInFolderRecursively(File dir, ListBuffer<File> fileList) {
        this.genericFindMatching((Function2<File, String, Object>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File f, String p) {
                return false;
            }
        }, dir, fileList, null, true);
    }

    public void findAllDirsOrStringContainsFilesRecursively(File dir, ListBuffer<File> fileList, String pattern) {
        this.genericFindMatching((Function2<File, String, Object>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File f, String pattern) {
                return f.getName().contains(pattern);
            }
        }, dir, fileList, pattern, true);
    }

    public void findFilesInFolderRecursivelyByPatterMatch(File dir, ListBuffer<File> fileList, String pattern$2) {
        this.genericFindMatching((Function2<File, String, Object>)new Serializable(this, pattern$2){
            public static final long serialVersionUID;
            private final String pattern$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File f, String p) {
                return f.getName().matches(this.pattern$2);
            }
            {
                this.pattern$2 = string;
            }
        }, dir, fileList, pattern$2, this.genericFindMatching$default$5());
    }

    public void expectedFileAndDirCount(int expectedFileAndDirCount, int expectedDirCountMin, int expectedDirCountMax) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, (ListBuffer<File>)fileList, "clean");
        ListBuffer dirList = new ListBuffer();
        this.findAllFoldersInFolderRecursively(dir, (ListBuffer<File>)dirList);
        Assert.assertTrue((String)new StringBuilder().append((Object)"expectedDirCountMin=").append((Object)BoxesRunTime.boxToInteger((int)expectedDirCountMin)).append((Object)", expectedDirCountMax=").append((Object)BoxesRunTime.boxToInteger((int)expectedDirCountMax)).append((Object)" actual value=").append((Object)BoxesRunTime.boxToInteger((int)dirList.size())).toString(), (expectedDirCountMin <= dirList.size() && dirList.size() <= expectedDirCountMax ? 1 : 0) != 0);
    }

    public void check(int expectedCount) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findAllDirsOrStringContainsFilesRecursively(dir, (ListBuffer<File>)fileList, "clean");
        Assert.assertEquals((long)expectedCount, (long)fileList.size());
    }

    public Set<String> groupByClass(ListBuffer<File> fileList, String regex) {
        ObjectRef p$1 = new ObjectRef((Object)Pattern.compile(regex));
        HashSet set$1 = new HashSet();
        fileList.foreach((Function1)new Serializable(this, p$1, set$1){
            public static final long serialVersionUID;
            private final ObjectRef p$1;
            private final HashSet set$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File f) {
                String n = f.getName();
                Matcher m = ((Pattern)this.p$1.elem).matcher(n);
                m.matches();
                int begin = m.start(1);
                String reduced = n.substring(0, begin);
                return this.set$1.add((Object)reduced);
            }
            {
                this.p$1 = objectRef;
                this.set$1 = hashSet;
            }
        });
        return set$1;
    }

    public void checkPatternCompliance(int expectedClassCount, String regex) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, (ListBuffer<File>)fileList, regex);
        Set<String> set = this.groupByClass((ListBuffer<File>)fileList, regex);
        Assert.assertEquals((long)expectedClassCount, (long)set.size());
    }

    public void checkDirPatternCompliance(int expectedClassCount) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findAllFoldersInFolderRecursively(dir, (ListBuffer<File>)fileList);
        fileList.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File f) {
                Assert.assertTrue((f.list().length >= 1 ? 1 : 0) != 0);
            }
        });
        Assert.assertEquals((long)expectedClassCount, (long)fileList.size());
    }

    public TimeBasedRollingWithArchiveRemoval_STest() {
        this.MONTHLY_DATE_PATTERN = "yyyy-MM";
        this.MONTHLY_CRONOLOG_DATE_PATTERN = "yyyy/MM";
        this.DAILY_CRONOLOG_DATE_PATTERN = "yyyy/MM/dd";
        this.MILLIS_IN_MINUTE = 60000L;
    }
}

