/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.RollingScaffolding;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.testUtil.FileToBufferUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.CachingDateFormatter;
import ch.qos.logback.core.util.CoreTestConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.junit.Assert;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public abstract class RollingScaffolding$class {
    public static void setUpScaffolding(RollingScaffolding $this) {
        $this.context().setName("test");
        $this.cal().set(14, 333);
        $this.currentTime_$eq($this.cal().getTimeInMillis());
        $this.recomputeRolloverThreshold($this.currentTime());
    }

    public static void incCurrentTime(RollingScaffolding $this, long increment) {
        $this.currentTime_$eq($this.currentTime() + increment);
    }

    public static long getMillisOfCurrentPeriodsStart(RollingScaffolding $this) {
        long delta = $this.currentTime() % 1000L;
        return $this.currentTime() - delta;
    }

    public static Date getDateOfCurrentPeriodsStart(RollingScaffolding $this) {
        long delta = $this.currentTime() % 1000L;
        return new Date($this.currentTime() - delta);
    }

    public static void addExpectedFileName_ByDate(RollingScaffolding $this, String patternStr, long millis) {
        FileNamePattern fileNamePattern = new FileNamePattern(patternStr, $this.context());
        String fn = fileNamePattern.convert((Object)new Date(millis));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"fn=").append((Object)fn).toString());
        List<String> list = $this.expectedFilenameList();
        $this.expectedFilenameList_$eq((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fn})).$colon$colon$colon(list));
    }

    public static void addExpectedFileName_ByFileIndexCounter(RollingScaffolding $this, String randomOutputDir, String testId, long millis, int fileIndexCounter, String compressionSuffix) {
        String fn = new StringBuilder().append((Object)randomOutputDir).append((Object)testId).append((Object)"-").append((Object)$this.SDF().format(millis)).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)fileIndexCounter)).append((Object)".txt").append((Object)compressionSuffix).toString();
        List<String> list = $this.expectedFilenameList();
        $this.expectedFilenameList_$eq((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fn})).$colon$colon$colon(list));
    }

    public static void addExpectedFileNamedIfItsTime_ByDate(RollingScaffolding $this, String fileNamePatternStr) {
        if ($this.passThresholdTime($this.nextRolloverThreshold())) {
            $this.addExpectedFileName_ByDate(fileNamePatternStr, $this.getMillisOfCurrentPeriodsStart());
            $this.recomputeRolloverThreshold($this.currentTime());
        }
    }

    public static boolean passThresholdTime(RollingScaffolding $this, long nextRolloverThreshold) {
        return $this.currentTime() >= nextRolloverThreshold;
    }

    public static void recomputeRolloverThreshold(RollingScaffolding $this, long ct) {
        long delta = ct % 1000L;
        $this.nextRolloverThreshold_$eq(ct - delta + 1000L);
    }

    public static String addGZIfNotLast(RollingScaffolding $this, int i, String suff) {
        int lastIndex = $this.expectedFilenameList().size() - 1;
        return i != lastIndex ? suff : "";
    }

    public static void waitForCompression(RollingScaffolding $this, TimeBasedRollingPolicy tbrp) {
        if (tbrp.future != null && !tbrp.future.isDone()) {
            tbrp.future.get(400L, TimeUnit.MILLISECONDS);
        }
    }

    public static String testId2FileName(RollingScaffolding $this, String testId) {
        return new StringBuilder().append((Object)$this.randomOutputDir()).append((Object)testId).append((Object)".log").toString();
    }

    public static void massageExpectedFilesToCorresponToCurrentTarget(RollingScaffolding $this, String file, boolean fileOptionIsSet) {
        String last = (String)$this.expectedFilenameList().last();
        $this.expectedFilenameList_$eq((List<String>)((List)$this.expectedFilenameList().dropRight(1)));
        if (fileOptionIsSet) {
            List<String> list = $this.expectedFilenameList();
            $this.expectedFilenameList_$eq((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file})).$colon$colon$colon(list));
        } else if (last.endsWith(".gz")) {
            String stem = (String)new StringOps(Predef$.MODULE$.augmentString(last)).dropRight(3);
            List<String> list = $this.expectedFilenameList();
            $this.expectedFilenameList_$eq((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{stem})).$colon$colon$colon(list));
        }
    }

    public static void existenceCheck(RollingScaffolding $this, List filenameList) {
        filenameList.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(String filename) {
                Assert.assertTrue((String)new StringBuilder().append((Object)"File ").append((Object)filename).append((Object)" does not exist").toString(), (boolean)new File(filename).exists());
            }
        });
    }

    public static File[] getFilesInDirectory(RollingScaffolding $this, String outputDirStr) {
        File outputDir = new File(outputDirStr);
        return outputDir.listFiles();
    }

    public static void sortedContentCheck(RollingScaffolding $this, String outputDirStr, int runLength, String prefix) {
        File[] fileArray = $this.getFilesInDirectory(outputDirStr);
        FileFilterUtil.sortFileArrayByName((File[])fileArray);
        $this.fileContentCheck(fileArray, runLength, prefix);
    }

    public static void reverseSortedContentCheck(RollingScaffolding $this, String outputDirStr, int runLength, String prefix) {
        File[] fileArray = $this.getFilesInDirectory(outputDirStr);
        FileFilterUtil.reverseSortFileArrayByName((File[])fileArray);
        $this.fileContentCheck(fileArray, runLength, prefix);
    }

    public static void fileContentCheck(RollingScaffolding $this, File[] fileArray, int runLength, String prefix) {
        ObjectRef stringList = new ObjectRef(new ArrayList());
        Predef$.MODULE$.refArrayOps((Object[])fileArray).foreach((Function1)new Serializable($this, stringList){
            public static final long serialVersionUID = 0L;
            private final ObjectRef stringList$1;

            public final void apply(File file) {
                FileToBufferUtil.readIntoList(file, (ArrayList)this.stringList$1.elem);
            }
            {
                this.stringList$1 = stringList$1;
            }
        });
        ObjectRef witnessList = new ObjectRef((Object)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), runLength).foreach$mVc$sp((Function1)new Serializable($this, witnessList, prefix){
            public static final long serialVersionUID = 0L;
            private final ObjectRef witnessList$1;
            private final String prefix$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String string = new StringBuilder().append((Object)this.prefix$1).append((Object)BoxesRunTime.boxToInteger((int)i)).toString();
                this.witnessList$1.elem = ((List)this.witnessList$1.elem).$colon$colon((Object)string);
            }
            {
                this.witnessList$1 = witnessList$1;
                this.prefix$1 = prefix$1;
            }
        });
        witnessList.elem = ((List)witnessList.elem).reverse();
        Assert.assertEquals((Object)((List)witnessList.elem), (Object)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)((ArrayList)stringList.elem)));
    }

    public static void zipEntryNameCheck(RollingScaffolding $this, List expectedFilenameList, String pattern) {
        expectedFilenameList.foreach((Function1)new Serializable($this, pattern){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RollingScaffolding $outer;
            private final String pattern$1;

            public final void apply(String filepath) {
                this.$outer.checkZipEntryName(filepath, this.pattern$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.pattern$1 = pattern$1;
            }
        });
    }

    public static void checkZipEntryMatchesZipFilename(RollingScaffolding $this, List expectedFilenameList, String pattern) {
        expectedFilenameList.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RollingScaffolding $outer;

            public final void apply(String filepath) {
                this.$outer.checkZipEntryName(filepath, RollingScaffolding$class.stripStemFromZipFilename$1(this.$outer, filepath));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static void checkZipEntryName(RollingScaffolding $this, String filepath, String pattern) {
        System.out.println(new StringBuilder().append((Object)"Checking [").append((Object)filepath).append((Object)"]").toString());
        ZipFile zf = new ZipFile(filepath);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        Predef$.MODULE$.assert(entries.hasMoreElements());
        ZipEntry firstZipEntry = entries.nextElement();
        Predef$.MODULE$.assert(!entries.hasMoreElements());
        System.out.println(new StringBuilder().append((Object)"Testing zip entry [").append((Object)firstZipEntry.getName()).append((Object)"]").toString());
        Assert.assertTrue((boolean)firstZipEntry.getName().matches(pattern));
    }

    public static final String stripStemFromZipFilename$1(RollingScaffolding $this, String filepath) {
        File filepathAsFile = new File(filepath);
        String stem = filepathAsFile.getName();
        return (String)new StringOps(Predef$.MODULE$.augmentString(stem)).dropRight(".zip".length());
    }

    public static void $init$(RollingScaffolding $this) {
        $this.ch$qos$logback$core$rolling$RollingScaffolding$_setter_$SDF_$eq(new CachingDateFormatter("yyyy-MM-dd_HH_mm_ss"));
        $this.ch$qos$logback$core$rolling$RollingScaffolding$_setter_$context_$eq((Context)new ContextBase());
        $this.ch$qos$logback$core$rolling$RollingScaffolding$_setter_$sm_$eq($this.context().getStatusManager());
        $this.diff_$eq(RandomUtil.getPositiveInt());
        $this.currentTime_$eq(0L);
        $this.randomOutputDir_$eq(new StringBuilder().append((Object)CoreTestConstants.OUTPUT_DIR_PREFIX).append((Object)BoxesRunTime.boxToInteger((int)$this.diff())).append((Object)"/").toString());
        $this.cal_$eq(Calendar.getInstance());
        $this.nextRolloverThreshold_$eq(0L);
        $this.expectedFilenameList_$eq((List<String>)Nil$.MODULE$);
        $this.ch$qos$logback$core$rolling$RollingScaffolding$_setter_$FILE_OPTION_SET_$eq(true);
        $this.ch$qos$logback$core$rolling$RollingScaffolding$_setter_$FILE_OPTION_BLANK_$eq(false);
    }
}

