/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.CoreTestConstants;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileFilter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r%a\u0001B\u0001\u0003\u00015\u0011\u0001\u0006V5nK\n\u000b7/\u001a3S_2d\u0017N\\4XSRD\u0017I]2iSZ,'+Z7pm\u0006dwl\u0015+fgRT!a\u0001\u0003\u0002\u000fI|G\u000e\\5oO*\u0011QAB\u0001\u0005G>\u0014XM\u0003\u0002\b\u0011\u00059An\\4cC\u000e\\'BA\u0005\u000b\u0003\r\txn\u001d\u0006\u0002\u0017\u0005\u00111\r[\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001A\u0002\u0013\u00051$A\u0004d_:$X\r\u001f;\u0016\u0003q\u0001\"!\b\u0010\u000e\u0003\u0011I!a\b\u0003\u0003\u000f\r{g\u000e^3yi\"9\u0011\u0005\u0001a\u0001\n\u0003\u0011\u0013aC2p]R,\u0007\u0010^0%KF$\"a\t\u0014\u0011\u0005=!\u0013BA\u0013\u0011\u0005\u0011)f.\u001b;\t\u000f\u001d\u0002\u0013\u0011!a\u00019\u0005\u0019\u0001\u0010J\u0019\t\r%\u0002\u0001\u0015)\u0003\u001d\u0003!\u0019wN\u001c;fqR\u0004\u0003bB\u0016\u0001\u0001\u0004%\t\u0001L\u0001\bK:\u001cw\u000eZ3s+\u0005i\u0003c\u0001\u00181\u001d5\tqF\u0003\u0002,\t%\u0011\u0011g\f\u0002\f\u000b\u000eDw.\u00128d_\u0012,'\u000fC\u00044\u0001\u0001\u0007I\u0011\u0001\u001b\u0002\u0017\u0015t7m\u001c3fe~#S-\u001d\u000b\u0003GUBqa\n\u001a\u0002\u0002\u0003\u0007Q\u0006\u0003\u00048\u0001\u0001\u0006K!L\u0001\tK:\u001cw\u000eZ3sA!9\u0011\b\u0001b\u0001\n\u0003Q\u0014\u0001F'P\u001dRCE*W0E\u0003R+u\fU!U)\u0016\u0013f*F\u0001<!\tatH\u0004\u0002\u0010{%\u0011a\bE\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?!!11\t\u0001Q\u0001\nm\nQ#T(O)\"c\u0015l\u0018#B)\u0016{\u0006+\u0011+U\u000bJs\u0005\u0005C\u0004F\u0001\t\u0007I\u0011\u0001\u001e\u0002;5{e\n\u0016%M3~\u001b%k\u0014(P\u0019>;u\fR!U\u000b~\u0003\u0016\t\u0016+F%:Caa\u0012\u0001!\u0002\u0013Y\u0014AH'P\u001dRCE*W0D%>su\nT(H?\u0012\u000bE+R0Q\u0003R#VI\u0015(!\u0011\u001dI\u0005A1A\u0005\u0006i\n1\u0004R!J\u0019f{6IU(O\u001f2{ui\u0018#B)\u0016{\u0006+\u0011+U\u000bJs\u0005BB&\u0001A\u000351(\u0001\u000fE\u0003&c\u0015lX\"S\u001f:{EjT$`\t\u0006#Vi\u0018)B)R+%K\u0014\u0011\t\u000f5\u0003!\u0019!C\u0001\u001d\u0006\u0001R*\u0013'M\u0013N{\u0016JT0N\u0013:+F+R\u000b\u0002\u001fB\u0011q\u0002U\u0005\u0003#B\u0011A\u0001T8oO\"11\u000b\u0001Q\u0001\n=\u000b\u0011#T%M\u0019&\u001bv,\u0013(`\u001b&sU\u000bV#!\u0011\u001d)\u0006A1A\u0005\u00029\u000ba\"T%M\u0019&\u001bv,\u0013(`\u0011>+&\u000b\u0003\u0004X\u0001\u0001\u0006IaT\u0001\u0010\u001b&cE*S*`\u0013:{\u0006jT+SA!9\u0011\f\u0001b\u0001\n\u0003q\u0015!D'J\u00192K5kX%O?\u0012\u000b\u0015\f\u0003\u0004\\\u0001\u0001\u0006IaT\u0001\u000f\u001b&cE*S*`\u0013:{F)Q-!\u0011\u001di\u0006A1A\u0005\u00029\u000bq\"T%M\u0019&\u001bv,\u0013(`\u001b>sE\u000b\u0013\u0005\u0007?\u0002\u0001\u000b\u0011B(\u0002!5KE\nT%T?&su,T(O)\"\u0003\u0003bB1\u0001\u0005\u0004%\tAY\u0001\u000f\u001b>sE\u000bS*`\u0013:{\u0016,R!S+\u0005\u0019\u0007CA\be\u0013\t)\u0007CA\u0002J]RDaa\u001a\u0001!\u0002\u0013\u0019\u0017aD'P\u001dRC5kX%O?f+\u0015I\u0015\u0011\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0003\u0011\u0017\u0001\u00023jM\u001aD\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00017\u0002\u0011\u0011LgMZ0%KF$\"aI7\t\u000f\u001dR\u0017\u0011!a\u0001G\"1q\u000e\u0001Q!\n\r\fQ\u0001Z5gM\u0002B\u0011\"\u001d\u0001A\u0002\u0003\u0007I\u0011\u0001\u001e\u0002\u001fI\fg\u000eZ8n\u001fV$\b/\u001e;ESJD\u0011b\u001d\u0001A\u0002\u0003\u0007I\u0011\u0001;\u0002'I\fg\u000eZ8n\u001fV$\b/\u001e;ESJ|F%Z9\u0015\u0005\r*\bbB\u0014s\u0003\u0003\u0005\ra\u000f\u0005\u0007o\u0002\u0001\u000b\u0015B\u001e\u0002!I\fg\u000eZ8n\u001fV$\b/\u001e;ESJ\u0004\u0003bB=\u0001\u0001\u0004%\tAY\u0001\u000bg2\f7\u000f[\"pk:$\bbB>\u0001\u0001\u0004%\t\u0001`\u0001\u000fg2\f7\u000f[\"pk:$x\fJ3r)\t\u0019S\u0010C\u0004(u\u0006\u0005\t\u0019A2\t\r}\u0004\u0001\u0015)\u0003d\u0003-\u0019H.Y:i\u0007>,h\u000e\u001e\u0011\t\u0013\u0005\r\u0001\u00011A\u0005\u0002\u0005\u0015\u0011a\u0002;cM:\fG\u000f]\u000b\u0003\u0003\u000f\u0001B\u0001GA\u0005\u001d%\u0019\u00111\u0002\u0002\u0003MQKW.\u001a\"bg\u0016$g)\u001b7f\u001d\u0006l\u0017N\\4B]\u0012$&/[4hKJLgn\u001a)pY&\u001c\u0017\u0010C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0001\u0002\u0012\u0005YAO\u00194oCR\u0004x\fJ3r)\r\u0019\u00131\u0003\u0005\nO\u00055\u0011\u0011!a\u0001\u0003\u000fA\u0001\"a\u0006\u0001A\u0003&\u0011qA\u0001\ti\n4g.\u0019;qA!A\u00111\u0004\u0001C\u0002\u0013\u0005a*A\u0002o_^Dq!a\b\u0001A\u0003%q*\u0001\u0003o_^\u0004\u0003bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\u0006g\u0016$X\u000b]\u000b\u0002G!\"\u0011\u0011EA\u0015!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tQA[;oSRT!!a\r\u0002\u0007=\u0014x-\u0003\u0003\u00028\u00055\"A\u0002\"fM>\u0014X\rC\u0004\u0002<\u0001!\t!!\u0010\u0002#\r|W\u000e];uKNc\u0017m\u001d5D_VtG\u000fF\u0002d\u0003\u007fAq!!\u0011\u0002:\u0001\u00071(A\u0006eCR,\u0007+\u0019;uKJt\u0007bBA#\u0001\u0011\u0005\u0011qI\u0001\u001f[>tG\u000f\u001b7z%>dGn\u001c<fe>3XM]'b]f\u0004VM]5pIN$\u0012a\t\u0015\u0005\u0003\u0007\nY\u0005\u0005\u0003\u0002,\u00055\u0013\u0002BA(\u0003[\u0011A\u0001V3ti\"9\u00111\u000b\u0001\u0005\u0002\u0005U\u0013!F4f]\u0016\u0014\u0018\r^3EC&d\u0017PU8mY>4XM\u001d\u000b\fG\u0005]\u0013\u0011LA/\u0003C\n)\u0007C\u0004\u0002\u001c\u0005E\u0003\u0019A(\t\u000f\u0005m\u0013\u0011\u000ba\u0001G\u0006QQ.\u0019=ISN$xN]=\t\u000f\u0005}\u0013\u0011\u000ba\u0001G\u0006A2/[7vY\u0006$X\r\u001a(v[\n,'o\u00144QKJLw\u000eZ:\t\u000f\u0005\r\u0014\u0011\u000ba\u0001G\u0006y1\u000f^1si&s\u0017m\u0019;jm&$\u0018\u0010C\u0004\u0002h\u0005E\u0003\u0019A2\u0002)9,X.\u00138bGRLg/\u001b;z!\u0016\u0014\u0018n\u001c3t\u0011\u001d\tY\u0007\u0001C\u0001\u0003K\t!CY1tS\u000e$\u0015-\u001b7z%>dGn\u001c<fe\"\"\u0011\u0011NA&\u0011\u001d\t\t\b\u0001C\u0001\u0003K\tq\u0002Z1jYf\u0014v\u000e\u001c7pm\u0016\u0014\u0018'\u000e\u0015\u0005\u0003_\nY\u0005C\u0004\u0002x\u0001!\t!!\n\u0002;\u0011\f\u0017\u000e\\=S_2dwN^3s/&$\b.\u00138bGRLg/\u001b;zoABC!!\u001e\u0002L!9\u0011Q\u0010\u0001\u0005\u0002\u0005\u0015\u0012!\b3bS2L(k\u001c7m_Z,'oV5uQ&s\u0017m\u0019;jm&$\u00180\r\u0019)\t\u0005m\u00141\n\u0005\b\u0003\u0007\u0003A\u0011AA\u0013\u0003q!\u0017-\u001b7z%>dGn\u001c<fe^KG\u000f[*fG>tG\r\u00155bg\u0016DC!!!\u0002L!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005\u0015\u0012!\u00063bS2L8I]8o_2|wMU8mY>4XM\u001d\u0015\u0005\u0003\u000f\u000bY\u0005C\u0004\u0002\u0010\u0002!\t!!\n\u0002-\u0011\f\u0017\u000e\\=TSj,')Y:fIJ{G\u000e\\8wKJDC!!$\u0002L!9\u0011Q\u0013\u0001\u0005\u0002\u0005\u0015\u0012a\b3bS2L8\t\u001b:p]>dwnZ*ju\u0016\u0014\u0015m]3e%>dGn\u001c<fe\"\"\u00111SA&\u0011\u001d\tY\n\u0001C\u0001\u0003K\ta\u0006Z1jYf\u001c\u0005N]8o_2|wmU5{K\n\u000b7/\u001a3S_2dwN^3s/&$\bnU3d_:$\u0007\u000b[1tK\"\"\u0011\u0011TA&\u0011\u001d\t\t\u000b\u0001C\u0001\u0003G\u000bQ\u0002\\8h\u001f:\u001cW\rU3sS>$GcB\u0012\u0002&\u0006%\u0016Q\u0016\u0005\b\u0003O\u000by\n1\u0001P\u0003-\u0019WO\u001d:f]R$\u0016.\\3\t\u000f\u0005-\u0016q\u0014a\u0001w\u0005ya-\u001b7f\u001d\u0006lW\rU1ui\u0016\u0014h\u000eC\u0004\u0002\\\u0005}\u0005\u0019A2\t\u000f\u0005E\u0006\u0001\"\u0001\u0002&\u0005\u00192\r\\3b]\"K7\u000f^8ss>s7\u000b^1si\"\"\u0011qVA&\u0011\u001d\t9\f\u0001C\u0001\u0003s\u000b1\"\u001a=ue\u00064u\u000e\u001c3feRQ\u00111XAa\u0003\u000b\fI-!4\u0011\u0007=\ti,C\u0002\u0002@B\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002D\u0006U\u0006\u0019A2\u0002\u00159,X\u000eU3sS>$7\u000fC\u0004\u0002H\u0006U\u0006\u0019A2\u0002\u001bA,'/[8egB+'/\u0012:b\u0011\u001d\tY-!.A\u0002\r\f1BY3hS:\u0004VM]5pI\"9\u00111LA[\u0001\u0004\u0019\u0007bBAi\u0001\u0011\u0005\u00111[\u0001\bC\u0012$G+[7f)\u0015y\u0015Q[Al\u0011\u001d\t9+a4A\u0002=Cq!!7\u0002P\u0002\u0007q*\u0001\u0006uS6,Gk\\,bSRDq!!8\u0001\t\u0003\ty.\u0001\nxC&$hi\u001c:D_6\u0004(/Z:tS>tGcA\u0012\u0002b\"A\u00111]An\u0001\u0004\t)/\u0001\u0003uEJ\u0004\b\u0003\u0002\r\u0002h:I1!!;\u0003\u0005Y!\u0016.\\3CCN,GMU8mY&tw\rU8mS\u000eL\bbBAw\u0001\u0011\u0005\u0011q^\u0001\u0019EVLG\u000e\u001a*pY2Lgn\u001a$jY\u0016\f\u0005\u000f]3oI\u0016\u0014HCCAy\u0003{\fyP!\u0001\u0003\u0004A9q\"a=\u0002x\u0006\u0015\u0018bAA{!\t1A+\u001e9mKJ\u0002B\u0001GA}\u001d%\u0019\u00111 \u0002\u0003'I{G\u000e\\5oO\u001aKG.Z!qa\u0016tG-\u001a:\t\u000f\u0005\u001d\u00161\u001ea\u0001\u001f\"9\u00111VAv\u0001\u0004Y\u0004bBA.\u0003W\u0004\ra\u0019\u0005\u000b\u0003c\u000bY\u000f%AA\u0002\u0005m\u0006b\u0002B\u0004\u0001\u0011\u0005!\u0011B\u0001\u0017Y><wJ^3s\u001bVdG/\u001b9mKB+'/[8egR\u0001\"1\u0002B\u0007\u0005\u001f\u0011\tB!\u0006\u0003\u0018\te!1\u0004\t\u0006\u001f\u0005Mxj\u0014\u0005\b\u0003O\u0013)\u00011\u0001P\u0011\u001d\tYK!\u0002A\u0002mBqAa\u0005\u0003\u0006\u0001\u0007q*\u0001\fqKJLw\u000e\u001a#ve\u0006$\u0018n\u001c8J]6KG\u000e\\5t\u0011\u001d\tYF!\u0002A\u0002\rDq!a\u0018\u0003\u0006\u0001\u00071\rC\u0005\u0002d\t\u0015\u0001\u0013!a\u0001G\"I\u0011q\rB\u0003!\u0003\u0005\ra\u0019\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0003m)\u0007\u0010]3di\u0016$7i\\;oi^KG\u000f[8vi\u001a{G\u000eZ3sgR\u00191Ma\t\t\u000f\u0005m#Q\u0004a\u0001G\"9!q\u0005\u0001\u0005\u0002\t%\u0012!K3ya\u0016\u001cG/\u001a3D_VtGoV5uQ>,HOR8mI\u0016\u00148oV5uQ&s\u0017m\u0019;jm&$\u0018\u0010F\u0004d\u0005W\u0011iC!\r\t\u000f\u0005m#Q\u0005a\u0001G\"9!q\u0006B\u0013\u0001\u0004\u0019\u0017\u0001\u0004;pi\u0006d\u0007+\u001a:j_\u0012\u001c\bb\u0002B\u001a\u0005K\u0001\raY\u0001\u0010K:$wJZ%oC\u000e$\u0018N^5us\"9!q\u0007\u0001\u0005\u0002\te\u0012aE4f]\u0016\u0014\u0018n\u0019$j]\u0012l\u0015\r^2iS:<GcC\u0012\u0003<\tU#\u0011\fB7\u0005cB\u0001B!\u0010\u00036\u0001\u0007!qH\u0001\n[\u0006$8\r\u001b$v]\u000e\u0004\u0002b\u0004B!\u0005\u000bZ\u00141X\u0005\u0004\u0005\u0007\u0002\"!\u0003$v]\u000e$\u0018n\u001c83!\u0011\u00119E!\u0015\u000e\u0005\t%#\u0002\u0002B&\u0005\u001b\n!![8\u000b\u0005\t=\u0013\u0001\u00026bm\u0006LAAa\u0015\u0003J\t!a)\u001b7f\u0011!\u00119F!\u000eA\u0002\t\u0015\u0013a\u00013je\"A!1\fB\u001b\u0001\u0004\u0011i&\u0001\u0005gS2,G*[:u!\u0019\u0011yF!\u001b\u0003F5\u0011!\u0011\r\u0006\u0005\u0005G\u0012)'A\u0004nkR\f'\r\\3\u000b\u0007\t\u001d\u0004#\u0001\u0006d_2dWm\u0019;j_:LAAa\u001b\u0003b\tQA*[:u\u0005V4g-\u001a:\t\u0013\t=$Q\u0007I\u0001\u0002\u0004Y\u0014a\u00029biR,'O\u001c\u0005\u000b\u0005g\u0012)\u0004%AA\u0002\u0005m\u0016aC5oG2,H-\u001a#jeNDqAa\u001e\u0001\t\u0003\u0011I(A\u0011gS:$\u0017\t\u001c7G_2$WM]:J]\u001a{G\u000eZ3s%\u0016\u001cWO]:jm\u0016d\u0017\u0010F\u0003$\u0005w\u0012i\b\u0003\u0005\u0003X\tU\u0004\u0019\u0001B#\u0011!\u0011YF!\u001eA\u0002\tu\u0003b\u0002BA\u0001\u0011\u0005!1Q\u0001,M&tG-\u00117m\t&\u00148o\u0014:TiJLgnZ\"p]R\f\u0017N\\:GS2,7OU3dkJ\u001c\u0018N^3msR91E!\"\u0003\b\n%\u0005\u0002\u0003B,\u0005\u007f\u0002\rA!\u0012\t\u0011\tm#q\u0010a\u0001\u0005;BqAa\u001c\u0003\u0000\u0001\u00071\bC\u0004\u0003\u000e\u0002!\tAa$\u0002S\u0019Lg\u000e\u001a$jY\u0016\u001c\u0018J\u001c$pY\u0012,'OU3dkJ\u001c\u0018N^3ms\nK\b+\u0019;uKJl\u0015\r^2i)\u001d\u0019#\u0011\u0013BJ\u0005+C\u0001Ba\u0016\u0003\f\u0002\u0007!Q\t\u0005\t\u00057\u0012Y\t1\u0001\u0003^!9!q\u000eBF\u0001\u0004Y\u0004b\u0002BM\u0001\u0011\u0005!1T\u0001\u0018Kb\u0004Xm\u0019;fI\u001aKG.Z!oI\u0012K'oQ8v]R$ra\tBO\u0005?\u0013\u0019\u000bC\u0004\u0003\u001a\n]\u0005\u0019A2\t\u000f\t\u0005&q\u0013a\u0001G\u0006\u0019R\r\u001f9fGR,G\rR5s\u0007>,h\u000e^'j]\"9!Q\u0015BL\u0001\u0004\u0019\u0017aE3ya\u0016\u001cG/\u001a3ESJ\u001cu.\u001e8u\u001b\u0006D\bb\u0002BU\u0001\u0011\u0005!1V\u0001\u0006G\",7m\u001b\u000b\u0004G\t5\u0006b\u0002BX\u0005O\u0003\raY\u0001\u000eKb\u0004Xm\u0019;fI\u000e{WO\u001c;\t\u000f\tM\u0006\u0001\"\u0001\u00036\u0006aqM]8va\nK8\t\\1tgR1!q\u0017B_\u0005\u007f\u0003RAa\u0018\u0003:nJAAa/\u0003b\t\u00191+\u001a;\t\u0011\tm#\u0011\u0017a\u0001\u0005;BqA!1\u00032\u0002\u00071(A\u0003sK\u001e,\u0007\u0010C\u0004\u0003F\u0002!\tAa2\u0002-\rDWmY6QCR$XM\u001d8D_6\u0004H.[1oG\u0016$Ra\tBe\u0005\u001bDqAa3\u0003D\u0002\u00071-\u0001\nfqB,7\r^3e\u00072\f7o]\"pk:$\bb\u0002Ba\u0005\u0007\u0004\ra\u000f\u0005\b\u0005#\u0004A\u0011\u0001Bj\u0003e\u0019\u0007.Z2l\t&\u0014\b+\u0019;uKJt7i\\7qY&\fgnY3\u0015\u0007\r\u0012)\u000eC\u0004\u0003L\n=\u0007\u0019A2\t\u0013\te\u0007!%A\u0005\u0002\tm\u0017\u0001\t7pO>3XM]'vYRL\u0007\u000f\\3QKJLw\u000eZ:%I\u00164\u0017-\u001e7uIY*\"A!8+\u0007\r\u0014yn\u000b\u0002\u0003bB!!1\u001dBw\u001b\t\u0011)O\u0003\u0003\u0003h\n%\u0018!C;oG\",7m[3e\u0015\r\u0011Y\u000fE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bx\u0005K\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011\u0019\u0010AI\u0001\n\u0003\u0011Y.\u0001\u0011m_\u001e|e/\u001a:Nk2$\u0018\u000e\u001d7f!\u0016\u0014\u0018n\u001c3tI\u0011,g-Y;mi\u0012:\u0004\"\u0003B|\u0001E\u0005I\u0011\u0001B}\u0003\t\u0012W/\u001b7e%>dG.\u001b8h\r&dW-\u00119qK:$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1 \u0016\u0005\u0003w\u0013y\u000eC\u0005\u0003\u0000\u0002\t\n\u0011\"\u0001\u0004\u0002\u0005ir-\u001a8fe&\u001cg)\u001b8e\u001b\u0006$8\r[5oO\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u0004)\u001a1Ha8\t\u0013\r\u001d\u0001!%A\u0005\u0002\te\u0018!H4f]\u0016\u0014\u0018n\u0019$j]\u0012l\u0015\r^2iS:<G\u0005Z3gCVdG\u000fJ\u001b")
public class TimeBasedRollingWithArchiveRemoval_STest {
    private Context context = new ContextBase();
    private EchoEncoder<Object> encoder = new EchoEncoder();
    private final String MONTHLY_DATE_PATTERN;
    private final String MONTHLY_CRONOLOG_DATE_PATTERN;
    private final String DAILY_CRONOLOG_DATE_PATTERN;
    private final long MILLIS_IN_MINUTE;
    private final long MILLIS_IN_HOUR = 60L * this.MILLIS_IN_MINUTE();
    private final long MILLIS_IN_DAY = 24L * this.MILLIS_IN_HOUR();
    private final long MILLIS_IN_MONTH = (long)(30.43684991666667 * (double)this.MILLIS_IN_DAY());
    private final int MONTHS_IN_YEAR;
    private int diff;
    private String randomOutputDir;
    private int slashCount = 0;
    private TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
    private final long now = System.currentTimeMillis();

    public Context context() {
        return this.context;
    }

    public void context_$eq(Context x$1) {
        this.context = x$1;
    }

    public EchoEncoder<Object> encoder() {
        return this.encoder;
    }

    public void encoder_$eq(EchoEncoder<Object> x$1) {
        this.encoder = x$1;
    }

    public String MONTHLY_DATE_PATTERN() {
        return this.MONTHLY_DATE_PATTERN;
    }

    public String MONTHLY_CRONOLOG_DATE_PATTERN() {
        return this.MONTHLY_CRONOLOG_DATE_PATTERN;
    }

    public final String DAILY_CRONOLOG_DATE_PATTERN() {
        return this.DAILY_CRONOLOG_DATE_PATTERN;
    }

    public long MILLIS_IN_MINUTE() {
        return this.MILLIS_IN_MINUTE;
    }

    public long MILLIS_IN_HOUR() {
        return this.MILLIS_IN_HOUR;
    }

    public long MILLIS_IN_DAY() {
        return this.MILLIS_IN_DAY;
    }

    public long MILLIS_IN_MONTH() {
        return this.MILLIS_IN_MONTH;
    }

    public int MONTHS_IN_YEAR() {
        return this.MONTHS_IN_YEAR;
    }

    public int diff() {
        return this.diff;
    }

    public void diff_$eq(int x$1) {
        this.diff = x$1;
    }

    public String randomOutputDir() {
        return this.randomOutputDir;
    }

    public void randomOutputDir_$eq(String x$1) {
        this.randomOutputDir = x$1;
    }

    public int slashCount() {
        return this.slashCount;
    }

    public void slashCount_$eq(int x$1) {
        this.slashCount = x$1;
    }

    public TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp() {
        return this.tbfnatp;
    }

    public void tbfnatp_$eq(TimeBasedFileNamingAndTriggeringPolicy<Object> x$1) {
        this.tbfnatp = x$1;
    }

    public long now() {
        return this.now;
    }

    @Before
    public void setUp() {
        this.context().setName("test");
        this.diff_$eq(RandomUtil.getPositiveInt());
        this.randomOutputDir_$eq(new StringBuilder().append((Object)CoreTestConstants.OUTPUT_DIR_PREFIX).append((Object)BoxesRunTime.boxToInteger((int)this.diff())).append((Object)"/").toString());
    }

    public int computeSlashCount(String datePattern) {
        return datePattern == null ? 0 : BoxesRunTime.unboxToInt((Object)new StringOps(Predef$.MODULE$.augmentString(datePattern)).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int count, char c) {
                return c == '/' ? count + 1 : count;
            }
        }));
    }

    @Test
    public void monthlyRolloverOverManyPeriods() {
        this.slashCount_$eq(this.computeSlashCount(this.MONTHLY_CRONOLOG_DATE_PATTERN()));
        int numPeriods = 40;
        int maxHistory = 2;
        String fileNamePattern = new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)this.MONTHLY_CRONOLOG_DATE_PATTERN()).append((Object)"}/clean.txt.zip").toString();
        Tuple2<Object, Object> tuple2 = this.logOverMultiplePeriods(this.now(), fileNamePattern, this.MILLIS_IN_MONTH(), maxHistory, numPeriods, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long startTime = tuple2._1$mcJ$sp();
            long endTime = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(startTime, endTime);
            long startTime2 = sp3._1$mcJ$sp();
            long endTime2 = sp3._2$mcJ$sp();
            int differenceInMonths = RollingCalendar.diffInMonths((long)startTime2, (long)endTime2);
            Calendar startTimeAsCalendar = Calendar.getInstance();
            startTimeAsCalendar.setTimeInMillis(startTime2);
            int indexOfStartPeriod = startTimeAsCalendar.get(2);
            boolean withExtraFolder = this.extraFolder(differenceInMonths, this.MONTHS_IN_YEAR(), indexOfStartPeriod, maxHistory);
            this.check(this.expectedCountWithFolders$1(maxHistory, withExtraFolder));
            return;
        }
        throw new MatchError(tuple2);
    }

    public void generateDailyRollover(long now, int maxHistory, int simulatedNumberOfPeriods, int startInactivity, int numInactivityPeriods) {
        this.slashCount_$eq(this.computeSlashCount("yyyy-MM-dd"));
        this.logOverMultiplePeriods(now, new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString(), this.MILLIS_IN_DAY(), maxHistory, simulatedNumberOfPeriods, startInactivity, numInactivityPeriods);
        this.check(this.expectedCountWithoutFoldersWithInactivity(maxHistory, simulatedNumberOfPeriods, startInactivity + numInactivityPeriods));
    }

    @Test
    public void basicDailyRollover() {
        this.generateDailyRollover(this.now(), 20, 60, 0, 0);
    }

    @Test
    public void dailyRollover15() {
        this.generateDailyRollover(this.now(), 5, 15, 6, 3);
    }

    @Test
    public void dailyRolloverWithInactivity70() {
        this.generateDailyRollover(this.now(), 6, 70, 30, 1);
    }

    @Test
    public void dailyRolloverWithInactivity10() {
        this.generateDailyRollover(this.now(), 6, 10, 3, 4);
    }

    @Test
    public void dailyRolloverWithSecondPhase() {
        this.slashCount_$eq(this.computeSlashCount("yyyy-MM-dd"));
        int maxHistory = 5;
        int simulatedNumberOfPeriods = maxHistory * 2;
        Tuple2<Object, Object> tuple2 = this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString(), this.MILLIS_IN_DAY(), maxHistory, maxHistory * 2, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long startTime = tuple2._1$mcJ$sp();
            long endTime = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(startTime, endTime);
            long startTime2 = sp3._1$mcJ$sp();
            long endTime2 = sp3._2$mcJ$sp();
            this.logOverMultiplePeriods(endTime2 + this.MILLIS_IN_DAY() * 10L, new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString(), this.MILLIS_IN_DAY(), maxHistory, maxHistory, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
            this.check(this.expectedCountWithoutFolders(maxHistory));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void dailyCronologRollover() {
        this.slashCount_$eq(this.computeSlashCount(this.DAILY_CRONOLOG_DATE_PATTERN()));
        this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)this.DAILY_CRONOLOG_DATE_PATTERN()).append((Object)"}/clean.txt.zip").toString(), this.MILLIS_IN_DAY(), 8, 24, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        int expectedDirMin = 9 + this.slashCount();
        int expectDirMax = expectedDirMin + 1 + 1;
        this.expectedFileAndDirCount(9, expectedDirMin, expectDirMax);
    }

    @Test
    public void dailySizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(this.computeSlashCount("yyyy-MM-dd"));
        this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}-clean.%i.zip").toString(), this.MILLIS_IN_DAY(), 5, 20, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        this.checkPatternCompliance(6 + this.slashCount(), "\\d{4}-\\d{2}-\\d{2}-clean(\\.\\d)(.zip)?");
    }

    @Test
    public void dailyChronologSizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(1);
        this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}/clean.%i.zip").toString(), this.MILLIS_IN_DAY(), 5, 20, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        this.checkDirPatternCompliance(6);
    }

    @Test
    public void dailyChronologSizeBasedRolloverWithSecondPhase() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(1);
        int maxHistory = 5;
        int simulatedNumberOfPeriods = maxHistory * 4;
        Tuple2<Object, Object> tuple2 = this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}/clean.%i").toString(), this.MILLIS_IN_DAY(), maxHistory, 3, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long startTime = tuple2._1$mcJ$sp();
            long endTime = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(startTime, endTime);
            long startTime2 = sp3._1$mcJ$sp();
            long endTime2 = sp3._2$mcJ$sp();
            this.logOverMultiplePeriods(endTime2 + this.MILLIS_IN_DAY() * 7L, new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}/clean.%i").toString(), this.MILLIS_IN_DAY(), maxHistory, simulatedNumberOfPeriods, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
            this.checkDirPatternCompliance(maxHistory + 1);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void logOncePeriod(long currentTime, String fileNamePattern, int maxHistory) {
        Tuple2<RollingFileAppender<Object>, TimeBasedRollingPolicy<Object>> tuple2 = this.buildRollingFileAppender(currentTime, fileNamePattern, maxHistory, true);
        if (tuple2 != null) {
            Tuple2 tuple22;
            RollingFileAppender rfa = (RollingFileAppender)tuple2._1();
            TimeBasedRollingPolicy tbrp = (TimeBasedRollingPolicy)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rfa, (Object)tbrp);
            RollingFileAppender rfa2 = (RollingFileAppender)tuple23._1();
            TimeBasedRollingPolicy tbrp2 = (TimeBasedRollingPolicy)tuple23._2();
            rfa2.doAppend((Object)new StringBuilder().append((Object)"Hello ----------------------------------------------------------").append((Object)new Date(currentTime)).toString());
            rfa2.stop();
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void cleanHistoryOnStart() {
        LongRef now = new LongRef(this.now());
        String fileNamePattern = new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString();
        int maxHistory = 3;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)new Serializable(this, now, fileNamePattern, maxHistory){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeBasedRollingWithArchiveRemoval_STest $outer;
            private final LongRef now$1;
            private final String fileNamePattern$1;
            private final int maxHistory$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.logOncePeriod(this.now$1.elem, this.fileNamePattern$1, this.maxHistory$2);
                this.now$1.elem += this.$outer.MILLIS_IN_DAY();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$1 = now$1;
                this.fileNamePattern$1 = fileNamePattern$1;
                this.maxHistory$2 = maxHistory$2;
            }
        });
        StatusPrinter.print((Context)this.context());
        this.check(this.expectedCountWithoutFolders(maxHistory));
    }

    public boolean extraFolder(int numPeriods, int periodsPerEra, int beginPeriod, int maxHistory) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"numPeriods=").append((Object)BoxesRunTime.boxToInteger((int)numPeriods)).append((Object)", beginPeriod=").append((Object)BoxesRunTime.boxToInteger((int)beginPeriod)).append((Object)", maxHistory=").append((Object)BoxesRunTime.boxToInteger((int)maxHistory)).toString());
        int valueOfLastMonth = (beginPeriod + numPeriods) % periodsPerEra;
        return valueOfLastMonth < maxHistory;
    }

    public long addTime(long currentTime, long timeToWait) {
        return currentTime + timeToWait;
    }

    public void waitForCompression(TimeBasedRollingPolicy<Object> tbrp) {
        if (tbrp.future != null && !tbrp.future.isDone()) {
            tbrp.future.get(1000L, TimeUnit.MILLISECONDS);
        }
    }

    public Tuple2<RollingFileAppender<Object>, TimeBasedRollingPolicy<Object>> buildRollingFileAppender(long currentTime, String fileNamePattern, int maxHistory, boolean cleanHistoryOnStart2) {
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context());
        rfa.setEncoder(this.encoder());
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context());
        tbrp.setFileNamePattern(fileNamePattern);
        tbrp.setMaxHistory(maxHistory);
        tbrp.setParent((FileAppender)rfa);
        tbrp.setCleanHistoryOnStart(cleanHistoryOnStart2);
        tbrp.timeBasedFileNamingAndTriggeringPolicy = this.tbfnatp();
        tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(currentTime);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        return new Tuple2((Object)rfa, (Object)tbrp);
    }

    public boolean buildRollingFileAppender$default$4() {
        return false;
    }

    public Tuple2<Object, Object> logOverMultiplePeriods(long currentTime, String fileNamePattern, long periodDurationInMillis, int maxHistory, int simulatedNumberOfPeriods, int startInactivity, int numInactivityPeriods) {
        long startTime = currentTime;
        Tuple2<RollingFileAppender<Object>, TimeBasedRollingPolicy<Object>> tuple2 = this.buildRollingFileAppender(currentTime, fileNamePattern, maxHistory, this.buildRollingFileAppender$default$4());
        if (tuple2 != null) {
            Tuple2 tuple22;
            RollingFileAppender rfa = (RollingFileAppender)tuple2._1();
            TimeBasedRollingPolicy tbrp = (TimeBasedRollingPolicy)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rfa, (Object)tbrp);
            RollingFileAppender rfa2 = (RollingFileAppender)tuple23._1();
            TimeBasedRollingPolicy tbrp2 = (TimeBasedRollingPolicy)tuple23._2();
            int ticksPerPeriod = 512;
            int runLength = simulatedNumberOfPeriods * ticksPerPeriod;
            int startInactivityIndex = 1 + startInactivity * ticksPerPeriod;
            int endInactivityIndex = startInactivityIndex + numInactivityPeriods * ticksPerPeriod;
            long tickDuration = periodDurationInMillis / (long)ticksPerPeriod;
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), runLength).foreach$mVc$sp((Function1)new Serializable(this, rfa2, tbrp2, ticksPerPeriod, startInactivityIndex, endInactivityIndex, tickDuration){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TimeBasedRollingWithArchiveRemoval_STest $outer;
                private final RollingFileAppender rfa$1;
                private final TimeBasedRollingPolicy tbrp$1;
                private final int ticksPerPeriod$1;
                private final int startInactivityIndex$1;
                private final int endInactivityIndex$1;
                private final long tickDuration$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    if (i < this.startInactivityIndex$1 || i > this.endInactivityIndex$1) {
                        this.rfa$1.doAppend((Object)new StringBuilder().append((Object)"Hello ----------------------------------------------------------").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                    }
                    this.tbrp$1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.$outer.addTime(this.tbrp$1.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime(), this.tickDuration$1));
                    if (i % (this.ticksPerPeriod$1 / 2) == 0) {
                        this.$outer.waitForCompression((TimeBasedRollingPolicy<Object>)this.tbrp$1);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.rfa$1 = rfa$1;
                    this.tbrp$1 = tbrp$1;
                    this.ticksPerPeriod$1 = ticksPerPeriod$1;
                    this.startInactivityIndex$1 = startInactivityIndex$1;
                    this.endInactivityIndex$1 = endInactivityIndex$1;
                    this.tickDuration$1 = tickDuration$1;
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Last date").append((Object)new Date(tbrp2.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime())).toString());
            this.waitForCompression((TimeBasedRollingPolicy<Object>)tbrp2);
            rfa2.stop();
            return new Tuple2.mcJJ.sp(startTime, tbrp2.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime());
        }
        throw new MatchError(tuple2);
    }

    public int logOverMultiplePeriods$default$6() {
        return 0;
    }

    public int logOverMultiplePeriods$default$7() {
        return 0;
    }

    public int expectedCountWithoutFolders(int maxHistory) {
        return maxHistory + 1;
    }

    public int expectedCountWithoutFoldersWithInactivity(int maxHistory, int totalPeriods, int endOfInactivity) {
        int availableHistory = totalPeriods + 1 - endOfInactivity;
        int actualHistory = package$.MODULE$.min(availableHistory, maxHistory + 1);
        return actualHistory;
    }

    public void genericFindMatching(Function2<File, String, Object> matchFunc, File dir, ListBuffer<File> fileList, String pattern, boolean includeDirs) {
        if (dir.isDirectory()) {
            File[] match = dir.listFiles(new FileFilter(this, matchFunc, pattern){
                private final Function2 matchFunc$1;
                private final String pattern$1;

                public boolean accept(File f) {
                    return f.isDirectory() || BoxesRunTime.unboxToBoolean((Object)this.matchFunc$1.apply((Object)f, (Object)this.pattern$1));
                }
                {
                    this.matchFunc$1 = matchFunc$1;
                    this.pattern$1 = pattern$1;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])match).foreach((Function1)new Serializable(this, matchFunc, fileList, pattern, includeDirs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TimeBasedRollingWithArchiveRemoval_STest $outer;
                private final Function2 matchFunc$1;
                private final ListBuffer fileList$1;
                private final String pattern$1;
                private final boolean includeDirs$1;

                public final Object apply(File f) {
                    ListBuffer listBuffer;
                    if (f.isDirectory()) {
                        Object object = this.includeDirs$1 ? this.fileList$1.$plus$eq((Object)f) : BoxedUnit.UNIT;
                        this.$outer.genericFindMatching((Function2<File, String, Object>)this.matchFunc$1, f, (ListBuffer<File>)this.fileList$1, this.pattern$1, this.includeDirs$1);
                        listBuffer = BoxedUnit.UNIT;
                    } else {
                        listBuffer = this.fileList$1.$plus$eq((Object)f);
                    }
                    return listBuffer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.matchFunc$1 = matchFunc$1;
                    this.fileList$1 = fileList$1;
                    this.pattern$1 = pattern$1;
                    this.includeDirs$1 = includeDirs$1;
                }
            });
        }
    }

    public String genericFindMatching$default$4() {
        return null;
    }

    public boolean genericFindMatching$default$5() {
        return false;
    }

    public void findAllFoldersInFolderRecursively(File dir, ListBuffer<File> fileList) {
        this.genericFindMatching((Function2<File, String, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File f, String p) {
                return false;
            }
        }, dir, fileList, null, true);
    }

    public void findAllDirsOrStringContainsFilesRecursively(File dir, ListBuffer<File> fileList, String pattern) {
        this.genericFindMatching((Function2<File, String, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File f, String pattern) {
                return f.getName().contains(pattern);
            }
        }, dir, fileList, pattern, true);
    }

    public void findFilesInFolderRecursivelyByPatterMatch(File dir, ListBuffer<File> fileList, String pattern) {
        this.genericFindMatching((Function2<File, String, Object>)new Serializable(this, pattern){
            public static final long serialVersionUID = 0L;
            private final String pattern$2;

            public final boolean apply(File f, String p) {
                return f.getName().matches(this.pattern$2);
            }
            {
                this.pattern$2 = pattern$2;
            }
        }, dir, fileList, pattern, this.genericFindMatching$default$5());
    }

    public void expectedFileAndDirCount(int expectedFileAndDirCount, int expectedDirCountMin, int expectedDirCountMax) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, (ListBuffer<File>)fileList, "clean");
        ListBuffer dirList = new ListBuffer();
        this.findAllFoldersInFolderRecursively(dir, (ListBuffer<File>)dirList);
        String msg = new StringBuilder().append((Object)"expectedDirCountMin=").append((Object)BoxesRunTime.boxToInteger((int)expectedDirCountMin)).append((Object)", expectedDirCountMax=").append((Object)BoxesRunTime.boxToInteger((int)expectedDirCountMax)).append((Object)" actual value=").append((Object)BoxesRunTime.boxToInteger((int)dirList.size())).toString();
        Assert.assertTrue((String)msg, (expectedDirCountMin <= dirList.size() && dirList.size() <= expectedDirCountMax ? 1 : 0) != 0);
    }

    public void check(int expectedCount) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findAllDirsOrStringContainsFilesRecursively(dir, (ListBuffer<File>)fileList, "clean");
        Assert.assertEquals((long)expectedCount, (long)fileList.size());
    }

    public Set<String> groupByClass(ListBuffer<File> fileList, String regex) {
        Pattern p = Pattern.compile(regex);
        HashSet set = new HashSet();
        fileList.foreach((Function1)new Serializable(this, p, set){
            public static final long serialVersionUID = 0L;
            private final Pattern p$1;
            private final HashSet set$1;

            public final boolean apply(File f) {
                String n = f.getName();
                Matcher m = this.p$1.matcher(n);
                m.matches();
                int begin = m.start(1);
                String reduced = n.substring(0, begin);
                return this.set$1.add((Object)reduced);
            }
            {
                this.p$1 = p$1;
                this.set$1 = set$1;
            }
        });
        return set;
    }

    public void checkPatternCompliance(int expectedClassCount, String regex) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, (ListBuffer<File>)fileList, regex);
        Set<String> set = this.groupByClass((ListBuffer<File>)fileList, regex);
        Assert.assertEquals((long)expectedClassCount, (long)set.size());
    }

    public void checkDirPatternCompliance(int expectedClassCount) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findAllFoldersInFolderRecursively(dir, (ListBuffer<File>)fileList);
        fileList.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File f) {
                Assert.assertTrue((f.list().length >= 1 ? 1 : 0) != 0);
            }
        });
        Assert.assertEquals((long)expectedClassCount, (long)fileList.size());
    }

    private final int expectedCountWithFolders$1(int maxHistory$1, boolean withExtraFolder$1) {
        int numLogFiles = maxHistory$1 + 1;
        int numLogFilesAndFolders = numLogFiles * 2;
        int result = numLogFilesAndFolders + this.slashCount();
        if (withExtraFolder$1) {
            ++result;
        }
        return result;
    }

    public TimeBasedRollingWithArchiveRemoval_STest() {
        this.MONTHLY_DATE_PATTERN = "yyyy-MM";
        this.MONTHLY_CRONOLOG_DATE_PATTERN = "yyyy/MM";
        this.DAILY_CRONOLOG_DATE_PATTERN = "yyyy/MM/dd";
        this.MILLIS_IN_MINUTE = 60000L;
        this.MONTHS_IN_YEAR = 12;
    }
}

