/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.spi.CyclicBufferTracker;
import ch.qos.logback.core.spi.CyclicBufferTrackerImpl;
import ch.qos.logback.core.spi.CyclicBufferTracker_TImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBufferTrackerSimulator {
    CyclicBufferTrackerImpl<Object> realCBTracker = new CyclicBufferTrackerImpl();
    CyclicBufferTracker_TImpl<Object> t_CBTracker = new CyclicBufferTracker_TImpl();
    List<SimulationEvent> scenario = new ArrayList<SimulationEvent>();
    List<String> keySpace = new ArrayList<String>();
    int maxTimestampInc;
    Random randomKeyGen = new Random(100L);
    Random simulatorRandom = new Random(11234L);
    int deleteToInsertRatio = 10;

    CyclicBufferTrackerSimulator(int keySpaceLen, int maxTimestampInc) {
        this.maxTimestampInc = maxTimestampInc;
        HashMap<String, String> checkMap = new HashMap<String, String>();
        for (int i = 0; i < keySpaceLen; ++i) {
            String k = this.getRandomKeyStr();
            if (checkMap.containsKey(k)) {
                System.out.println("random key collision occurred");
                k = k + "" + i;
            }
            this.keySpace.add(k);
            checkMap.put(k, k);
        }
    }

    private String getRandomKeyStr() {
        int ri = this.randomKeyGen.nextInt();
        return String.format("%X", ri);
    }

    void buildScenario(int simLen) {
        long timestamp = 30000L;
        int keySpaceLen = this.keySpace.size();
        for (int i = 0; i < simLen; ++i) {
            int index = this.simulatorRandom.nextInt(keySpaceLen);
            timestamp += (long)this.simulatorRandom.nextInt(this.maxTimestampInc);
            EventType eventType = EventType.INSERT;
            if (this.simulatorRandom.nextInt(this.deleteToInsertRatio) == 0) {
                eventType = EventType.DELETE;
            }
            String key = this.keySpace.get(index);
            this.scenario.add(new SimulationEvent(eventType, key, timestamp));
        }
    }

    public void dump() {
        for (SimulationEvent simeEvent : this.scenario) {
            System.out.println(simeEvent);
        }
    }

    void play(SimulationEvent simulationEvent, CyclicBufferTracker<Object> tracker) {
        String key = simulationEvent.key;
        long timestamp = simulationEvent.timestamp;
        EventType eventType = simulationEvent.eventType;
        switch (eventType) {
            case INSERT: {
                tracker.getOrCreate(key, timestamp);
                break;
            }
            case DELETE: {
                tracker.removeBuffer(key);
            }
        }
    }

    public void simulate() {
        for (SimulationEvent simeEvent : this.scenario) {
            this.play(simeEvent, (CyclicBufferTracker<Object>)this.realCBTracker);
            this.play(simeEvent, this.t_CBTracker);
        }
    }

    class SimulationEvent {
        public final String key;
        public final long timestamp;
        final EventType eventType;

        public SimulationEvent(EventType eventType, String key, long timestamp) {
            this.eventType = eventType;
            this.key = key;
            this.timestamp = timestamp;
        }

        public String toString() {
            return "Event: k=" + this.key + ", timestamp=" + this.timestamp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EventType {
        INSERT,
        DELETE;

    }
}

