/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.SimpleConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.DefinePropertyAction;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.status.StatusChecker;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DefinePropertyActionTest {
    private static final String DEFINE_INPUT_DIR = "src/test/input/joran/define/";
    private static final String GOOD_XML = "good.xml";
    private static final String NONAME_XML = "noname.xml";
    private static final String NOCLASS_XML = "noclass.xml";
    private static final String BADCLASS_XML = "badclass.xml";
    SimpleConfigurator simpleConfigurator;
    Context context = new ContextBase();
    DefinePropertyAction definerAction;
    InterpretationContext ic;
    StatusChecker checker = new StatusChecker(this.context);

    @Before
    public void setUp() throws Exception {
        HashMap<Pattern, Action> rulesMap = new HashMap<Pattern, Action>();
        rulesMap.put(new Pattern("define"), (Action)new DefinePropertyAction());
        this.simpleConfigurator = new SimpleConfigurator(rulesMap);
        this.simpleConfigurator.setContext(this.context);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void good() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/define/good.xml");
        InterpretationContext ic = this.simpleConfigurator.getInterpreter().getInterpretationContext();
        String inContextFoo = ic.getProperty("foo");
        Assert.assertEquals((String)"monster", (String)inContextFoo);
    }

    @Test
    public void noName() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/define/noname.xml");
        String inContextFoo = this.context.getProperty("foo");
        Assert.assertNull((Object)inContextFoo);
        this.checker.assertContainsMatch(2, "Missing property name for property definer. Near \\[define\\] line 1");
    }

    @Test
    public void noClass() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/define/noclass.xml");
        String inContextFoo = this.context.getProperty("foo");
        Assert.assertNull((Object)inContextFoo);
        this.checker.assertContainsMatch(2, "Missing class name for property definer. Near \\[define\\] line 1");
    }

    @Test
    public void testBadClass() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/define/badclass.xml");
        String inContextFoo = this.context.getProperty("foo");
        Assert.assertNull((Object)inContextFoo);
        this.checker.assertContainsMatch(2, "Could not create an PropertyDefiner of type");
    }
}

