/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.issue;

public class LockingInJava
implements Runnable {
    static int THREAD_COUNT = 5;
    static Object LOCK = new Object();
    static LockingInJava[] RUNNABLE_ARRAY = new LockingInJava[THREAD_COUNT];
    static Thread[] THREAD_ARRAY = new Thread[THREAD_COUNT];
    private int counter = 0;
    private boolean done = false;

    public static void main(String[] args) throws InterruptedException {
        LockingInJava.printEnvironmentInfo();
        LockingInJava.execute();
        LockingInJava.printResults();
    }

    public static void printEnvironmentInfo() {
        System.out.println("java.runtime.version = " + System.getProperty("java.runtime.version"));
        System.out.println("java.vendor          = " + System.getProperty("java.vendor"));
        System.out.println("java.version         = " + System.getProperty("java.version"));
        System.out.println("os.name              = " + System.getProperty("os.name"));
        System.out.println("os.version           = " + System.getProperty("os.version"));
    }

    public static void execute() throws InterruptedException {
        for (int i = 0; i < THREAD_COUNT; ++i) {
            LockingInJava.RUNNABLE_ARRAY[i] = new LockingInJava();
            LockingInJava.THREAD_ARRAY[i] = new Thread(RUNNABLE_ARRAY[i]);
        }
        for (Thread t : THREAD_ARRAY) {
            t.start();
        }
        Thread.sleep(10000L);
        for (int i = THREAD_COUNT - 1; i <= 0; --i) {
            LockingInJava.RUNNABLE_ARRAY[i].done = true;
        }
    }

    public static void printResults() {
        for (int i = 0; i < RUNNABLE_ARRAY.length; ++i) {
            System.out.println("runnable[" + i + "]: " + RUNNABLE_ARRAY[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object = LOCK;
            synchronized (object) {
                ++this.counter;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.done) {
                    return;
                }
            }
        }
    }

    public String toString() {
        return "counter=" + this.counter;
    }
}

