/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.CoreTestConstants;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileFilter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\rma\u0001B\u0001\u0003\u00015\u0011\u0001\u0006V5nK\n\u000b7/\u001a3S_2d\u0017N\\4XSRD\u0017I]2iSZ,'+Z7pm\u0006dwl\u0015+fgRT!a\u0001\u0003\u0002\u000fI|G\u000e\\5oO*\u0011QAB\u0001\u0005G>\u0014XM\u0003\u0002\b\u0011\u00059An\\4cC\u000e\\'BA\u0005\u000b\u0003\r\txn\u001d\u0006\u0002\u0017\u0005\u00111\r[\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\tY1kY1mC>\u0013'.Z2u\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001C\u0004#\u0001\u0001\u0007I\u0011A\u0012\u0002\u000f\r|g\u000e^3yiV\tA\u0005\u0005\u0002&M5\tA!\u0003\u0002(\t\t91i\u001c8uKb$\bbB\u0015\u0001\u0001\u0004%\tAK\u0001\fG>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0002,]A\u0011q\u0003L\u0005\u0003[a\u0011A!\u00168ji\"9q\u0006KA\u0001\u0002\u0004!\u0013a\u0001=%c!1\u0011\u0007\u0001Q!\n\u0011\n\u0001bY8oi\u0016DH\u000f\t\u0005\bg\u0001\u0001\r\u0011\"\u00015\u0003\u001d)gnY8eKJ,\u0012!\u000e\t\u0004maRT\"A\u001c\u000b\u0005M\"\u0011BA\u001d8\u0005-)5\r[8F]\u000e|G-\u001a:\u0011\u0005]Y\u0014B\u0001\u001f\u0019\u0005\u0019\te.\u001f*fM\"9a\b\u0001a\u0001\n\u0003y\u0014aC3oG>$WM]0%KF$\"a\u000b!\t\u000f=j\u0014\u0011!a\u0001k!1!\t\u0001Q!\nU\n\u0001\"\u001a8d_\u0012,'\u000f\t\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0003QiuJ\u0014+I\u0019f{F)\u0011+F?B\u000bE\u000bV#S\u001dV\ta\t\u0005\u0002H\u0015:\u0011q\u0003S\u0005\u0003\u0013b\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011\n\u0007\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002$\u0002+5{e\n\u0016%M3~#\u0015\tV#`!\u0006#F+\u0012*OA!9\u0001\u000b\u0001b\u0001\n\u0003)\u0015!H'P\u001dRCE*W0D%>su\nT(H?\u0012\u000bE+R0Q\u0003R#VI\u0015(\t\rI\u0003\u0001\u0015!\u0003G\u0003yiuJ\u0014+I\u0019f{6IU(O\u001f2{ui\u0018#B)\u0016{\u0006+\u0011+U\u000bJs\u0005\u0005C\u0004U\u0001\t\u0007IQA#\u00027\u0011\u000b\u0015\nT-`\u0007J{ej\u0014'P\u000f~#\u0015\tV#`!\u0006#F+\u0012*O\u0011\u00191\u0006\u0001)A\u0007\r\u0006aB)Q%M3~\u001b%k\u0014(P\u0019>;u\fR!U\u000b~\u0003\u0016\t\u0016+F%:\u0003\u0003b\u0002-\u0001\u0005\u0004%\t!W\u0001\u0011\u001b&cE*S*`\u0013:{V*\u0013(V)\u0016+\u0012A\u0017\t\u0003/mK!\u0001\u0018\r\u0003\t1{gn\u001a\u0005\u0007=\u0002\u0001\u000b\u0011\u0002.\u0002#5KE\nT%T?&su,T%O+R+\u0005\u0005C\u0004a\u0001\t\u0007I\u0011A-\u0002\u001d5KE\nT%T?&su\fS(V%\"1!\r\u0001Q\u0001\ni\u000bq\"T%M\u0019&\u001bv,\u0013(`\u0011>+&\u000b\t\u0005\bI\u0002\u0011\r\u0011\"\u0001Z\u00035i\u0015\n\u0014'J'~Kej\u0018#B3\"1a\r\u0001Q\u0001\ni\u000ba\"T%M\u0019&\u001bv,\u0013(`\t\u0006K\u0006\u0005C\u0004i\u0001\t\u0007I\u0011A-\u0002\u001f5KE\nT%T?&su,T(O)\"CaA\u001b\u0001!\u0002\u0013Q\u0016\u0001E'J\u00192K5kX%O?6{e\n\u0016%!\u0011\u001da\u0007A1A\u0005\u00025\fa\"T(O)\"\u001bv,\u0013(`3\u0016\u000b%+F\u0001o!\t9r.\u0003\u0002q1\t\u0019\u0011J\u001c;\t\rI\u0004\u0001\u0015!\u0003o\u0003=iuJ\u0014+I'~KejX-F\u0003J\u0003\u0003b\u0002;\u0001\u0001\u0004%\t!\\\u0001\u0005I&4g\rC\u0004w\u0001\u0001\u0007I\u0011A<\u0002\u0011\u0011LgMZ0%KF$\"a\u000b=\t\u000f=*\u0018\u0011!a\u0001]\"1!\u0010\u0001Q!\n9\fQ\u0001Z5gM\u0002Bq\u0001 \u0001A\u0002\u0013\u0005Q)A\bsC:$w.\\(viB,H\u000fR5s\u0011\u001dq\b\u00011A\u0005\u0002}\f1C]1oI>lw*\u001e;qkR$\u0015N]0%KF$2aKA\u0001\u0011\u001dyS0!AA\u0002\u0019Cq!!\u0002\u0001A\u0003&a)\u0001\tsC:$w.\\(viB,H\u000fR5sA!A\u0011\u0011\u0002\u0001A\u0002\u0013\u0005Q.\u0001\u0006tY\u0006\u001c\bnQ8v]RD\u0011\"!\u0004\u0001\u0001\u0004%\t!a\u0004\u0002\u001dMd\u0017m\u001d5D_VtGo\u0018\u0013fcR\u00191&!\u0005\t\u0011=\nY!!AA\u00029Dq!!\u0006\u0001A\u0003&a.A\u0006tY\u0006\u001c\bnQ8v]R\u0004\u0003\"CA\r\u0001\u0001\u0007I\u0011AA\u000e\u0003\u001d!(M\u001a8biB,\"!!\b\u0011\t\u0001\nyBO\u0005\u0004\u0003C\u0011!A\n+j[\u0016\u0014\u0015m]3e\r&dWMT1nS:<\u0017I\u001c3Ue&<w-\u001a:j]\u001e\u0004v\u000e\\5ds\"I\u0011Q\u0005\u0001A\u0002\u0013\u0005\u0011qE\u0001\fi\n4g.\u0019;q?\u0012*\u0017\u000fF\u0002,\u0003SA\u0011bLA\u0012\u0003\u0003\u0005\r!!\b\t\u0011\u00055\u0002\u0001)Q\u0005\u0003;\t\u0001\u0002\u001e2g]\u0006$\b\u000f\t\u0005\t\u0003c\u0001!\u0019!C\u00013\u0006\u0019an\\<\t\u000f\u0005U\u0002\u0001)A\u00055\u0006!an\\<!\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\tQa]3u+B,\u0012a\u000b\u0015\u0005\u0003o\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u000b),h.\u001b;\u000b\u0005\u0005%\u0013aA8sO&!\u0011QJA\"\u0005\u0019\u0011UMZ8sK\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013!E2p[B,H/Z*mCND7i\\;oiR\u0019a.!\u0016\t\u000f\u0005]\u0013q\na\u0001\r\u0006YA-\u0019;f!\u0006$H/\u001a:o\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\na$\\8oi\"d\u0017PU8mY>4XM](wKJl\u0015M\\=QKJLw\u000eZ:\u0015\u0003-BC!!\u0017\u0002bA!\u0011\u0011IA2\u0013\u0011\t)'a\u0011\u0003\tQ+7\u000f\u001e\u0005\b\u0003S\u0002A\u0011AA6\u0003U9WM\\3sCR,G)Y5msJ{G\u000e\\8wKJ$2bKA7\u0003_\n\u0019(a\u001e\u0002|!9\u0011\u0011GA4\u0001\u0004Q\u0006bBA9\u0003O\u0002\rA\\\u0001\u000b[\u0006D\b*[:u_JL\bbBA;\u0003O\u0002\rA\\\u0001\u0019g&lW\u000f\\1uK\u0012tU/\u001c2fe>3\u0007+\u001a:j_\u0012\u001c\bbBA=\u0003O\u0002\rA\\\u0001\u0010gR\f'\u000f^%oC\u000e$\u0018N^5us\"9\u0011QPA4\u0001\u0004q\u0017\u0001\u00068v[&s\u0017m\u0019;jm&$\u0018\u0010U3sS>$7\u000fC\u0004\u0002\u0002\u0002!\t!a\u000f\u0002%\t\f7/[2EC&d\u0017PU8mY>4XM\u001d\u0015\u0005\u0003\u007f\n\t\u0007C\u0004\u0002\b\u0002!\t!a\u000f\u0002\u001f\u0011\f\u0017\u000e\\=S_2dwN^3scUBC!!\"\u0002b!9\u0011Q\u0012\u0001\u0005\u0002\u0005m\u0012!\b3bS2L(k\u001c7m_Z,'oV5uQ&s\u0017m\u0019;jm&$\u0018p\u000e\u0019)\t\u0005-\u0015\u0011\r\u0005\b\u0003'\u0003A\u0011AA\u001e\u0003u!\u0017-\u001b7z%>dGn\u001c<fe^KG\u000f[%oC\u000e$\u0018N^5usF\u0002\u0004\u0006BAI\u0003CBq!!'\u0001\t\u0003\tY$\u0001\u000feC&d\u0017PU8mY>4XM],ji\"\u001cVmY8oIBC\u0017m]3)\t\u0005]\u0015\u0011\r\u0005\b\u0003?\u0003A\u0011AA\u001e\u0003U!\u0017-\u001b7z\u0007J|gn\u001c7pOJ{G\u000e\\8wKJDC!!(\u0002b!9\u0011Q\u0015\u0001\u0005\u0002\u0005m\u0012A\u00063bS2L8+\u001b>f\u0005\u0006\u001cX\r\u001a*pY2|g/\u001a:)\t\u0005\r\u0016\u0011\r\u0005\b\u0003W\u0003A\u0011AA\u001e\u0003}!\u0017-\u001b7z\u0007\"\u0014xN\\8m_\u001e\u001c\u0016N_3CCN,GMU8mY>4XM\u001d\u0015\u0005\u0003S\u000b\t\u0007C\u0004\u00022\u0002!\t!a\u000f\u0002]\u0011\f\u0017\u000e\\=DQJ|gn\u001c7pONK'0\u001a\"bg\u0016$'k\u001c7m_Z,'oV5uQN+7m\u001c8e!\"\f7/\u001a\u0015\u0005\u0003_\u000b\t\u0007C\u0004\u00028\u0002!\t!!/\u0002\u001b1|wm\u00148dKB+'/[8e)\u001dY\u00131XA`\u0003\u0007Dq!!0\u00026\u0002\u0007!,A\u0006dkJ\u0014XM\u001c;US6,\u0007bBAa\u0003k\u0003\rAR\u0001\u0010M&dWMT1nKB\u000bG\u000f^3s]\"9\u0011\u0011OA[\u0001\u0004q\u0007bBAd\u0001\u0011\u0005\u00111H\u0001\u0014G2,\u0017M\u001c%jgR|'/_(o'R\f'\u000f\u001e\u0015\u0005\u0003\u000b\f\t\u0007C\u0004\u0002N\u0002!\t!a4\u0002\u0017\u0015DHO]1G_2$WM\u001d\u000b\u000b\u0003#\f9.a7\u0002`\u0006\r\bcA\f\u0002T&\u0019\u0011Q\u001b\r\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\\Af\u0001\u0004q\u0017A\u00038v[B+'/[8eg\"9\u0011Q\\Af\u0001\u0004q\u0017!\u00049fe&|Gm\u001d)fe\u0016\u0013\u0018\rC\u0004\u0002b\u0006-\u0007\u0019\u00018\u0002\u0017\t,w-\u001b8QKJLw\u000e\u001a\u0005\b\u0003c\nY\r1\u0001o\u0011\u001d\t9\u000f\u0001C\u0001\u0003S\fq!\u00193e)&lW\rF\u0003[\u0003W\fi\u000fC\u0004\u0002>\u0006\u0015\b\u0019\u0001.\t\u000f\u0005=\u0018Q\u001da\u00015\u0006QA/[7f)><\u0016-\u001b;\t\u000f\u0005M\b\u0001\"\u0001\u0002v\u0006\u0011r/Y5u\r>\u00148i\\7qe\u0016\u001c8/[8o)\rY\u0013q\u001f\u0005\t\u0003s\f\t\u00101\u0001\u0002|\u0006!AO\u0019:q!\u0011\u0001\u0013Q \u001e\n\u0007\u0005}(A\u0001\fUS6,')Y:fIJ{G\u000e\\5oOB{G.[2z\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000b\t\u0001DY;jY\u0012\u0014v\u000e\u001c7j]\u001e4\u0015\u000e\\3BaB,g\u000eZ3s))\u00119Aa\u0005\u0003\u0016\t]!\u0011\u0004\t\b/\t%!QBA~\u0013\r\u0011Y\u0001\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0001\u0012yAO\u0005\u0004\u0005#\u0011!a\u0005*pY2Lgn\u001a$jY\u0016\f\u0005\u000f]3oI\u0016\u0014\bbBA_\u0005\u0003\u0001\rA\u0017\u0005\b\u0003\u0003\u0014\t\u00011\u0001G\u0011\u001d\t\tH!\u0001A\u00029D!\"a2\u0003\u0002A\u0005\t\u0019AAi\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005?\ta\u0003\\8h\u001fZ,'/T;mi&\u0004H.\u001a)fe&|Gm\u001d\u000b\u0011\u0005C\u0011\u0019C!\n\u0003(\t-\"Q\u0006B\u0018\u0005c\u0001Ra\u0006B\u00055jCq!!0\u0003\u001c\u0001\u0007!\fC\u0004\u0002B\nm\u0001\u0019\u0001$\t\u000f\t%\"1\u0004a\u00015\u00061\u0002/\u001a:j_\u0012$UO]1uS>t\u0017J\\'jY2L7\u000fC\u0004\u0002r\tm\u0001\u0019\u00018\t\u000f\u0005U$1\u0004a\u0001]\"I\u0011\u0011\u0010B\u000e!\u0003\u0005\rA\u001c\u0005\n\u0003{\u0012Y\u0002%AA\u00029DqA!\u000e\u0001\t\u0003\u00119$A\u000efqB,7\r^3e\u0007>,h\u000e^,ji\"|W\u000f\u001e$pY\u0012,'o\u001d\u000b\u0004]\ne\u0002bBA9\u0005g\u0001\rA\u001c\u0005\b\u0005{\u0001A\u0011\u0001B \u0003%*\u0007\u0010]3di\u0016$7i\\;oi^KG\u000f[8vi\u001a{G\u000eZ3sg^KG\u000f[%oC\u000e$\u0018N^5usR9aN!\u0011\u0003D\t\u001d\u0003bBA9\u0005w\u0001\rA\u001c\u0005\b\u0005\u000b\u0012Y\u00041\u0001o\u00031!x\u000e^1m!\u0016\u0014\u0018n\u001c3t\u0011\u001d\u0011IEa\u000fA\u00029\fq\"\u001a8e\u001f\u001aLe.Y2uSZLG/\u001f\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0003M9WM\\3sS\u000e4\u0015N\u001c3NCR\u001c\u0007.\u001b8h)-Y#\u0011\u000bB4\u0005W\u0012yHa!\t\u0011\tM#1\na\u0001\u0005+\n\u0011\"\\1uG\"4UO\\2\u0011\u0011]\u00119Fa\u0017G\u0003#L1A!\u0017\u0019\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0003^\t\rTB\u0001B0\u0015\r\u0011\tGE\u0001\u0003S>LAA!\u001a\u0003`\t!a)\u001b7f\u0011!\u0011IGa\u0013A\u0002\tm\u0013a\u00013je\"A!Q\u000eB&\u0001\u0004\u0011y'\u0001\u0005gS2,G*[:u!\u0019\u0011\tHa\u001f\u0003\\5\u0011!1\u000f\u0006\u0005\u0005k\u00129(A\u0004nkR\f'\r\\3\u000b\u0007\te\u0004$\u0001\u0006d_2dWm\u0019;j_:LAA! \u0003t\tQA*[:u\u0005V4g-\u001a:\t\u0013\t\u0005%1\nI\u0001\u0002\u00041\u0015a\u00029biR,'O\u001c\u0005\u000b\u0005\u000b\u0013Y\u0005%AA\u0002\u0005E\u0017aC5oG2,H-\u001a#jeNDqA!#\u0001\t\u0003\u0011Y)A\u0011gS:$\u0017\t\u001c7G_2$WM]:J]\u001a{G\u000eZ3s%\u0016\u001cWO]:jm\u0016d\u0017\u0010F\u0003,\u0005\u001b\u0013y\t\u0003\u0005\u0003j\t\u001d\u0005\u0019\u0001B.\u0011!\u0011iGa\"A\u0002\t=\u0004b\u0002BJ\u0001\u0011\u0005!QS\u0001,M&tG-\u00117m\t&\u00148o\u0014:TiJLgnZ\"p]R\f\u0017N\\:GS2,7OU3dkJ\u001c\u0018N^3msR91Fa&\u0003\u001a\nm\u0005\u0002\u0003B5\u0005#\u0003\rAa\u0017\t\u0011\t5$\u0011\u0013a\u0001\u0005_BqA!!\u0003\u0012\u0002\u0007a\tC\u0004\u0003 \u0002!\tA!)\u0002S\u0019Lg\u000e\u001a$jY\u0016\u001c\u0018J\u001c$pY\u0012,'OU3dkJ\u001c\u0018N^3ms\nK\b+\u0019;uKJl\u0015\r^2i)\u001dY#1\u0015BS\u0005OC\u0001B!\u001b\u0003\u001e\u0002\u0007!1\f\u0005\t\u0005[\u0012i\n1\u0001\u0003p!9!\u0011\u0011BO\u0001\u00041\u0005b\u0002BV\u0001\u0011\u0005!QV\u0001\u0018Kb\u0004Xm\u0019;fI\u001aKG.Z!oI\u0012K'oQ8v]R$ra\u000bBX\u0005c\u0013)\fC\u0004\u0003,\n%\u0006\u0019\u00018\t\u000f\tM&\u0011\u0016a\u0001]\u0006\u0019R\r\u001f9fGR,G\rR5s\u0007>,h\u000e^'j]\"9!q\u0017BU\u0001\u0004q\u0017aE3ya\u0016\u001cG/\u001a3ESJ\u001cu.\u001e8u\u001b\u0006D\bb\u0002B^\u0001\u0011\u0005!QX\u0001\u0006G\",7m\u001b\u000b\u0004W\t}\u0006b\u0002Ba\u0005s\u0003\rA\\\u0001\u000eKb\u0004Xm\u0019;fI\u000e{WO\u001c;\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\u0006aqM]8va\nK8\t\\1tgR1!\u0011\u001aBh\u0005#\u0004RA!\u001d\u0003L\u001aKAA!4\u0003t\t\u00191+\u001a;\t\u0011\t5$1\u0019a\u0001\u0005_BqAa5\u0003D\u0002\u0007a)A\u0003sK\u001e,\u0007\u0010C\u0004\u0003X\u0002!\tA!7\u0002-\rDWmY6QCR$XM\u001d8D_6\u0004H.[1oG\u0016$Ra\u000bBn\u0005?DqA!8\u0003V\u0002\u0007a.\u0001\nfqB,7\r^3e\u00072\f7o]\"pk:$\bb\u0002Bj\u0005+\u0004\rA\u0012\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0003e\u0019\u0007.Z2l\t&\u0014\b+\u0019;uKJt7i\\7qY&\fgnY3\u0015\u0007-\u00129\u000fC\u0004\u0003^\n\u0005\b\u0019\u00018\t\u0013\t-\b!%A\u0005\u0002\t5\u0018\u0001\t7pO>3XM]'vYRL\u0007\u000f\\3QKJLw\u000eZ:%I\u00164\u0017-\u001e7uIY*\"Aa<+\u00079\u0014\tp\u000b\u0002\u0003tB!!Q\u001fB\u0000\u001b\t\u00119P\u0003\u0003\u0003z\nm\u0018!C;oG\",7m[3e\u0015\r\u0011i\u0010G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0001\u0005o\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0019)\u0001AI\u0001\n\u0003\u0011i/\u0001\u0011m_\u001e|e/\u001a:Nk2$\u0018\u000e\u001d7f!\u0016\u0014\u0018n\u001c3tI\u0011,g-Y;mi\u0012:\u0004\"CB\u0005\u0001E\u0005I\u0011AB\u0006\u0003\t\u0012W/\u001b7e%>dG.\u001b8h\r&dW-\u00119qK:$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u0002\u0016\u0005\u0003#\u0014\t\u0010C\u0005\u0004\u0012\u0001\t\n\u0011\"\u0001\u0004\u0014\u0005ir-\u001a8fe&\u001cg)\u001b8e\u001b\u0006$8\r[5oO\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u0016)\u001aaI!=\t\u0013\re\u0001!%A\u0005\u0002\r-\u0011!H4f]\u0016\u0014\u0018n\u0019$j]\u0012l\u0015\r^2iS:<G\u0005Z3gCVdG\u000fJ\u001b")
public class TimeBasedRollingWithArchiveRemoval_STest
implements ScalaObject {
    private Context context = new ContextBase();
    private EchoEncoder<Object> encoder = new EchoEncoder();
    private final String MONTHLY_DATE_PATTERN;
    private final String MONTHLY_CRONOLOG_DATE_PATTERN;
    private final String DAILY_CRONOLOG_DATE_PATTERN;
    private final long MILLIS_IN_MINUTE;
    private final long MILLIS_IN_HOUR = 60L * this.MILLIS_IN_MINUTE();
    private final long MILLIS_IN_DAY = 24L * this.MILLIS_IN_HOUR();
    private final long MILLIS_IN_MONTH = (long)(30.43684991666667 * (double)this.MILLIS_IN_DAY());
    private final int MONTHS_IN_YEAR;
    private int diff;
    private String randomOutputDir;
    private int slashCount = 0;
    private TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
    private final long now = System.currentTimeMillis();

    public Context context() {
        return this.context;
    }

    public void context_$eq(Context context) {
        this.context = context;
    }

    public EchoEncoder<Object> encoder() {
        return this.encoder;
    }

    public void encoder_$eq(EchoEncoder<Object> echoEncoder) {
        this.encoder = echoEncoder;
    }

    public String MONTHLY_DATE_PATTERN() {
        return this.MONTHLY_DATE_PATTERN;
    }

    public String MONTHLY_CRONOLOG_DATE_PATTERN() {
        return this.MONTHLY_CRONOLOG_DATE_PATTERN;
    }

    public final String DAILY_CRONOLOG_DATE_PATTERN() {
        return this.DAILY_CRONOLOG_DATE_PATTERN;
    }

    public long MILLIS_IN_MINUTE() {
        return this.MILLIS_IN_MINUTE;
    }

    public long MILLIS_IN_HOUR() {
        return this.MILLIS_IN_HOUR;
    }

    public long MILLIS_IN_DAY() {
        return this.MILLIS_IN_DAY;
    }

    public long MILLIS_IN_MONTH() {
        return this.MILLIS_IN_MONTH;
    }

    public int MONTHS_IN_YEAR() {
        return this.MONTHS_IN_YEAR;
    }

    public int diff() {
        return this.diff;
    }

    public void diff_$eq(int n) {
        this.diff = n;
    }

    public String randomOutputDir() {
        return this.randomOutputDir;
    }

    public void randomOutputDir_$eq(String string) {
        this.randomOutputDir = string;
    }

    public int slashCount() {
        return this.slashCount;
    }

    public void slashCount_$eq(int n) {
        this.slashCount = n;
    }

    public TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp() {
        return this.tbfnatp;
    }

    public void tbfnatp_$eq(TimeBasedFileNamingAndTriggeringPolicy<Object> timeBasedFileNamingAndTriggeringPolicy) {
        this.tbfnatp = timeBasedFileNamingAndTriggeringPolicy;
    }

    public long now() {
        return this.now;
    }

    @Before
    public void setUp() {
        this.context().setName("test");
        this.diff_$eq(RandomUtil.getPositiveInt());
        this.randomOutputDir_$eq(new StringBuilder().append((Object)CoreTestConstants.OUTPUT_DIR_PREFIX).append((Object)BoxesRunTime.boxToInteger((int)this.diff())).append((Object)"/").toString());
    }

    public int computeSlashCount(String datePattern) {
        return datePattern == null ? 0 : BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.augmentString(datePattern).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int count, char c) {
                return c == '/' ? count + 1 : count;
            }
        }));
    }

    @Test
    public void monthlyRolloverOverManyPeriods() {
        this.slashCount_$eq(this.computeSlashCount(this.MONTHLY_CRONOLOG_DATE_PATTERN()));
        int numPeriods = 40;
        int maxHistory$1 = 2;
        String fileNamePattern = new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)this.MONTHLY_CRONOLOG_DATE_PATTERN()).append((Object)"}/clean.txt.zip").toString();
        Tuple2<Object, Object> tuple2 = this.logOverMultiplePeriods(this.now(), fileNamePattern, this.MILLIS_IN_MONTH(), maxHistory$1, numPeriods, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)tuple2._1()), BoxesRunTime.unboxToLong((Object)tuple2._2()));
            long startTime = sp2._1$mcJ$sp();
            long endTime = sp2._2$mcJ$sp();
            int differenceInMonths = RollingCalendar.diffInMonths((long)startTime, (long)endTime);
            Calendar startTimeAsCalendar = Calendar.getInstance();
            startTimeAsCalendar.setTimeInMillis(startTime);
            int indexOfStartPeriod = startTimeAsCalendar.get(2);
            boolean withExtraFolder$1 = this.extraFolder(differenceInMonths, this.MONTHS_IN_YEAR(), indexOfStartPeriod, maxHistory$1);
            this.check(this.expectedCountWithFolders$1(maxHistory$1, withExtraFolder$1));
            return;
        }
        throw new MatchError(tuple2);
    }

    public void generateDailyRollover(long now, int maxHistory, int simulatedNumberOfPeriods, int startInactivity, int numInactivityPeriods) {
        this.slashCount_$eq(this.computeSlashCount("yyyy-MM-dd"));
        this.logOverMultiplePeriods(now, new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString(), this.MILLIS_IN_DAY(), maxHistory, simulatedNumberOfPeriods, startInactivity, numInactivityPeriods);
        this.check(this.expectedCountWithoutFoldersWithInactivity(maxHistory, simulatedNumberOfPeriods, startInactivity + numInactivityPeriods));
    }

    @Test
    public void basicDailyRollover() {
        this.generateDailyRollover(this.now(), 20, 60, 0, 0);
    }

    @Test
    public void dailyRollover15() {
        this.generateDailyRollover(this.now(), 5, 15, 6, 3);
    }

    @Test
    public void dailyRolloverWithInactivity70() {
        this.generateDailyRollover(this.now(), 6, 70, 30, 1);
    }

    @Test
    public void dailyRolloverWithInactivity10() {
        this.generateDailyRollover(this.now(), 6, 10, 3, 4);
    }

    @Test
    public void dailyRolloverWithSecondPhase() {
        this.slashCount_$eq(this.computeSlashCount("yyyy-MM-dd"));
        int maxHistory = 5;
        int simulatedNumberOfPeriods = maxHistory * 2;
        Tuple2<Object, Object> tuple2 = this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString(), this.MILLIS_IN_DAY(), maxHistory, maxHistory * 2, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)tuple2._1()), BoxesRunTime.unboxToLong((Object)tuple2._2()));
            long startTime = sp2._1$mcJ$sp();
            long endTime = sp2._2$mcJ$sp();
            this.logOverMultiplePeriods(endTime + this.MILLIS_IN_DAY() * 10L, new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString(), this.MILLIS_IN_DAY(), maxHistory, maxHistory, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
            this.check(this.expectedCountWithoutFolders(maxHistory));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void dailyCronologRollover() {
        this.slashCount_$eq(this.computeSlashCount(this.DAILY_CRONOLOG_DATE_PATTERN()));
        this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)this.DAILY_CRONOLOG_DATE_PATTERN()).append((Object)"}/clean.txt.zip").toString(), this.MILLIS_IN_DAY(), 8, 24, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        int expectedDirMin = 9 + this.slashCount();
        int expectDirMax = expectedDirMin + 1 + 1;
        this.expectedFileAndDirCount(9, expectedDirMin, expectDirMax);
    }

    @Test
    public void dailySizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(this.computeSlashCount("yyyy-MM-dd"));
        this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}-clean.%i.zip").toString(), this.MILLIS_IN_DAY(), 5, 20, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        this.checkPatternCompliance(6 + this.slashCount(), "\\d{4}-\\d{2}-\\d{2}-clean(\\.\\d)(.zip)?");
    }

    @Test
    public void dailyChronologSizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(1);
        this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}/clean.%i.zip").toString(), this.MILLIS_IN_DAY(), 5, 20, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        this.checkDirPatternCompliance(6);
    }

    @Test
    public void dailyChronologSizeBasedRolloverWithSecondPhase() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp_$eq((TimeBasedFileNamingAndTriggeringPolicy<Object>)sizeAndTimeBasedFNATP);
        this.slashCount_$eq(1);
        int maxHistory = 5;
        int simulatedNumberOfPeriods = maxHistory * 4;
        Tuple2<Object, Object> tuple2 = this.logOverMultiplePeriods(this.now(), new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}/clean.%i").toString(), this.MILLIS_IN_DAY(), maxHistory, 3, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)tuple2._1()), BoxesRunTime.unboxToLong((Object)tuple2._2()));
            long startTime = sp2._1$mcJ$sp();
            long endTime = sp2._2$mcJ$sp();
            this.logOverMultiplePeriods(endTime + this.MILLIS_IN_DAY() * 7L, new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"/%d{").append((Object)"yyyy-MM-dd").append((Object)"}/clean.%i").toString(), this.MILLIS_IN_DAY(), maxHistory, simulatedNumberOfPeriods, this.logOverMultiplePeriods$default$6(), this.logOverMultiplePeriods$default$7());
            this.checkDirPatternCompliance(maxHistory + 1);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void logOncePeriod(long currentTime, String fileNamePattern, int maxHistory) {
        Tuple2<RollingFileAppender<Object>, TimeBasedRollingPolicy<Object>> tuple2 = this.buildRollingFileAppender(currentTime, fileNamePattern, maxHistory, true);
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            RollingFileAppender rfa = (RollingFileAppender)tuple22._1();
            TimeBasedRollingPolicy tbrp = (TimeBasedRollingPolicy)tuple22._2();
            rfa.doAppend((Object)new StringBuilder().append((Object)"Hello ----------------------------------------------------------").append((Object)new Date(currentTime)).toString());
            rfa.stop();
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void cleanHistoryOnStart() {
        LongRef now$1 = new LongRef(this.now());
        String fileNamePattern$1 = new StringBuilder().append((Object)this.randomOutputDir()).append((Object)"clean-%d{").append((Object)"yyyy-MM-dd").append((Object)"}.txt").toString();
        int maxHistory$2 = 3;
        Predef$.MODULE$.intWrapper(0).to(5).foreach$mVc$sp((Function1)new Serializable(this, now$1, fileNamePattern$1, maxHistory$2){
            public static final long serialVersionUID;
            private final TimeBasedRollingWithArchiveRemoval_STest $outer;
            private final LongRef now$1;
            private final String fileNamePattern$1;
            private final int maxHistory$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                this.$outer.logOncePeriod(this.now$1.elem, this.fileNamePattern$1, this.maxHistory$2);
                this.now$1.elem += this.$outer.MILLIS_IN_DAY();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$1 = longRef;
                this.fileNamePattern$1 = string;
                this.maxHistory$2 = n;
            }
        });
        StatusPrinter.print((Context)this.context());
        this.check(this.expectedCountWithoutFolders(maxHistory$2));
    }

    public boolean extraFolder(int numPeriods, int periodsPerEra, int beginPeriod, int maxHistory) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"numPeriods=").append((Object)BoxesRunTime.boxToInteger((int)numPeriods)).append((Object)", beginPeriod=").append((Object)BoxesRunTime.boxToInteger((int)beginPeriod)).append((Object)", maxHistory=").append((Object)BoxesRunTime.boxToInteger((int)maxHistory)).toString());
        int valueOfLastMonth = (beginPeriod + numPeriods) % periodsPerEra;
        return valueOfLastMonth < maxHistory;
    }

    public long addTime(long currentTime, long timeToWait) {
        return currentTime + timeToWait;
    }

    public void waitForCompression(TimeBasedRollingPolicy<Object> tbrp) {
        if (tbrp.future != null && !tbrp.future.isDone()) {
            tbrp.future.get(1000L, TimeUnit.MILLISECONDS);
        }
    }

    public Tuple2<RollingFileAppender<Object>, TimeBasedRollingPolicy<Object>> buildRollingFileAppender(long currentTime, String fileNamePattern, int maxHistory, boolean cleanHistoryOnStart2) {
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context());
        rfa.setEncoder(this.encoder());
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context());
        tbrp.setFileNamePattern(fileNamePattern);
        tbrp.setMaxHistory(maxHistory);
        tbrp.setParent((FileAppender)rfa);
        tbrp.setCleanHistoryOnStart(cleanHistoryOnStart2);
        tbrp.timeBasedFileNamingAndTriggeringPolicy = this.tbfnatp();
        tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(currentTime);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        return new Tuple2((Object)rfa, (Object)tbrp);
    }

    public boolean buildRollingFileAppender$default$4() {
        return false;
    }

    public Tuple2<Object, Object> logOverMultiplePeriods(long currentTime, String fileNamePattern, long periodDurationInMillis, int maxHistory, int simulatedNumberOfPeriods, int startInactivity, int numInactivityPeriods) {
        long startTime = currentTime;
        Tuple2<RollingFileAppender<Object>, TimeBasedRollingPolicy<Object>> tuple2 = this.buildRollingFileAppender(currentTime, fileNamePattern, maxHistory, this.buildRollingFileAppender$default$4());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            RollingFileAppender rfa$1 = (RollingFileAppender)tuple22._1();
            TimeBasedRollingPolicy tbrp$1 = (TimeBasedRollingPolicy)tuple22._2();
            int ticksPerPeriod$1 = 512;
            int runLength = simulatedNumberOfPeriods * ticksPerPeriod$1;
            int startInactivityIndex$1 = 1 + startInactivity * ticksPerPeriod$1;
            int endInactivityIndex$1 = startInactivityIndex$1 + numInactivityPeriods * ticksPerPeriod$1;
            long tickDuration$1 = periodDurationInMillis / (long)ticksPerPeriod$1;
            Predef$.MODULE$.intWrapper(0).to(runLength).foreach$mVc$sp((Function1)new Serializable(this, rfa$1, tbrp$1, ticksPerPeriod$1, startInactivityIndex$1, endInactivityIndex$1, tickDuration$1){
                public static final long serialVersionUID;
                private final TimeBasedRollingWithArchiveRemoval_STest $outer;
                private final RollingFileAppender rfa$1;
                private final TimeBasedRollingPolicy tbrp$1;
                private final int ticksPerPeriod$1;
                private final int startInactivityIndex$1;
                private final int endInactivityIndex$1;
                private final long tickDuration$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int v1) {
                    if (v1 < this.startInactivityIndex$1 || v1 > this.endInactivityIndex$1) {
                        this.rfa$1.doAppend((Object)new StringBuilder().append((Object)"Hello ----------------------------------------------------------").append((Object)BoxesRunTime.boxToInteger((int)v1)).toString());
                    }
                    this.tbrp$1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.$outer.addTime(this.tbrp$1.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime(), this.tickDuration$1));
                    if (v1 % (this.ticksPerPeriod$1 / 2) == 0) {
                        this.$outer.waitForCompression((TimeBasedRollingPolicy<Object>)this.tbrp$1);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.rfa$1 = rollingFileAppender;
                    this.tbrp$1 = timeBasedRollingPolicy;
                    this.ticksPerPeriod$1 = n;
                    this.startInactivityIndex$1 = n2;
                    this.endInactivityIndex$1 = n3;
                    this.tickDuration$1 = l;
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Last date").append((Object)new Date(tbrp$1.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime())).toString());
            this.waitForCompression((TimeBasedRollingPolicy<Object>)tbrp$1);
            rfa$1.stop();
            return new Tuple2.mcJJ.sp(startTime, tbrp$1.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime());
        }
        throw new MatchError(tuple2);
    }

    public int logOverMultiplePeriods$default$7() {
        return 0;
    }

    public int logOverMultiplePeriods$default$6() {
        return 0;
    }

    public int expectedCountWithoutFolders(int maxHistory) {
        return maxHistory + 1;
    }

    public int expectedCountWithoutFoldersWithInactivity(int maxHistory, int totalPeriods, int endOfInactivity) {
        int availableHistory = totalPeriods + 1 - endOfInactivity;
        int actualHistory = package$.MODULE$.min(availableHistory, maxHistory + 1);
        return actualHistory;
    }

    public void genericFindMatching(Function2<File, String, Object> matchFunc$1, File dir, ListBuffer<File> fileList$1, String pattern$1, boolean includeDirs$1) {
        if (dir.isDirectory()) {
            File[] match = dir.listFiles(new FileFilter(this, matchFunc$1, pattern$1){
                private final Function2 matchFunc$1;
                private final String pattern$1;

                public boolean accept(File f) {
                    return f.isDirectory() || BoxesRunTime.unboxToBoolean((Object)this.matchFunc$1.apply((Object)f, (Object)this.pattern$1));
                }
                {
                    this.matchFunc$1 = function2;
                    this.pattern$1 = string;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])match).foreach((Function1)new Serializable(this, matchFunc$1, fileList$1, pattern$1, includeDirs$1){
                public static final long serialVersionUID;
                private final TimeBasedRollingWithArchiveRemoval_STest $outer;
                private final Function2 matchFunc$1;
                private final ListBuffer fileList$1;
                private final String pattern$1;
                private final boolean includeDirs$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(File f) {
                    ListBuffer listBuffer;
                    if (f.isDirectory()) {
                        Object object = this.includeDirs$1 ? this.fileList$1.$plus$eq((Object)f) : BoxedUnit.UNIT;
                        this.$outer.genericFindMatching((Function2<File, String, Object>)this.matchFunc$1, f, (ListBuffer<File>)this.fileList$1, this.pattern$1, this.includeDirs$1);
                        listBuffer = BoxedUnit.UNIT;
                    } else {
                        listBuffer = this.fileList$1.$plus$eq((Object)f);
                    }
                    return listBuffer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.matchFunc$1 = function2;
                    this.fileList$1 = listBuffer;
                    this.pattern$1 = string;
                    this.includeDirs$1 = bl;
                }
            });
        }
    }

    public boolean genericFindMatching$default$5() {
        return false;
    }

    public String genericFindMatching$default$4() {
        return null;
    }

    public void findAllFoldersInFolderRecursively(File dir, ListBuffer<File> fileList) {
        this.genericFindMatching((Function2<File, String, Object>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File f, String p) {
                return false;
            }
        }, dir, fileList, null, true);
    }

    public void findAllDirsOrStringContainsFilesRecursively(File dir, ListBuffer<File> fileList, String pattern) {
        this.genericFindMatching((Function2<File, String, Object>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File f, String pattern) {
                return f.getName().contains(pattern);
            }
        }, dir, fileList, pattern, true);
    }

    public void findFilesInFolderRecursivelyByPatterMatch(File dir, ListBuffer<File> fileList, String pattern$2) {
        this.genericFindMatching((Function2<File, String, Object>)new Serializable(this, pattern$2){
            public static final long serialVersionUID;
            private final String pattern$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File f, String p) {
                return f.getName().matches(this.pattern$2);
            }
            {
                this.pattern$2 = string;
            }
        }, dir, fileList, pattern$2, this.genericFindMatching$default$5());
    }

    public void expectedFileAndDirCount(int expectedFileAndDirCount, int expectedDirCountMin, int expectedDirCountMax) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, (ListBuffer<File>)fileList, "clean");
        ListBuffer dirList = new ListBuffer();
        this.findAllFoldersInFolderRecursively(dir, (ListBuffer<File>)dirList);
        String msg = new StringBuilder().append((Object)"expectedDirCountMin=").append((Object)BoxesRunTime.boxToInteger((int)expectedDirCountMin)).append((Object)", expectedDirCountMax=").append((Object)BoxesRunTime.boxToInteger((int)expectedDirCountMax)).append((Object)" actual value=").append((Object)BoxesRunTime.boxToInteger((int)dirList.size())).toString();
        Assert.assertTrue((String)msg, (expectedDirCountMin <= dirList.size() && dirList.size() <= expectedDirCountMax ? 1 : 0) != 0);
    }

    public void check(int expectedCount) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findAllDirsOrStringContainsFilesRecursively(dir, (ListBuffer<File>)fileList, "clean");
        Assert.assertEquals((long)expectedCount, (long)fileList.size());
    }

    public Set<String> groupByClass(ListBuffer<File> fileList, String regex) {
        Pattern p$1 = Pattern.compile(regex);
        HashSet set$1 = new HashSet();
        fileList.foreach((Function1)new Serializable(this, p$1, set$1){
            public static final long serialVersionUID;
            private final Pattern p$1;
            private final HashSet set$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File f) {
                String n = f.getName();
                Matcher m = this.p$1.matcher(n);
                m.matches();
                int begin = m.start(1);
                String reduced = n.substring(0, begin);
                return this.set$1.add((Object)reduced);
            }
            {
                this.p$1 = pattern;
                this.set$1 = hashSet;
            }
        });
        return set$1;
    }

    public void checkPatternCompliance(int expectedClassCount, String regex) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, (ListBuffer<File>)fileList, regex);
        Set<String> set = this.groupByClass((ListBuffer<File>)fileList, regex);
        Assert.assertEquals((long)expectedClassCount, (long)set.size());
    }

    public void checkDirPatternCompliance(int expectedClassCount) {
        File dir = new File(this.randomOutputDir());
        ListBuffer fileList = new ListBuffer();
        this.findAllFoldersInFolderRecursively(dir, (ListBuffer<File>)fileList);
        fileList.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File f) {
                Assert.assertTrue((f.list().length >= 1 ? 1 : 0) != 0);
            }
        });
        Assert.assertEquals((long)expectedClassCount, (long)fileList.size());
    }

    private final int expectedCountWithFolders$1(int n, boolean bl) {
        int numLogFiles = n + 1;
        int numLogFilesAndFolders = numLogFiles * 2;
        int result = numLogFilesAndFolders + this.slashCount();
        if (bl) {
            ++result;
        }
        return result;
    }

    public TimeBasedRollingWithArchiveRemoval_STest() {
        this.MONTHLY_DATE_PATTERN = "yyyy-MM";
        this.MONTHLY_CRONOLOG_DATE_PATTERN = "yyyy/MM";
        this.DAILY_CRONOLOG_DATE_PATTERN = "yyyy/MM/dd";
        this.MILLIS_IN_MINUTE = 60000L;
        this.MONTHS_IN_YEAR = 12;
    }
}

