/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Parser;
import ch.qos.logback.core.subst.Tokenizer;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    @Test
    public void literal() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("abc");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node witness = new Node(Node.Type.LITERAL, (Object)"abc");
        Assert.assertEquals((Object)witness, (Object)node);
    }

    @Test
    public void literalWithAccolade0() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("{}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node witness = new Node(Node.Type.LITERAL, (Object)"{");
        witness.next = new Node(Node.Type.LITERAL, (Object)"}");
        Assert.assertEquals((Object)witness, (Object)node);
    }

    @Test
    public void literalWithAccolade1() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("%x{a}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node witness = new Node(Node.Type.LITERAL, (Object)"%x");
        Node t = witness.next = new Node(Node.Type.LITERAL, (Object)"{");
        t = t.next = new Node(Node.Type.LITERAL, (Object)"a");
        t.next = new Node(Node.Type.LITERAL, (Object)"}");
        Assert.assertEquals((Object)witness, (Object)node);
    }

    @Test
    public void literalWithTwoAccolades() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("%x{y} %a{b} c");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node witness = new Node(Node.Type.LITERAL, (Object)"%x");
        Node t = witness.next = new Node(Node.Type.LITERAL, (Object)"{");
        t = t.next = new Node(Node.Type.LITERAL, (Object)"y");
        t = t.next = new Node(Node.Type.LITERAL, (Object)"}");
        t = t.next = new Node(Node.Type.LITERAL, (Object)" %a");
        t = t.next = new Node(Node.Type.LITERAL, (Object)"{");
        t = t.next = new Node(Node.Type.LITERAL, (Object)"b");
        t = t.next = new Node(Node.Type.LITERAL, (Object)"}");
        t.next = new Node(Node.Type.LITERAL, (Object)" c");
        node.dump();
        System.out.println("");
        Assert.assertEquals((Object)witness, (Object)node);
    }

    @Test
    public void variable() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("${abc}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node witness = new Node(Node.Type.VARIABLE, (Object)new Node(Node.Type.LITERAL, (Object)"abc"));
        Assert.assertEquals((Object)witness, (Object)node);
    }

    @Test
    public void literalVariableLiteral() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("a${b}c");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node witness = new Node(Node.Type.LITERAL, (Object)"a");
        witness.next = new Node(Node.Type.VARIABLE, (Object)new Node(Node.Type.LITERAL, (Object)"b"));
        witness.next.next = new Node(Node.Type.LITERAL, (Object)"c");
        Assert.assertEquals((Object)witness, (Object)node);
    }

    @Test
    public void nested() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("a${b${c}}d");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node witness = new Node(Node.Type.LITERAL, (Object)"a");
        Node nestedWitness = new Node(Node.Type.VARIABLE, (Object)new Node(Node.Type.LITERAL, (Object)"b"));
        nestedWitness.next = new Node(Node.Type.VARIABLE, (Object)new Node(Node.Type.LITERAL, (Object)"c"));
        witness.next = nestedWitness;
        witness.next.next = new Node(Node.Type.LITERAL, (Object)"c");
    }

    @Test
    public void withDefault() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("${b:-c}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node witness = new Node(Node.Type.VARIABLE, (Object)new Node(Node.Type.LITERAL, (Object)"b"));
        witness.defaultPart = new Node(Node.Type.LITERAL, (Object)"c");
    }

    private void dump(Node node) {
        while (node != null) {
            System.out.println(node.toString());
            node = node.next;
        }
    }
}

