/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.testUtil;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class Env {
    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") != -1;
    }

    public static boolean isJDK6OrHigher() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            return false;
        }
        return javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7");
    }

    public static String getLocalHostName() {
        try {
            InetAddress localhostIA = InetAddress.getLocalHost();
            return localhostIA.getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static boolean isLocalHostNameInList(String[] hostList) {
        String localHostName = Env.getLocalHostName();
        if (localHostName == null) {
            return false;
        }
        for (String host : hostList) {
            if (!host.equalsIgnoreCase(localHostName)) continue;
            return true;
        }
        return false;
    }

    public static String getPathToBash() {
        if (Env.isLinux()) {
            return "bash";
        }
        if (Env.isLocalHostNameInList(new String[]{"hetz"})) {
            return "c:/cygwin/bin/bash";
        }
        return null;
    }
}

