/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.NodeToStringTransformer;
import ch.qos.logback.core.subst.Parser;
import ch.qos.logback.core.subst.Tokenizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NodeToStringTransformerTest {
    ContextBase propertyContainer0 = new ContextBase();

    @Before
    public void setUp() {
        this.propertyContainer0.putProperty("k0", "v0");
        this.propertyContainer0.putProperty("zero", "0");
        this.propertyContainer0.putProperty("v0.jdbc.url", "http://..");
        this.propertyContainer0.putProperty("host", "local");
    }

    private Node makeNode(String input) throws ScanException {
        Tokenizer tokenizer = new Tokenizer(input);
        Parser parser = new Parser(tokenizer.tokenize());
        return parser.parse();
    }

    @Test
    public void literal() throws ScanException {
        String input = "abv";
        Node node = this.makeNode(input);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, (PropertyContainer)this.propertyContainer0);
        Assert.assertEquals((Object)input, (Object)nodeToStringTransformer.transform());
    }

    void checkInputEqualsOutput(String input) throws ScanException {
        Node node = this.makeNode(input);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, (PropertyContainer)this.propertyContainer0);
        Assert.assertEquals((Object)input, (Object)nodeToStringTransformer.transform());
    }

    @Test
    public void literalWithNestedAccolades() throws ScanException {
        this.checkInputEqualsOutput("%logger{35}");
        this.checkInputEqualsOutput("%a{35} %b{35} c");
        this.checkInputEqualsOutput("%replace(%msg){'\\d{14,16}', 'XXXX'}");
        this.checkInputEqualsOutput("TEST %d{HHmmssSSS} [%thread] %-5level %logger{36} - %msg%n");
    }

    @Test
    public void variable() throws ScanException {
        String input = "${k0}";
        Node node = this.makeNode(input);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, (PropertyContainer)this.propertyContainer0);
        Assert.assertEquals((Object)"v0", (Object)nodeToStringTransformer.transform());
    }

    @Test
    public void literalVariableLiteral() throws ScanException {
        String input = "a${k0}c";
        Node node = this.makeNode(input);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, (PropertyContainer)this.propertyContainer0);
        Assert.assertEquals((Object)"av0c", (Object)nodeToStringTransformer.transform());
    }

    @Test
    public void nestedVariable() throws ScanException {
        String input = "a${k${zero}}b";
        Node node = this.makeNode(input);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, (PropertyContainer)this.propertyContainer0);
        Assert.assertEquals((Object)"av0b", (Object)nodeToStringTransformer.transform());
    }

    @Test
    public void LOGBACK729() throws ScanException {
        String input = "${${k0}.jdbc.url}";
        Node node = this.makeNode(input);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, (PropertyContainer)this.propertyContainer0);
        Assert.assertEquals((Object)"http://..", (Object)nodeToStringTransformer.transform());
    }

    @Test
    public void LOGBACK744_withColon() throws ScanException {
        String input = "%d{HH:mm:ss.SSS} host:${host} %logger{36} - %msg%n";
        Node node = this.makeNode(input);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, (PropertyContainer)this.propertyContainer0);
        System.out.println(nodeToStringTransformer.transform());
        Assert.assertEquals((Object)"%d{HH:mm:ss.SSS} host:local %logger{36} - %msg%n", (Object)nodeToStringTransformer.transform());
    }

    @Test
    public void withDefaultValue() throws ScanException {
        String input = "${k67:-b}c";
        Node node = this.makeNode(input);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, (PropertyContainer)this.propertyContainer0);
        Assert.assertEquals((Object)"bc", (Object)nodeToStringTransformer.transform());
    }

    @Test
    public void defaultValueNestedAsVar() throws ScanException {
        String input = "a${k67:-x${k0}}c";
        Node node = this.makeNode(input);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, (PropertyContainer)this.propertyContainer0);
        Assert.assertEquals((Object)"axv0c", (Object)nodeToStringTransformer.transform());
    }
}

