/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.testUtil.Env;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.ResilienceUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FileAppenderResilience_AS_ROOT_Test {
    static String MOUNT_POINT = "/mnt/loop/";
    static String LONG_STR = " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
    static String PATH_LOOPFS_SCRIPT = "/home/ceki/java/logback/logback-core/src/test/loopfs.sh";
    Context context = new ContextBase();
    int diff = RandomUtil.getPositiveInt();
    String outputDirStr = MOUNT_POINT + "resilience-" + this.diff + "/";
    String logfileStr = this.outputDirStr + "output.log";
    FileAppender<Object> fa = new FileAppender();
    static int TOTAL_DURATION = 5000;
    static int NUM_STEPS = 500;
    static int DELAY = TOTAL_DURATION / NUM_STEPS;

    static boolean isConformingHost() {
        return Env.isLocalHostNameInList(new String[]{"haro"});
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        if (!FileAppenderResilience_AS_ROOT_Test.isConformingHost()) {
            return;
        }
        Process p = this.runLoopFSScript(LoopFSCommand.setup);
        p.waitFor();
        this.dump("/tmp/loopfs.log");
        this.fa.setContext(this.context);
        File outputDir = new File(this.outputDirStr);
        outputDir.mkdirs();
        System.out.println("FileAppenderResilienceTest output dir [" + this.outputDirStr + "]");
        this.fa.setName("FILE");
        this.fa.setEncoder((Encoder)new EchoEncoder());
        this.fa.setFile(this.logfileStr);
        this.fa.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(String file) throws IOException {
        FileInputStream fis = null;
        try {
            int r;
            fis = new FileInputStream(file);
            while ((r = fis.read()) != -1) {
                char c = (char)r;
                System.out.print(c);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    @After
    public void tearDown() throws IOException, InterruptedException {
        if (!FileAppenderResilience_AS_ROOT_Test.isConformingHost()) {
            return;
        }
        StatusPrinter.print((Context)this.context);
        this.fa.stop();
        Process p = this.runLoopFSScript(LoopFSCommand.teardown);
        p.waitFor();
        System.out.println("Tearing down");
    }

    @Test
    public void go() throws IOException, InterruptedException {
        if (!FileAppenderResilience_AS_ROOT_Test.isConformingHost()) {
            return;
        }
        Process p = this.runLoopFSScript(LoopFSCommand.shake);
        for (int i = 0; i < NUM_STEPS; ++i) {
            this.fa.append((Object)(String.valueOf(i) + LONG_STR));
            Thread.sleep(DELAY);
        }
        p.waitFor();
        double bestCase = 0.5;
        ResilienceUtil.verify(this.logfileStr, "^(\\d{1,3}) x*$", NUM_STEPS, bestCase * 0.6);
        System.out.println("Done go");
    }

    Process runLoopFSScript(LoopFSCommand cmd) throws IOException, InterruptedException {
        if (!FileAppenderResilience_AS_ROOT_Test.isConformingHost()) {
            return null;
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command("/usr/bin/sudo", PATH_LOOPFS_SCRIPT, cmd.toString());
        return pb.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LoopFSCommand {
        setup,
        shake,
        teardown;

    }
}

