/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.issue;

import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SelectiveLockRunnable
extends RunnableWithCounterAndDone {
    static Object LOCK = new Object();
    static Lock FAIR_LOCK = new ReentrantLock(true);
    static Lock UNFAIR_LOCK = new ReentrantLock(false);
    LockingModel model;

    SelectiveLockRunnable(LockingModel model) {
        this.model = model;
    }

    public void run() {
        switch (this.model) {
            case NOLOCK: {
                this.nolockRun();
                break;
            }
            case SYNC: {
                this.synchronizedRun();
                break;
            }
            case FAIR: {
                this.fairLockRun();
                break;
            }
            case UNFAIR: {
                this.unfairLockRun();
            }
        }
    }

    void fairLockRun() {
        do {
            FAIR_LOCK.lock();
            ++this.counter;
            FAIR_LOCK.unlock();
        } while (!this.done);
    }

    void unfairLockRun() {
        do {
            UNFAIR_LOCK.lock();
            ++this.counter;
            UNFAIR_LOCK.unlock();
        } while (!this.done);
    }

    void nolockRun() {
        do {
            ++this.counter;
        } while (!this.done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizedRun() {
        do {
            Object object = LOCK;
            synchronized (object) {
                ++this.counter;
            }
        } while (!this.done);
    }

    public String toString() {
        return "SelectiveLockRunnable " + (Object)((Object)this.model);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LockingModel {
        NOLOCK,
        SYNC,
        FAIR,
        UNFAIR;

    }
}

