/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusChecker;
import org.junit.Assert;
import org.junit.Test;

public class StatusCheckerTest {
    Context context = new ContextBase();
    StatusChecker checker = new StatusChecker(this.context);

    @Test
    public void emptyStatusListShouldResultInNotFound() {
        junit.framework.Assert.assertEquals((long)-1L, (long)this.checker.timeOfLastReset());
    }

    @Test
    public void withoutResetsCheckerShouldReturnNotFound() {
        this.context.getStatusManager().add((Status)new InfoStatus("test", (Object)this));
        junit.framework.Assert.assertEquals((long)-1L, (long)this.checker.timeOfLastReset());
    }

    @Test
    public void statusListShouldReturnLastResetTime() {
        this.context.getStatusManager().add((Status)new InfoStatus("test", (Object)this));
        long resetTime = System.currentTimeMillis();
        this.context.getStatusManager().add((Status)new InfoStatus("Will reset and reconfigure context ", (Object)this));
        this.context.getStatusManager().add((Status)new InfoStatus("bla", (Object)this));
        Assert.assertTrue((resetTime <= this.checker.timeOfLastReset() ? 1 : 0) != 0);
    }
}

