/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.AbstractSocketAppender;
import ch.qos.logback.core.net.mock.MockContext;
import ch.qos.logback.core.net.server.ServerSocketUtil;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class AbstractSocketAppenderTest {
    private static final int DELAY = 10000;
    private ThreadPoolExecutor executorService = (ThreadPoolExecutor)Executors.newCachedThreadPool();
    private MockContext mockContext = new MockContext(this.executorService);
    private InstrumentedSocketAppender instrumentedAppender = new InstrumentedSocketAppender();

    @Before
    public void setUp() throws Exception {
        this.instrumentedAppender.setContext((Context)this.mockContext);
    }

    @After
    public void tearDown() throws Exception {
        this.instrumentedAppender.stop();
        Assert.assertFalse((boolean)this.instrumentedAppender.isStarted());
        this.executorService.shutdownNow();
        Assert.assertTrue((boolean)this.executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void appenderShouldFailToStartWithoutValidPort() throws Exception {
        this.instrumentedAppender.setPort(-1);
        this.instrumentedAppender.setRemoteHost("localhost");
        this.instrumentedAppender.setQueueSize(0);
        this.instrumentedAppender.start();
        Assert.assertFalse((boolean)this.instrumentedAppender.isStarted());
        Assert.assertTrue((boolean)this.mockContext.getLastStatus().getMessage().contains("port"));
    }

    @Test
    public void appenderShouldFailToStartWithoutValidRemoteHost() throws Exception {
        this.instrumentedAppender.setPort(1);
        this.instrumentedAppender.setRemoteHost(null);
        this.instrumentedAppender.setQueueSize(0);
        this.instrumentedAppender.start();
        Assert.assertFalse((boolean)this.instrumentedAppender.isStarted());
        Assert.assertTrue((boolean)this.mockContext.getLastStatus().getMessage().contains("remote host"));
    }

    @Test
    public void appenderShouldFailToStartWithNegativeQueueSize() throws Exception {
        this.instrumentedAppender.setPort(1);
        this.instrumentedAppender.setRemoteHost("localhost");
        this.instrumentedAppender.setQueueSize(-1);
        this.instrumentedAppender.start();
        Assert.assertFalse((boolean)this.instrumentedAppender.isStarted());
        Assert.assertTrue((boolean)this.mockContext.getLastStatus().getMessage().contains("Queue"));
    }

    @Test
    public void appenderShouldFailToStartWithUnresolvableRemoteHost() throws Exception {
        this.instrumentedAppender.setPort(1);
        this.instrumentedAppender.setRemoteHost("NOT.A.VALID.REMOTE.HOST.NAME");
        this.instrumentedAppender.setQueueSize(0);
        this.instrumentedAppender.start();
        Assert.assertFalse((boolean)this.instrumentedAppender.isStarted());
        Assert.assertTrue((boolean)this.mockContext.getLastStatus().getMessage().contains("unknown host"));
    }

    @Test
    public void appenderShouldFailToStartWithZeroQueueLength() throws Exception {
        this.instrumentedAppender.setPort(1);
        this.instrumentedAppender.setRemoteHost("localhost");
        this.instrumentedAppender.setQueueSize(0);
        this.instrumentedAppender.start();
        Assert.assertTrue((boolean)this.instrumentedAppender.isStarted());
        Assert.assertTrue((boolean)(this.instrumentedAppender.lastQueue instanceof SynchronousQueue));
    }

    @Test
    public void appenderShouldStartWithValidParameters() throws Exception {
        this.instrumentedAppender.setPort(1);
        this.instrumentedAppender.setRemoteHost("localhost");
        this.instrumentedAppender.setQueueSize(1);
        this.instrumentedAppender.start();
        Assert.assertTrue((boolean)this.instrumentedAppender.isStarted());
        Assert.assertTrue((boolean)(this.instrumentedAppender.lastQueue instanceof ArrayBlockingQueue));
        Assert.assertEquals((long)1L, (long)this.instrumentedAppender.lastQueue.remainingCapacity());
    }

    @Ignore
    @Test(timeout=2000L)
    public void appenderShouldCleanupTasksWhenStopped() throws Exception {
        this.mockContext.setStatusManager((StatusManager)new BasicStatusManager());
        this.instrumentedAppender.setPort(1);
        this.instrumentedAppender.setRemoteHost("localhost");
        this.instrumentedAppender.setQueueSize(1);
        this.instrumentedAppender.start();
        Assert.assertTrue((boolean)this.instrumentedAppender.isStarted());
        this.waitForActiveCountToEqual(this.executorService, 2);
        this.instrumentedAppender.stop();
        this.waitForActiveCountToEqual(this.executorService, 0);
        StatusPrinter.print((Context)this.mockContext);
        Assert.assertEquals((long)0L, (long)this.executorService.getActiveCount());
    }

    private void waitForActiveCountToEqual(ThreadPoolExecutor executorService, int i) {
        while (executorService.getActiveCount() != i) {
            try {
                Thread.yield();
                Thread.sleep(1L);
                System.out.print(".");
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Test
    public void testAppendWhenNotStarted() throws Exception {
        this.instrumentedAppender.setRemoteHost("localhost");
        this.instrumentedAppender.start();
        this.instrumentedAppender.stop();
        this.executorService.shutdownNow();
        Assert.assertTrue((boolean)this.executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS));
        this.instrumentedAppender.append("some event");
        Assert.assertTrue((boolean)this.instrumentedAppender.lastQueue.isEmpty());
    }

    @Test(timeout=1000L)
    public void testAppendSingleEvent() throws Exception {
        this.instrumentedAppender.setRemoteHost("localhost");
        this.instrumentedAppender.start();
        this.instrumentedAppender.latch.await();
        this.instrumentedAppender.append("some event");
        Assert.assertTrue((this.instrumentedAppender.lastQueue.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAppendEvent() throws Exception {
        this.instrumentedAppender.setRemoteHost("localhost");
        this.instrumentedAppender.setQueueSize(1);
        this.instrumentedAppender.start();
        this.executorService.shutdownNow();
        Assert.assertTrue((boolean)this.executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS));
        this.instrumentedAppender.append("some event");
        Assert.assertEquals((Object)"some event", this.instrumentedAppender.lastQueue.poll());
    }

    @Test
    public void testDispatchEvent() throws Exception {
        ServerSocket serverSocket = ServerSocketUtil.createServerSocket();
        this.instrumentedAppender.setRemoteHost(serverSocket.getInetAddress().getHostAddress());
        this.instrumentedAppender.setPort(serverSocket.getLocalPort());
        this.instrumentedAppender.setQueueSize(1);
        this.instrumentedAppender.start();
        Socket appenderSocket = serverSocket.accept();
        serverSocket.close();
        this.instrumentedAppender.append("some event");
        int shortDelay = 100;
        int retries = 100;
        for (int i = 0; !this.instrumentedAppender.lastQueue.isEmpty() && i < retries; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)this.instrumentedAppender.lastQueue.isEmpty());
        ObjectInputStream ois = new ObjectInputStream(appenderSocket.getInputStream());
        Assert.assertEquals((Object)"some event", (Object)ois.readObject());
        appenderSocket.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstrumentedSocketAppender
    extends AbstractSocketAppender<String> {
        private BlockingQueue<String> lastQueue;
        CountDownLatch latch = new CountDownLatch(1);

        private InstrumentedSocketAppender() {
        }

        protected void postProcessEvent(String event) {
        }

        protected PreSerializationTransformer<String> getPST() {
            return new PreSerializationTransformer<String>(){

                public Serializable transform(String event) {
                    return event;
                }
            };
        }

        protected void signalEntryInRunMethod() {
            this.latch.countDown();
        }

        BlockingQueue<String> newBlockingQueue(int queueSize) {
            this.lastQueue = super.newBlockingQueue(queueSize);
            return this.lastQueue;
        }
    }
}

