/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.Client;
import ch.qos.logback.core.net.server.ServerListener;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class MockServerListener<T extends Client>
implements ServerListener<T> {
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    private boolean closed;
    private Thread waiter;

    public synchronized Thread getWaiter() {
        return this.waiter;
    }

    public synchronized void setWaiter(Thread waiter) {
        this.waiter = waiter;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void setClosed(boolean closed) {
        this.closed = closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T acceptClient() throws IOException, InterruptedException {
        if (this.isClosed()) {
            throw new IOException("closed");
        }
        this.setWaiter(Thread.currentThread());
        try {
            Client client = (Client)this.queue.take();
            return (T)client;
        }
        finally {
            this.setWaiter(null);
        }
    }

    public void addClient(T client) {
        this.queue.offer(client);
    }

    public synchronized void close() {
        this.setClosed(true);
        Thread waiter = this.getWaiter();
        if (waiter != null) {
            waiter.interrupt();
        }
    }
}

