/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.mock.MockContext;
import ch.qos.logback.core.net.server.InstrumentedServerSocketAppenderBase;
import ch.qos.logback.core.net.server.ServerSocketUtil;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerSocketAppenderBaseFunctionalTest {
    private static final String TEST_EVENT = "test event";
    private static final int EVENT_COUNT = 10;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private MockContext context = new MockContext(this.executor);
    private ServerSocket serverSocket;
    private InstrumentedServerSocketAppenderBase appender;

    @Before
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        this.appender = new InstrumentedServerSocketAppenderBase(this.serverSocket);
        this.appender.setContext((Context)this.context);
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
        this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.executor.isTerminated());
    }

    @Test
    public void testLogEventClient() throws Exception {
        this.appender.start();
        Socket socket = new Socket(InetAddress.getLocalHost(), this.serverSocket.getLocalPort());
        socket.setSoTimeout(1000);
        ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
        for (int i = 0; i < 10; ++i) {
            this.appender.append(TEST_EVENT + i);
            Assert.assertEquals((Object)(TEST_EVENT + i), (Object)ois.readObject());
        }
        socket.close();
        this.appender.stop();
    }
}

