/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.recovery.RecoveryCoordinator;
import org.junit.Assert;
import org.junit.Test;

public class RecoveryCoordinatorTest {
    @Test
    public void recoveryNotNeededAfterInit() {
        RecoveryCoordinator rc = new RecoveryCoordinator();
        Assert.assertTrue((boolean)rc.isTooSoon());
    }

    @Test
    public void recoveryNotNeededIfAsleepForLessThanBackOffTime() throws InterruptedException {
        RecoveryCoordinator rc = new RecoveryCoordinator();
        Thread.sleep(10L);
        Assert.assertTrue((boolean)rc.isTooSoon());
    }

    @Test
    public void recoveryNeededIfAsleepForMoreThanBackOffTime() throws InterruptedException {
        RecoveryCoordinator rc = new RecoveryCoordinator();
        Thread.sleep(40L);
        Assert.assertFalse((boolean)rc.isTooSoon());
    }

    @Test
    public void recoveryNotNeededIfCurrentTimeSetToBackOffTime() throws InterruptedException {
        RecoveryCoordinator rc = new RecoveryCoordinator();
        long now = System.currentTimeMillis();
        rc.setCurrentTime(now + 20L);
        Assert.assertTrue((boolean)rc.isTooSoon());
    }

    @Test
    public void recoveryNeededIfCurrentTimeSetToExceedBackOffTime() {
        RecoveryCoordinator rc = new RecoveryCoordinator();
        long now = System.currentTimeMillis();
        rc.setCurrentTime(now + 20L + 1L);
        Assert.assertFalse((boolean)rc.isTooSoon());
    }

    @Test
    public void recoveryConditionDetectedEvenAfterReallyLongTimesBetweenRecovery() {
        RecoveryCoordinator rc = new RecoveryCoordinator();
        long now = System.currentTimeMillis();
        long offset = 20L;
        for (int i = 0; i < 16; ++i) {
            rc.setCurrentTime(now + offset);
            if (i % 2 == 0) {
                Assert.assertTrue((String)("recovery should've been needed at " + offset), (boolean)rc.isTooSoon());
            } else {
                Assert.assertFalse((String)("recovery should NOT have been needed at " + offset), (boolean)rc.isTooSoon());
            }
            offset *= 2L;
        }
    }
}

