/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.issue.LOGBACK_849;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.util.ExecutorServiceUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.Test;

public class Basic {
    ExecutorService executor = ExecutorServiceUtil.newExecutorService();
    Context context = new ContextBase();

    @Test(timeout=100L)
    public void withNoSubmittedTasksShutdownNowShouldReturnImmediately() throws InterruptedException {
        this.executor.shutdownNow();
        this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
    }

    @Ignore
    @Test
    public void withOneSlowTask() throws InterruptedException {
        this.executor.execute(new InterruptIgnoring(1000));
        Thread.sleep(100L);
        ExecutorServiceUtil.shutdown((ExecutorService)this.executor);
    }

    static class InterruptIgnoring
    implements Runnable {
        int delay;

        InterruptIgnoring(int delay) {
            this.delay = delay;
        }

        @Override
        public void run() {
            long runUntil = System.currentTimeMillis() + (long)this.delay;
            while (true) {
                try {
                    while (true) {
                        long sleep = runUntil - System.currentTimeMillis();
                        System.out.println("will sleep " + sleep);
                        if (sleep <= 0L) break;
                        Thread.currentThread();
                        Thread.sleep(this.delay);
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

