/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.appender.XTeeOutputStream;
import ch.qos.logback.core.encoder.DummyEncoder;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.NopEncoder;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.status.StatusChecker;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsoleAppenderTest
extends AbstractAppenderTest<Object> {
    XTeeOutputStream tee;
    PrintStream original;

    @Before
    public void setUp() {
        this.original = System.out;
        this.tee = new XTeeOutputStream(null);
        System.setOut(new PrintStream(this.tee));
    }

    @After
    public void tearDown() {
        System.setOut(this.original);
    }

    @Override
    public Appender<Object> getAppender() {
        return new ConsoleAppender();
    }

    @Override
    protected Appender<Object> getConfiguredAppender() {
        ConsoleAppender ca = new ConsoleAppender();
        ca.setEncoder(new NopEncoder());
        ca.start();
        return ca;
    }

    @Test
    public void testBasic() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        ca.setEncoder(new DummyEncoder());
        ca.start();
        ca.doAppend(new Object());
        Assert.assertEquals((Object)DummyLayout.DUMMY, (Object)this.tee.toString());
    }

    @Test
    public void testOpen() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        dummyEncoder.setFileHeader("open");
        ca.setEncoder(dummyEncoder);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        Assert.assertEquals((Object)("open" + CoreConstants.LINE_SEPARATOR + DummyLayout.DUMMY), (Object)this.tee.toString());
    }

    @Test
    public void testClose() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        dummyEncoder.setFileFooter("CLOSED");
        ca.setEncoder(dummyEncoder);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        Assert.assertFalse((boolean)this.tee.isClosed());
        Assert.assertEquals((Object)(DummyLayout.DUMMY + "CLOSED"), (Object)this.tee.toString());
    }

    @Test
    public void changeInConsole() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        EchoEncoder encoder = new EchoEncoder();
        ca.setEncoder((Encoder)encoder);
        ca.start();
        ca.doAppend((Object)"a");
        Assert.assertEquals((Object)("a" + CoreConstants.LINE_SEPARATOR), (Object)this.tee.toString());
        XTeeOutputStream newTee = new XTeeOutputStream(null);
        System.setOut(new PrintStream(newTee));
        ca.doAppend((Object)"b");
        Assert.assertEquals((Object)("b" + CoreConstants.LINE_SEPARATOR), (Object)newTee.toString());
    }

    @Test
    public void testUTF16BE() throws UnsupportedEncodingException {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        String encodingName = "UTF-16BE";
        dummyEncoder.setEncodingName(encodingName);
        ca.setEncoder(dummyEncoder);
        ca.start();
        ca.doAppend(new Object());
        Assert.assertEquals((Object)DummyLayout.DUMMY, (Object)new String(this.tee.toByteArray(), encodingName));
    }

    @Test
    public void wrongTarget() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        EchoEncoder encoder = new EchoEncoder();
        encoder.setContext(this.context);
        ca.setContext(this.context);
        ca.setTarget("foo");
        ca.setEncoder((Encoder)encoder);
        ca.start();
        ca.doAppend((Object)"a");
        StatusChecker checker = new StatusChecker(this.context);
        checker.assertContainsMatch(1, "\\[foo\\] should be one of \\[SystemOut, SystemErr\\]");
    }
}

