/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.net.ssl.KeyManagerFactoryFactoryBean;
import ch.qos.logback.core.net.ssl.KeyStoreFactoryBean;
import ch.qos.logback.core.net.ssl.SSLContextFactoryBean;
import ch.qos.logback.core.net.ssl.SecureRandomFactoryBean;
import ch.qos.logback.core.net.ssl.TrustManagerFactoryFactoryBean;
import ch.qos.logback.core.net.ssl.mock.MockContextAware;
import ch.qos.logback.core.net.ssl.mock.MockKeyManagerFactoryFactoryBean;
import ch.qos.logback.core.net.ssl.mock.MockKeyStoreFactoryBean;
import ch.qos.logback.core.net.ssl.mock.MockSecureRandomFactoryBean;
import ch.qos.logback.core.net.ssl.mock.MockTrustManagerFactoryFactoryBean;
import ch.qos.logback.core.spi.ContextAware;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SSLContextFactoryBeanTest {
    private static final String SSL_CONFIGURATION_MESSAGE_PATTERN = "SSL protocol '.*?' provider '.*?'";
    private static final String KEY_MANAGER_FACTORY_MESSAGE_PATTERN = "key manager algorithm '.*?' provider '.*?'";
    private static final String TRUST_MANAGER_FACTORY_MESSAGE_PATTERN = "trust manager algorithm '.*?' provider '.*?'";
    private static final String KEY_STORE_MESSAGE_PATTERN = "key store of type '.*?' provider '.*?': .*";
    private static final String TRUST_STORE_MESSAGE_PATTERN = "trust store of type '.*?' provider '.*?': .*";
    private static final String SECURE_RANDOM_MESSAGE_PATTERN = "secure random algorithm '.*?' provider '.*?'";
    private MockKeyManagerFactoryFactoryBean keyManagerFactory = new MockKeyManagerFactoryFactoryBean();
    private MockTrustManagerFactoryFactoryBean trustManagerFactory = new MockTrustManagerFactoryFactoryBean();
    private MockKeyStoreFactoryBean keyStore = new MockKeyStoreFactoryBean();
    private MockKeyStoreFactoryBean trustStore = new MockKeyStoreFactoryBean();
    private MockSecureRandomFactoryBean secureRandom = new MockSecureRandomFactoryBean();
    private MockContextAware context = new MockContextAware();
    private SSLContextFactoryBean factoryBean = new SSLContextFactoryBean();

    @Before
    public void setUp() throws Exception {
        this.keyStore.setLocation("net/ssl/keystore.jks");
        this.trustStore.setLocation("net/ssl/keystore.jks");
    }

    @Test
    public void testCreateDefaultContext() throws Exception {
        Assert.assertNotNull((Object)this.factoryBean.createContext((ContextAware)this.context));
        Assert.assertTrue((boolean)this.context.hasInfoMatching(SSL_CONFIGURATION_MESSAGE_PATTERN));
    }

    @Test
    public void testCreateContext() throws Exception {
        this.factoryBean.setKeyManagerFactory((KeyManagerFactoryFactoryBean)this.keyManagerFactory);
        this.factoryBean.setKeyStore((KeyStoreFactoryBean)this.keyStore);
        this.factoryBean.setTrustManagerFactory((TrustManagerFactoryFactoryBean)this.trustManagerFactory);
        this.factoryBean.setTrustStore((KeyStoreFactoryBean)this.trustStore);
        this.factoryBean.setSecureRandom((SecureRandomFactoryBean)this.secureRandom);
        Assert.assertNotNull((Object)this.factoryBean.createContext((ContextAware)this.context));
        Assert.assertTrue((boolean)this.keyManagerFactory.isFactoryCreated());
        Assert.assertTrue((boolean)this.trustManagerFactory.isFactoryCreated());
        Assert.assertTrue((boolean)this.keyStore.isKeyStoreCreated());
        Assert.assertTrue((boolean)this.trustStore.isKeyStoreCreated());
        Assert.assertTrue((boolean)this.secureRandom.isSecureRandomCreated());
        Assert.assertTrue((boolean)this.context.hasInfoMatching(SSL_CONFIGURATION_MESSAGE_PATTERN));
        Assert.assertTrue((boolean)this.context.hasInfoMatching(KEY_MANAGER_FACTORY_MESSAGE_PATTERN));
        Assert.assertTrue((boolean)this.context.hasInfoMatching(TRUST_MANAGER_FACTORY_MESSAGE_PATTERN));
        Assert.assertTrue((boolean)this.context.hasInfoMatching(KEY_STORE_MESSAGE_PATTERN));
        Assert.assertTrue((boolean)this.context.hasInfoMatching(TRUST_STORE_MESSAGE_PATTERN));
        Assert.assertTrue((boolean)this.context.hasInfoMatching(SECURE_RANDOM_MESSAGE_PATTERN));
    }
}

