/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeBasedFileNamingAndTriggeringPolicyBaseTest {
    static long MILLIS_IN_MINUTE = 60000L;
    static long MILLIS_IN_HOUR = 60L * MILLIS_IN_MINUTE;
    Context context = new ContextBase();
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp = new TimeBasedRollingPolicy();
    DefaultTimeBasedFileNamingAndTriggeringPolicy<Object> timeBasedFNATP = new DefaultTimeBasedFileNamingAndTriggeringPolicy();

    @Before
    public void setUp() {
        this.rfa.setContext(this.context);
        this.tbrp.setContext(this.context);
        this.timeBasedFNATP.setContext(this.context);
        this.rfa.setRollingPolicy(this.tbrp);
        this.tbrp.setParent(this.rfa);
        this.tbrp.setTimeBasedFileNamingAndTriggeringPolicy(this.timeBasedFNATP);
        this.timeBasedFNATP.setTimeBasedRollingPolicy(this.tbrp);
    }

    @Test
    public void singleDate() {
        long startTime = 1324400341553L;
        this.tbrp.setFileNamePattern("foo-%d{yyyy-MM'T'mm}.log");
        this.tbrp.start();
        this.timeBasedFNATP.setCurrentTime(startTime);
        this.timeBasedFNATP.start();
        this.timeBasedFNATP.setCurrentTime(startTime + MILLIS_IN_MINUTE);
        this.timeBasedFNATP.isTriggeringEvent(null, null);
        String elapsedPeriodsFileName = this.timeBasedFNATP.getElapsedPeriodsFileName();
        Assert.assertEquals((Object)"foo-2011-12T59.log", (Object)elapsedPeriodsFileName);
    }

    @Test
    public void multiDate() {
        long startTime = 1324400341553L;
        this.tbrp.setFileNamePattern("foo-%d{yyyy-MM, AUX}/%d{mm}.log");
        this.tbrp.start();
        this.timeBasedFNATP.setCurrentTime(startTime);
        this.timeBasedFNATP.start();
        this.timeBasedFNATP.setCurrentTime(startTime + MILLIS_IN_MINUTE);
        boolean triggerred = this.timeBasedFNATP.isTriggeringEvent(null, null);
        Assert.assertTrue((boolean)triggerred);
        String elapsedPeriodsFileName = this.timeBasedFNATP.getElapsedPeriodsFileName();
        Assert.assertEquals((Object)"foo-2011-12/59.log", (Object)elapsedPeriodsFileName);
    }

    @Test
    public void withTimeZone() {
        long startTime = 1324400341553L;
        this.tbrp.setFileNamePattern("foo-%d{yyyy-MM-dd, GMT+5}.log");
        this.tbrp.start();
        this.timeBasedFNATP.setCurrentTime(startTime);
        this.timeBasedFNATP.start();
        this.timeBasedFNATP.setCurrentTime(startTime + MILLIS_IN_MINUTE + 2L * MILLIS_IN_HOUR);
        boolean triggerred = this.timeBasedFNATP.isTriggeringEvent(null, null);
        Assert.assertTrue((boolean)triggerred);
        String elapsedPeriodsFileName = this.timeBasedFNATP.getElapsedPeriodsFileName();
        Assert.assertEquals((Object)"foo-2011-12-20.log", (Object)elapsedPeriodsFileName);
    }
}

