/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class RollingCalendarTest {
    @Test
    public void testPeriodicity() {
        RollingCalendar rc = new RollingCalendar("yyyy-MM-dd_HH_mm_ss");
        Assert.assertEquals((Object)PeriodicityType.TOP_OF_SECOND, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM-dd_HH_mm");
        Assert.assertEquals((Object)PeriodicityType.TOP_OF_MINUTE, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM-dd_HH");
        Assert.assertEquals((Object)PeriodicityType.TOP_OF_HOUR, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM-dd_hh");
        Assert.assertEquals((Object)PeriodicityType.TOP_OF_HOUR, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM-dd");
        Assert.assertEquals((Object)PeriodicityType.TOP_OF_DAY, (Object)rc.getPeriodicityType());
        rc = new RollingCalendar("yyyy-MM");
        Assert.assertEquals((Object)PeriodicityType.TOP_OF_MONTH, (Object)rc.getPeriodicityType());
    }

    @Test
    public void testVaryingNumberOfHourlyPeriods() {
        RollingCalendar rc = new RollingCalendar("yyyy-MM-dd_HH");
        long MILLIS_IN_HOUR = 3600000L;
        for (int p = 100; p > -100; --p) {
            long now = 1223325293589L;
            Date result = rc.getEndOfNextNthPeriod(new Date(now), p);
            long expected = now - now % MILLIS_IN_HOUR + (long)p * MILLIS_IN_HOUR;
            Assert.assertEquals((long)expected, (long)result.getTime());
        }
    }

    @Test
    public void testVaryingNumberOfDailyPeriods() {
        RollingCalendar rc = new RollingCalendar("yyyy-MM-dd");
        long MILLIS_IN_DAY = 86400000L;
        for (int p = 20; p > -100; --p) {
            long now = 1223325293589L;
            Date nowDate = new Date(now);
            Date result = rc.getEndOfNextNthPeriod(nowDate, p);
            long offset = rc.getTimeZone().getRawOffset() + rc.getTimeZone().getDSTSavings();
            long origin = now - (now + offset) % 86400000L;
            long expected = origin + (long)p * 86400000L;
            Assert.assertEquals((String)("p=" + p), (long)expected, (long)result.getTime());
        }
    }

    @Test
    public void testCollisionFreenes() {
        this.checkCollisionFreeness("yyyy-MM-dd hh", false);
        this.checkCollisionFreeness("yyyy-MM-dd hh a", true);
        this.checkCollisionFreeness("yyyy-MM-dd HH", true);
        this.checkCollisionFreeness("yyyy-MM-dd kk", true);
        this.checkCollisionFreeness("yyyy-MM-dd KK", false);
        this.checkCollisionFreeness("yyyy-MM-dd KK a", true);
        this.checkCollisionFreeness("yyyy-MM-dd", true);
        this.checkCollisionFreeness("yyyy-dd", false);
        this.checkCollisionFreeness("dd", false);
        this.checkCollisionFreeness("MM-dd", false);
        this.checkCollisionFreeness("yyyy-DDD", true);
        this.checkCollisionFreeness("DDD", false);
        this.checkCollisionFreeness("yyyy-MM-dd-uu", true);
        this.checkCollisionFreeness("yyyy-MM-uu", false);
        this.checkCollisionFreeness("yyyy-MM-WW", true);
        this.checkCollisionFreeness("yyyy-WW", false);
        this.checkCollisionFreeness("yyyy-ww", true);
        this.checkCollisionFreeness("ww", false);
    }

    private void checkCollisionFreeness(String pattern, boolean expected) {
        RollingCalendar rc = new RollingCalendar(pattern);
        if (expected) {
            Assert.assertTrue((boolean)rc.isCollisionFree());
        } else {
            Assert.assertFalse((boolean)rc.isCollisionFree());
        }
    }
}

