/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Token;
import ch.qos.logback.core.subst.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TokenizerTest {
    List<Token> witnessList = new ArrayList<Token>();

    @Test
    public void literalOnly() throws ScanException {
        String input = "abc";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, input));
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void literalWithAccolades() throws ScanException {
        String input0 = "%logger";
        String input1 = "24";
        String input2 = " - %m";
        String input = input0 + "{" + input1 + "}" + input2;
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, input0));
        this.witnessList.add(Token.CURLY_LEFT_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, input1));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, input2));
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void simleVariable() throws ScanException {
        String input = "${abc}";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "abc"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void mix() throws ScanException {
        String input = "a${b}c";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "c"));
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void nested() throws ScanException {
        String input = "a${b${c}}";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "c"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void basicDefaultSeparator() throws ScanException {
        String input = "${a:-b}";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(Token.DEFAULT_SEP_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void colon() throws ScanException {
        String input = "a:b";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(new Token(Token.Type.LITERAL, ":b"));
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void colonFollowedByDollar() throws ScanException {
        String input = "a:${b}";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(new Token(Token.Type.LITERAL, ":"));
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void defaultSeparatorOutsideVariable() throws ScanException {
        String input = "{a:-b}";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(Token.CURLY_LEFT_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(Token.DEFAULT_SEP_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void literalContainingColon() throws ScanException {
        String input = "a:b";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(new Token(Token.Type.LITERAL, ":b"));
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }

    @Test
    public void literalEndingWithColon_LOGBACK_1140() throws ScanException {
        String input = "a:";
        Tokenizer tokenizer = new Tokenizer(input);
        List tokenList = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(new Token(Token.Type.LITERAL, ":"));
        Assert.assertEquals(this.witnessList, (Object)tokenList);
    }
}

