/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.HardenedObjectInputStream;
import ch.qos.logback.core.net.Innocent;
import ch.qos.logback.core.util.EnvUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HardenedObjectInputStreamTest {
    ByteArrayOutputStream bos;
    ObjectOutputStream oos;
    HardenedObjectInputStream inputStream;
    String[] whitelist = new String[]{Innocent.class.getName()};

    @Before
    public void setUp() throws Exception {
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void smoke() throws ClassNotFoundException, IOException {
        Innocent innocent = new Innocent();
        innocent.setAnInt(1);
        innocent.setAnInteger(2);
        innocent.setaString("smoke");
        Innocent back = this.writeAndRead(innocent);
        Assert.assertEquals((Object)innocent, (Object)back);
    }

    private Innocent writeAndRead(Innocent innocent) throws IOException, ClassNotFoundException {
        this.writeObject(this.oos, innocent);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new HardenedObjectInputStream((InputStream)bis, this.whitelist);
        Innocent fooBack = (Innocent)this.inputStream.readObject();
        this.inputStream.close();
        return fooBack;
    }

    private void writeObject(ObjectOutputStream oos, Object o) throws IOException {
        oos.writeObject(o);
        oos.flush();
        oos.close();
    }

    @Test
    public void denialOfService() throws ClassNotFoundException, IOException {
        if (!EnvUtil.isJDK9OrHigher()) {
            return;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(this.payload());
        this.inputStream = new HardenedObjectInputStream((InputStream)bis, this.whitelist);
        try {
            this.inputStream.readObject();
            Assert.fail((String)"InvalidClassException expected");
        }
        catch (InvalidClassException invalidClassException) {
        }
        finally {
            this.inputStream.close();
        }
    }

    private byte[] payload() throws IOException {
        Set root = this.buildEvilHashset();
        this.writeObject(this.oos, root);
        return this.bos.toByteArray();
    }

    private Set buildEvilHashset() {
        HashSet root;
        HashSet s1 = root = new HashSet();
        HashSet s2 = new HashSet();
        for (int i = 0; i < 100; ++i) {
            HashSet<String> t1 = new HashSet<String>();
            HashSet t2 = new HashSet();
            t1.add("foo");
            s1.add(t1);
            s1.add(t2);
            s2.add(t1);
            s2.add(t2);
            s1 = t1;
            s2 = t2;
        }
        return root;
    }
}

