/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.NopEncoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CollisionDetectionTest {
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDir = "target/test-output/" + this.diff + "/";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    FileAppender<String> buildFileAppender(String name, String filenameSuffix) {
        FileAppender fileAppender = new FileAppender();
        fileAppender.setName(name);
        fileAppender.setContext(this.context);
        fileAppender.setFile(this.randomOutputDir + filenameSuffix);
        fileAppender.setEncoder(new NopEncoder());
        return fileAppender;
    }

    RollingFileAppender<String> buildRollingFileAppender(String name, String filenameSuffix, String patternSuffix) {
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setName(name);
        rollingFileAppender.setContext(this.context);
        rollingFileAppender.setFile(this.randomOutputDir + filenameSuffix);
        rollingFileAppender.setEncoder(new NopEncoder());
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern(this.randomOutputDir + patternSuffix);
        tbrp.setParent((FileAppender)rollingFileAppender);
        rollingFileAppender.setRollingPolicy((RollingPolicy)tbrp);
        tbrp.start();
        return rollingFileAppender;
    }

    @Test
    public void collisionImpossibleForSingleAppender() {
        FileAppender<String> fileAppender = this.buildFileAppender("FA", "collisionImpossibleForSingleAppender");
        fileAppender.start();
        this.statusChecker.assertIsErrorFree();
    }

    @Test
    public void appenderStopShouldClearEntryInCollisionMap() {
        String key = "FA";
        FileAppender<String> fileAppender = this.buildFileAppender(key, "collisionImpossibleForSingleAppender");
        fileAppender.start();
        this.assertCollisionMapHasEntry("FA_FILENAME_COLLISION_MAP", key);
        fileAppender.stop();
        this.assertCollisionMapHasNoEntry("FA_FILENAME_COLLISION_MAP", key);
        this.statusChecker.assertIsErrorFree();
    }

    private void assertCollisionMapHasEntry(String mapName, String key) {
        Map map = (Map)this.context.getObject(mapName);
        Assert.assertNotNull((Object)map);
        Assert.assertNotNull(map.get(key));
    }

    private void assertCollisionMapHasNoEntry(String mapName, String key) {
        Map map = (Map)this.context.getObject(mapName);
        Assert.assertNotNull((Object)map);
        Assert.assertNull(map.get(key));
    }

    @Test
    public void collisionWithTwoFileAppenders() {
        String suffix = "collisionWithToFileAppenders";
        FileAppender<String> fileAppender1 = this.buildFileAppender("FA1", suffix);
        fileAppender1.start();
        FileAppender<String> fileAppender2 = this.buildFileAppender("FA2", suffix);
        fileAppender2.start();
        this.statusChecker.assertContainsMatch(2, "'File' option has the same value");
    }

    @Test
    public void collisionWith_FA_RFA() {
        String suffix = "collisionWith_FA_RFA";
        FileAppender<String> fileAppender1 = this.buildFileAppender("FA", suffix);
        fileAppender1.start();
        RollingFileAppender<String> rollingfileAppender = this.buildRollingFileAppender("RFA", suffix, "bla-%d.log");
        rollingfileAppender.start();
        StatusPrinter.print((Context)this.context);
        this.statusChecker.assertContainsMatch(2, "'File' option has the same value");
    }

    @Test
    public void collisionWith_2RFA() {
        String suffix = "collisionWith_2RFA";
        RollingFileAppender<String> rollingfileAppender1 = this.buildRollingFileAppender("RFA1", suffix, "bla-%d.log");
        rollingfileAppender1.start();
        RollingFileAppender<String> rollingfileAppender2 = this.buildRollingFileAppender("RFA1", suffix, "bla-%d.log");
        rollingfileAppender2.start();
        StatusPrinter.print((Context)this.context);
        this.statusChecker.assertContainsMatch(2, "'FileNamePattern' option has the same value");
    }
}

