/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.EnvUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;

public class EnvUtilTest {
    @Mock
    private String savedVersion = System.getProperty("java.version");

    @After
    public void tearDown() {
        System.setProperty("java.version", this.savedVersion);
    }

    @Test
    public void jdkVersion() {
        Assert.assertEquals((long)4L, (long)EnvUtil.getJDKVersion((String)"1.4.xx"));
        Assert.assertEquals((long)5L, (long)EnvUtil.getJDKVersion((String)"1.5"));
        Assert.assertEquals((long)5L, (long)EnvUtil.getJDKVersion((String)"1.5.xx"));
        Assert.assertEquals((long)5L, (long)EnvUtil.getJDKVersion((String)"1.5AA"));
        Assert.assertEquals((long)9L, (long)EnvUtil.getJDKVersion((String)"9EA"));
        Assert.assertEquals((long)18L, (long)EnvUtil.getJDKVersion((String)"18.3+xx"));
    }

    @Test
    public void testJava1_4() {
        System.setProperty("java.version", "1.4.xx");
        Assert.assertFalse((boolean)EnvUtil.isJDK5());
        Assert.assertFalse((boolean)EnvUtil.isJDK6OrHigher());
        Assert.assertFalse((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_5() {
        System.setProperty("java.version", "1.5");
        Assert.assertTrue((boolean)EnvUtil.isJDK5());
        Assert.assertFalse((boolean)EnvUtil.isJDK6OrHigher());
        Assert.assertFalse((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_5_x() {
        System.setProperty("java.version", "1.5.xx");
        Assert.assertTrue((boolean)EnvUtil.isJDK5());
        Assert.assertFalse((boolean)EnvUtil.isJDK6OrHigher());
        Assert.assertFalse((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_6() {
        System.setProperty("java.version", "1.6.xx");
        Assert.assertTrue((boolean)EnvUtil.isJDK5());
        Assert.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assert.assertFalse((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_7() {
        System.setProperty("java.version", "1.7.xx");
        Assert.assertTrue((boolean)EnvUtil.isJDK5());
        Assert.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assert.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava1_8() {
        System.setProperty("java.version", "1.8.xx");
        Assert.assertTrue((boolean)EnvUtil.isJDK5());
        Assert.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assert.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava9() {
        System.setProperty("java.version", "9");
        Assert.assertTrue((boolean)EnvUtil.isJDK5());
        Assert.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assert.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava9_1() {
        System.setProperty("java.version", "9.xx");
        Assert.assertTrue((boolean)EnvUtil.isJDK5());
        Assert.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assert.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }

    @Test
    public void testJava18_3() {
        System.setProperty("java.version", "18.3+xx");
        Assert.assertEquals((long)18L, (long)EnvUtil.getJDKVersion((String)"18.3+xx"));
        Assert.assertTrue((boolean)EnvUtil.isJDK5());
        Assert.assertTrue((boolean)EnvUtil.isJDK6OrHigher());
        Assert.assertTrue((boolean)EnvUtil.isJDK7OrHigher());
    }
}

