/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.testUtil.DelayingListAppender;
import ch.qos.logback.core.testUtil.NPEAppender;
import ch.qos.logback.core.testUtil.StatusChecker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncAppenderBaseTest {
    Context context = new ContextBase();
    AsyncAppenderBase<Integer> asyncAppenderBase = new AsyncAppenderBase();
    LossyAsyncAppender lossyAsyncAppender = new LossyAsyncAppender();
    DelayingListAppender<Integer> delayingListAppender = new DelayingListAppender();
    ListAppender<Integer> listAppender = new ListAppender();
    OnConsoleStatusListener onConsoleStatusListener = new OnConsoleStatusListener();
    StatusChecker statusChecker = new StatusChecker(this.context);

    @Before
    public void setUp() {
        this.onConsoleStatusListener.setContext(this.context);
        this.context.getStatusManager().add((StatusListener)this.onConsoleStatusListener);
        this.onConsoleStatusListener.start();
        this.asyncAppenderBase.setContext(this.context);
        this.lossyAsyncAppender.setContext(this.context);
        this.listAppender.setContext(this.context);
        this.listAppender.setName("list");
        this.listAppender.start();
        this.delayingListAppender.setContext(this.context);
        this.delayingListAppender.setName("list");
        this.delayingListAppender.start();
    }

    @Test(timeout=2000L)
    public void smoke() {
        this.asyncAppenderBase.addAppender(this.listAppender);
        this.asyncAppenderBase.start();
        this.asyncAppenderBase.doAppend((Object)0);
        this.asyncAppenderBase.stop();
        this.verify(this.listAppender, 1);
    }

    @Test
    public void exceptionsShouldNotCauseHalting() throws InterruptedException {
        NPEAppender npeAppender = new NPEAppender();
        npeAppender.setName("bad");
        npeAppender.setContext(this.context);
        npeAppender.start();
        this.asyncAppenderBase.addAppender(npeAppender);
        this.asyncAppenderBase.start();
        Assert.assertTrue((boolean)this.asyncAppenderBase.isStarted());
        for (int i = 0; i < 10; ++i) {
            this.asyncAppenderBase.append((Object)i);
        }
        this.asyncAppenderBase.stop();
        Assert.assertFalse((boolean)this.asyncAppenderBase.isStarted());
        Assert.assertEquals((long)5L, (long)this.statusChecker.matchCount("Appender \\[bad\\] failed to append."));
    }

    @Test(timeout=2000L)
    public void emptyQueueShouldBeStoppable() {
        this.asyncAppenderBase.addAppender(this.listAppender);
        this.asyncAppenderBase.start();
        this.asyncAppenderBase.stop();
        this.verify(this.listAppender, 0);
    }

    @Test(timeout=2000L)
    public void workerShouldStopEvenIfInterruptExceptionConsumedWithinSubappender() {
        this.delayingListAppender.delay = 100;
        this.asyncAppenderBase.addAppender(this.delayingListAppender);
        this.asyncAppenderBase.start();
        this.asyncAppenderBase.doAppend((Object)0);
        this.asyncAppenderBase.stop();
        this.verify(this.delayingListAppender, 1);
        Assert.assertTrue((boolean)this.delayingListAppender.interrupted);
        Thread.interrupted();
    }

    @Test(timeout=2000L)
    public void noEventLoss() {
        int bufferSize = 10;
        int loopLen = bufferSize * 2;
        this.asyncAppenderBase.addAppender(this.delayingListAppender);
        this.asyncAppenderBase.setQueueSize(bufferSize);
        this.asyncAppenderBase.start();
        for (int i = 0; i < loopLen; ++i) {
            this.asyncAppenderBase.doAppend((Object)i);
        }
        this.asyncAppenderBase.stop();
        this.verify(this.delayingListAppender, loopLen);
    }

    @Test(timeout=2000L)
    public void eventLossIfNeverBlock() {
        int bufferSize = 10;
        int loopLen = bufferSize * 200;
        this.delayingListAppender.setDelay(5);
        this.asyncAppenderBase.addAppender(this.delayingListAppender);
        this.asyncAppenderBase.setQueueSize(bufferSize);
        this.asyncAppenderBase.setNeverBlock(true);
        this.asyncAppenderBase.start();
        for (int i = 0; i < loopLen; ++i) {
            this.asyncAppenderBase.doAppend((Object)i);
        }
        this.asyncAppenderBase.stop();
        this.statusChecker.assertIsErrorFree();
    }

    @Test(timeout=2000L)
    public void lossyAppenderShouldOnlyLoseCertainEvents() {
        int bufferSize = 5;
        int loopLen = bufferSize * 2;
        this.lossyAsyncAppender.addAppender((Appender)this.delayingListAppender);
        this.lossyAsyncAppender.setQueueSize(bufferSize);
        this.lossyAsyncAppender.setDiscardingThreshold(1);
        this.lossyAsyncAppender.start();
        for (int i = 0; i < loopLen; ++i) {
            this.lossyAsyncAppender.doAppend(i);
        }
        this.lossyAsyncAppender.stop();
        this.verify(this.delayingListAppender, loopLen - 2);
    }

    @Test(timeout=2000L)
    public void lossyAppenderShouldBeNonLossyIfDiscardingThresholdIsZero() {
        int bufferSize = 5;
        int loopLen = bufferSize * 2;
        this.lossyAsyncAppender.addAppender((Appender)this.delayingListAppender);
        this.lossyAsyncAppender.setQueueSize(bufferSize);
        this.lossyAsyncAppender.setDiscardingThreshold(0);
        this.lossyAsyncAppender.start();
        for (int i = 0; i < loopLen; ++i) {
            this.lossyAsyncAppender.doAppend(i);
        }
        this.lossyAsyncAppender.stop();
        this.verify(this.delayingListAppender, loopLen);
    }

    @Test
    public void invalidQueueCapacityShouldResultInNonStartedAppender() {
        this.asyncAppenderBase.addAppender((Appender)new NOPAppender());
        this.asyncAppenderBase.setQueueSize(0);
        Assert.assertEquals((long)0L, (long)this.asyncAppenderBase.getQueueSize());
        this.asyncAppenderBase.start();
        Assert.assertFalse((boolean)this.asyncAppenderBase.isStarted());
        this.statusChecker.assertContainsMatch("Invalid queue size");
    }

    @Test
    public void workerThreadFlushesOnStop() {
        int loopLen = 5;
        int maxRuntime = (loopLen + 1) * Math.max(1000, this.delayingListAppender.delay);
        DelayingListAppender<Integer> la = this.delayingListAppender;
        this.asyncAppenderBase.addAppender(la);
        this.asyncAppenderBase.setDiscardingThreshold(0);
        this.asyncAppenderBase.setMaxFlushTime(maxRuntime);
        this.asyncAppenderBase.start();
        this.asyncAppenderBase.worker.suspend();
        for (int i = 0; i < loopLen; ++i) {
            this.asyncAppenderBase.doAppend((Object)i);
        }
        Assert.assertEquals((long)loopLen, (long)this.asyncAppenderBase.getNumberOfElementsInQueue());
        Assert.assertEquals((long)0L, (long)la.list.size());
        this.asyncAppenderBase.worker.resume();
        this.asyncAppenderBase.stop();
        Assert.assertEquals((long)0L, (long)this.asyncAppenderBase.getNumberOfElementsInQueue());
        this.verify(la, loopLen);
    }

    @Test
    public void stopExitsWhenMaxRuntimeReached() throws InterruptedException {
        int maxFlushTime = 1;
        int loopLen = 10;
        DelayingListAppender<Integer> la = this.delayingListAppender;
        this.asyncAppenderBase.addAppender(la);
        this.asyncAppenderBase.setMaxFlushTime(maxFlushTime);
        this.asyncAppenderBase.start();
        for (int i = 0; i < loopLen; ++i) {
            this.asyncAppenderBase.doAppend((Object)i);
        }
        this.asyncAppenderBase.stop();
        this.statusChecker.assertContainsMatch("Max queue flush timeout \\(" + maxFlushTime + " ms\\) exceeded.");
        this.asyncAppenderBase.worker.join();
        this.verify(la, loopLen);
    }

    @Test
    public void verifyInterruptionIsNotSwallowed() {
        this.asyncAppenderBase.addAppender(this.delayingListAppender);
        this.asyncAppenderBase.start();
        Thread.currentThread().interrupt();
        this.asyncAppenderBase.doAppend((Object)new Integer(0));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        Thread.interrupted();
    }

    @Test
    public void verifyInterruptionDoesNotPreventLogging() {
        this.asyncAppenderBase.addAppender(this.listAppender);
        this.asyncAppenderBase.start();
        this.asyncAppenderBase.doAppend((Object)new Integer(0));
        Thread.currentThread().interrupt();
        this.asyncAppenderBase.doAppend((Object)new Integer(1));
        this.asyncAppenderBase.doAppend((Object)new Integer(1));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        Thread.interrupted();
        this.asyncAppenderBase.stop();
        this.verify(this.listAppender, 3);
    }

    @Test
    public void verifyInterruptionFlagWhenStopping_INTERUPPTED() {
        this.asyncAppenderBase.addAppender(this.listAppender);
        this.asyncAppenderBase.start();
        Thread.currentThread().interrupt();
        this.asyncAppenderBase.stop();
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        Thread.interrupted();
    }

    @Test
    public void verifyInterruptionFlagWhenStopping_NOT_INTERUPPTED() {
        this.asyncAppenderBase.addAppender(this.listAppender);
        this.asyncAppenderBase.start();
        this.asyncAppenderBase.stop();
        Assert.assertFalse((boolean)Thread.currentThread().isInterrupted());
    }

    @Test
    public void verifyInterruptionOfWorkerIsSwallowed() {
        this.asyncAppenderBase.addAppender(this.delayingListAppender);
        this.asyncAppenderBase.start();
        this.asyncAppenderBase.stop();
        Assert.assertFalse((boolean)this.asyncAppenderBase.worker.isInterrupted());
    }

    private void verify(ListAppender<Integer> la, int atLeast) {
        Assert.assertFalse((boolean)la.isStarted());
        Assert.assertTrue((String)(atLeast + " <= " + la.list.size()), (atLeast <= la.list.size() ? 1 : 0) != 0);
        this.statusChecker.assertIsErrorFree();
        this.statusChecker.assertContainsMatch("Worker thread will flush remaining events before exiting.");
    }

    @Test
    public void checkThatStartMethodIsIdempotent() {
        this.asyncAppenderBase.addAppender((Appender)this.lossyAsyncAppender);
        this.asyncAppenderBase.start();
        this.asyncAppenderBase.start();
    }

    static class LossyAsyncAppender
    extends AsyncAppenderBase<Integer> {
        LossyAsyncAppender() {
        }

        protected boolean isDiscardable(Integer i) {
            return i % 3 == 0;
        }
    }
}

