/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.pattern.SpacePadder;
import ch.qos.logback.core.rolling.ConfigParameters;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.FileMatchFunction;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.rolling.testUtil.ScaffoldingForRollingTests;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.FixedRateInvocationGate;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TimeBasedRollingWithArchiveRemoval_Test
extends ScaffoldingForRollingTests {
    String MONTHLY_DATE_PATTERN = "yyyy-MM";
    String MONTHLY_CRONOLOG_DATE_PATTERN = "yyyy/MM";
    final String DAILY_CRONOLOG_DATE_PATTERN = "yyyy/MM/dd";
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp = new TimeBasedRollingPolicy();
    TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
    StatusChecker checker = new StatusChecker(this.context);
    static long MILLIS_IN_MINUTE = 60000L;
    static long MILLIS_IN_HOUR = 60L * MILLIS_IN_MINUTE;
    static long MILLIS_IN_DAY = 24L * MILLIS_IN_HOUR;
    static long MILLIS_IN_MONTH = (long)(30.43684991666667 * (double)MILLIS_IN_DAY);
    static int MONTHS_IN_YEAR = 12;
    static final long WED_2016_03_23_T_230705_CET = 1458770825333L;
    static final long THU_2016_03_17_T_230330_CET = 1458252210975L;
    int slashCount = 0;
    int ticksPerPeriod = 216;
    ConfigParameters cp;
    FixedRateInvocationGate fixedRateInvocationGate = new FixedRateInvocationGate(this.ticksPerPeriod / 2);
    boolean DO_CLEAN_HISTORY_ON_START = true;
    boolean DO_NOT_CLEAN_HISTORY_ON_START = false;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.cp = new ConfigParameters(this.currentTime);
    }

    private int computeSlashCount(String datePattern) {
        if (datePattern == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < datePattern.length(); ++i) {
            char c = datePattern.charAt(i);
            if (c != '/') continue;
            ++count;
        }
        return count;
    }

    @Test
    public void monthlyRolloverOverManyPeriods() {
        this.slashCount = this.computeSlashCount(this.MONTHLY_CRONOLOG_DATE_PATTERN);
        int maxHistory = 2;
        int simulatedNumberOfPeriods = 30;
        String fileNamePattern = this.randomOutputDir + "/%d{" + this.MONTHLY_CRONOLOG_DATE_PATTERN + "}/clean.txt.zip";
        this.cp.maxHistory(maxHistory).fileNamePattern(fileNamePattern).simulatedNumberOfPeriods(simulatedNumberOfPeriods).periodDurationInMillis(MILLIS_IN_MONTH);
        long startTime = this.currentTime;
        long endTime = this.logOverMultiplePeriods(this.cp);
        System.out.println("randomOutputDir:" + this.randomOutputDir);
        System.out.println("start:" + startTime + ", end=" + endTime);
        int differenceInMonths = RollingCalendar.diffInMonths((long)startTime, (long)endTime);
        System.out.println("differenceInMonths:" + differenceInMonths);
        Calendar startTimeAsCalendar = Calendar.getInstance();
        startTimeAsCalendar.setTimeInMillis(startTime);
        int indexOfStartPeriod = startTimeAsCalendar.get(2);
        boolean withExtraFolder = this.extraFolder(differenceInMonths, MONTHS_IN_YEAR, indexOfStartPeriod, maxHistory);
        this.checkFileCount(this.expectedCountWithFolders(maxHistory, withExtraFolder));
    }

    long generateDailyRollover(ConfigParameters cp) {
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        cp.fileNamePattern(this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt");
        return this.logOverMultiplePeriods(cp);
    }

    long generateDailyRolloverAndCheckFileCount(ConfigParameters cp) {
        long millisAtEnd = this.generateDailyRollover(cp);
        int periodBarriersCrossed = this.computeCrossedDayBarriers(this.currentTime, millisAtEnd);
        System.out.println("**** periodBarriersCrossed=" + periodBarriersCrossed);
        this.checkFileCount(this.expectedCountWithoutFoldersWithInactivity(cp.maxHistory, periodBarriersCrossed, cp.startInactivity + cp.numInactivityPeriods));
        return millisAtEnd;
    }

    @Test
    public void checkCrossedPeriodsWithDSTBarrier() {
        long SAT_2016_03_26_T_230705_CET = 1459030025333L;
        System.out.println("SAT_2016_03_26_T_230705_CET " + new Date(SAT_2016_03_26_T_230705_CET));
        long MON_2016_03_28_T_000705_CET = SAT_2016_03_26_T_230705_CET + 86400000L;
        System.out.println("MON_2016_03_28_T_000705_CET " + new Date(MON_2016_03_28_T_000705_CET));
        int result = this.computeCrossedDayBarriers(SAT_2016_03_26_T_230705_CET, MON_2016_03_28_T_000705_CET, "CET");
        Assert.assertEquals((long)2L, (long)result);
    }

    private int computeCrossedDayBarriers(long currentTime, long millisAtEnd) {
        return this.computeCrossedDayBarriers(currentTime, millisAtEnd, null);
    }

    private int computeCrossedDayBarriers(long currentTime, long millisAtEnd, String timeZoneID) {
        DateTimeZone dateTimeZone = DateTimeZone.getDefault();
        if (timeZoneID != null) {
            dateTimeZone = DateTimeZone.forID((String)timeZoneID);
        }
        LocalDate startInstant = new LocalDate(currentTime, dateTimeZone);
        LocalDate endInstant = new LocalDate(millisAtEnd, dateTimeZone);
        Days days = Days.daysBetween((ReadablePartial)startInstant, (ReadablePartial)endInstant);
        return days.getDays();
    }

    @Test
    public void checkCleanupForBasicDailyRollover() {
        this.cp.maxHistory(20).simulatedNumberOfPeriods(60).startInactivity(0).numInactivityPeriods(0);
        this.generateDailyRolloverAndCheckFileCount(this.cp);
    }

    @Test
    public void checkCleanupForBasicDailyRolloverWithSizeCap() {
        long bytesOutputPerPeriod = 15984L;
        int sizeInUnitsOfBytesPerPeriod = 2;
        this.cp.maxHistory(5).simulatedNumberOfPeriods(10).sizeCap((long)sizeInUnitsOfBytesPerPeriod * bytesOutputPerPeriod + 1000L);
        this.generateDailyRollover(this.cp);
        StatusPrinter.print((Context)this.context);
        this.checkFileCount(sizeInUnitsOfBytesPerPeriod + 1);
    }

    @Test
    public void checkThatSmallTotalSizeCapLeavesAtLeastOneArhcive() {
        long WED_2016_03_23_T_131345_CET = 1458734825333L;
        this.cp = new ConfigParameters(WED_2016_03_23_T_131345_CET);
        boolean verySmallCapSize = true;
        this.cp.maxHistory(5).simulatedNumberOfPeriods(3).sizeCap(1L);
        this.generateDailyRollover(this.cp);
        StatusPrinter.print((Context)this.context);
        this.checkFileCountAtMost(1);
    }

    @Test
    public void checkCleanupForBasicDailyRolloverWithMaxSize() {
        this.cp.maxHistory(6).simulatedNumberOfPeriods(30).startInactivity(10).numInactivityPeriods(1);
        this.generateDailyRolloverAndCheckFileCount(this.cp);
    }

    @Test
    public void checkCleanupForDailyRollover_15Periods() {
        this.cp.maxHistory(5).simulatedNumberOfPeriods(15).startInactivity(6).numInactivityPeriods(3);
        this.generateDailyRolloverAndCheckFileCount(this.cp);
    }

    @Test
    public void checkCleanupForDailyRolloverWithInactivity_30Periods() {
        this.cp.maxHistory(2).simulatedNumberOfPeriods(30).startInactivity(3).numInactivityPeriods(1);
        this.generateDailyRolloverAndCheckFileCount(this.cp);
    }

    @Test
    public void checkCleanupForDailyRolloverWithInactivity_10Periods() {
        this.currentTime = 1458252210975L;
        this.cp.maxHistory(6).simulatedNumberOfPeriods(10).startInactivity(2).numInactivityPeriods(2);
        this.generateDailyRolloverAndCheckFileCount(this.cp);
    }

    @Test
    public void checkCleanupForDailyRolloverWithSecondPhase() {
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        int maxHistory = 5;
        String fileNamePattern = this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt";
        ConfigParameters cp0 = new ConfigParameters(this.currentTime).maxHistory(maxHistory).fileNamePattern(fileNamePattern).simulatedNumberOfPeriods(maxHistory * 2);
        long endTime = this.logOverMultiplePeriods(cp0);
        ConfigParameters cp1 = new ConfigParameters(endTime + MILLIS_IN_DAY * 10L).maxHistory(maxHistory).fileNamePattern(fileNamePattern).simulatedNumberOfPeriods(maxHistory);
        this.logOverMultiplePeriods(cp1);
        this.checkFileCount(this.expectedCountWithoutFolders(maxHistory));
    }

    @Test
    public void dailyRolloverWithCronologPattern() {
        this.slashCount = this.computeSlashCount("yyyy/MM/dd");
        String fileNamePattern = this.randomOutputDir + "/%d{" + "yyyy/MM/dd" + "}/clean.txt.zip";
        this.cp.maxHistory(8).fileNamePattern(fileNamePattern).simulatedNumberOfPeriods(24);
        this.logOverMultiplePeriods(this.cp);
        int expectedDirMin = 9 + this.slashCount;
        int expectDirMax = expectedDirMin + 1 + 1;
        this.expectedFileAndDirCount(9, expectedDirMin, expectDirMax);
    }

    @Test
    public void dailySizeBasedRolloverWithoutCap() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.invocationGate = this.fixedRateInvocationGate;
        sizeAndTimeBasedFNATP.setMaxFileSize(new FileSize(10000L));
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        String fileNamePattern = this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}-clean.%i.zip";
        this.cp.maxHistory(5).fileNamePattern(fileNamePattern).simulatedNumberOfPeriods(20);
        this.logOverMultiplePeriods(this.cp);
        this.checkPatternCompliance(6 + this.slashCount, "\\d{4}-\\d{2}-\\d{2}-clean(\\.\\d)(.zip)?");
    }

    @Test
    public void dailySizeBasedRolloverWithSizeCap() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.invocationGate = new FixedRateInvocationGate(this.ticksPerPeriod / 8);
        long bytesPerPeriod = 17000L;
        long fileSize = bytesPerPeriod / 5L;
        int expectedFileCount = 10;
        long sizeCap = (long)expectedFileCount * fileSize;
        sizeAndTimeBasedFNATP.setMaxFileSize(new FileSize(fileSize));
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        long simulatedTime = 1457133279186L;
        ConfigParameters params = new ConfigParameters(simulatedTime);
        String fileNamePattern = this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}-clean.%i";
        params.maxHistory(60).fileNamePattern(fileNamePattern).simulatedNumberOfPeriods(10).sizeCap(sizeCap);
        this.logOverMultiplePeriods(params);
        List<File> foundFiles = this.findFilesByPattern("\\d{4}-\\d{2}-\\d{2}-clean(\\.\\d)");
        Collections.sort(foundFiles, new Comparator<File>(){

            @Override
            public int compare(File f0, File f1) {
                String s0 = f0.getName().toString();
                String s1 = f1.getName().toString();
                return s0.compareTo(s1);
            }
        });
        System.out.print(foundFiles);
        StatusPrinter.print((Context)this.context);
        this.checkFileCount(expectedFileCount - 1);
    }

    @Test
    public void dailyChronologSizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize(new FileSize(10000L));
        sizeAndTimeBasedFNATP.invocationGate = this.fixedRateInvocationGate;
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = 1;
        String fileNamePattern = this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}/clean.%i.zip";
        this.cp.maxHistory(5).fileNamePattern(fileNamePattern).simulatedNumberOfPeriods(15);
        this.logOverMultiplePeriods(this.cp);
        this.checkDirPatternCompliance(6);
    }

    @Test
    public void dailyChronologSizeBasedRolloverWithSecondPhase() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize(new FileSize(10000L));
        sizeAndTimeBasedFNATP.invocationGate = this.fixedRateInvocationGate;
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = 1;
        String fileNamePattern = this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}/clean.%i";
        int maxHistory = 5;
        this.cp.maxHistory(maxHistory).fileNamePattern(fileNamePattern).simulatedNumberOfPeriods(3);
        long endTime = this.logOverMultiplePeriods(this.cp);
        int simulatedNumberOfPeriods = maxHistory * 4;
        ConfigParameters cp1 = new ConfigParameters(endTime + MILLIS_IN_DAY * 7L).maxHistory(maxHistory).fileNamePattern(fileNamePattern).simulatedNumberOfPeriods(simulatedNumberOfPeriods);
        this.logOverMultiplePeriods(cp1);
        this.checkDirPatternCompliance(maxHistory + 1);
    }

    void logTwiceAndStop(long currentTime, String fileNamePattern, int maxHistory) {
        ConfigParameters params = new ConfigParameters(currentTime).fileNamePattern(fileNamePattern).maxHistory(maxHistory);
        this.buildRollingFileAppender(params, this.DO_CLEAN_HISTORY_ON_START);
        this.rfa.doAppend((Object)("Hello ----------------------------------------------------------" + new Date(currentTime)));
        this.add(this.tbrp.compressionFuture);
        this.add(this.tbrp.cleanUpFuture);
        this.waitForJobsToComplete();
        this.tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(currentTime += MILLIS_IN_DAY / 2L);
        this.rfa.doAppend((Object)("Hello ----------------------------------------------------------" + new Date(currentTime)));
        this.rfa.stop();
    }

    @Test
    public void cleanHistoryOnStart() {
        long simulatedTime = 1458770825333L;
        System.out.println(new Date(simulatedTime));
        String fileNamePattern = this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt";
        int maxHistory = 3;
        for (int i = 0; i <= 5; ++i) {
            this.logTwiceAndStop(simulatedTime, fileNamePattern, maxHistory);
            simulatedTime += MILLIS_IN_DAY;
        }
        StatusPrinter.print((Context)this.context);
        this.checkFileCount(this.expectedCountWithoutFolders(maxHistory));
    }

    @Test
    public void cleanHistoryOnStartWithDayPattern() {
        long simulatedTime = 1458770825333L;
        String fileNamePattern = this.randomOutputDir + "clean-%d{yyyy-MM-dd}.txt";
        int maxHistory = 3;
        for (int i = 0; i <= 5; ++i) {
            this.logTwiceAndStop(simulatedTime, fileNamePattern, maxHistory);
            simulatedTime += MILLIS_IN_DAY;
        }
        StatusPrinter.print((Context)this.context);
        this.checkFileCount(this.expectedCountWithoutFolders(maxHistory));
    }

    @Ignore
    @Test
    public void cleanHistoryOnStartWithHourPattern() {
        long now = this.currentTime;
        String fileNamePattern = this.randomOutputDir + "clean-%d{HH}.txt";
        int maxHistory = 3;
        for (int i = 0; i <= 5; ++i) {
            this.logTwiceAndStop(now, fileNamePattern, maxHistory);
            now += MILLIS_IN_HOUR;
        }
        StatusPrinter.print((Context)this.context);
        this.checkFileCount(this.expectedCountWithoutFolders(maxHistory));
    }

    int expectedCountWithoutFolders(int maxHistory) {
        return maxHistory + 1;
    }

    int expectedCountWithFolders(int maxHistory, boolean withExtraFolder) {
        int numLogFiles = maxHistory + 1;
        int numLogFilesAndFolders = numLogFiles * 2;
        int result = numLogFilesAndFolders + this.slashCount;
        if (withExtraFolder) {
            ++result;
        }
        return result;
    }

    void buildRollingFileAppender(ConfigParameters cp, boolean cleanHistoryOnStart) {
        this.rfa.setContext(this.context);
        this.rfa.setEncoder((Encoder)this.encoder);
        this.tbrp.setContext(this.context);
        this.tbrp.setFileNamePattern(cp.fileNamePattern);
        this.tbrp.setMaxHistory(cp.maxHistory);
        this.tbrp.setTotalSizeCap(new FileSize(cp.sizeCap));
        this.tbrp.setParent(this.rfa);
        this.tbrp.setCleanHistoryOnStart(cleanHistoryOnStart);
        this.tbrp.timeBasedFileNamingAndTriggeringPolicy = this.tbfnatp;
        this.tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(cp.simulatedTime);
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
    }

    long logOverMultiplePeriods(ConfigParameters cp) {
        this.buildRollingFileAppender(cp, this.DO_NOT_CLEAN_HISTORY_ON_START);
        int runLength = cp.simulatedNumberOfPeriods * this.ticksPerPeriod;
        int startInactivityIndex = cp.startInactivity * this.ticksPerPeriod;
        int endInactivityIndex = startInactivityIndex + cp.numInactivityPeriods * this.ticksPerPeriod;
        long tickDuration = cp.periodDurationInMillis / (long)this.ticksPerPeriod;
        System.out.println("cp.periodDurationInMillis=" + cp.periodDurationInMillis + ", tickDuration=:" + tickDuration + ", runLength=" + runLength);
        for (int i = 0; i <= runLength; ++i) {
            Date currentDate = new Date(this.tbrp.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime());
            if (i < startInactivityIndex || i > endInactivityIndex) {
                StringBuilder sb = new StringBuilder("Hello");
                String currentDateStr = currentDate.toString();
                String iAsString = Integer.toString(i);
                sb.append(currentDateStr);
                SpacePadder.spacePad((StringBuilder)sb, (int)(66 + (3 - iAsString.length() - currentDateStr.length())));
                sb.append(iAsString);
                this.rfa.doAppend((Object)sb.toString());
            }
            this.tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.addTime(this.tbrp.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime(), tickDuration));
            this.add(this.tbrp.compressionFuture);
            this.add(this.tbrp.cleanUpFuture);
            this.waitForJobsToComplete();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.rfa.stop();
        System.out.println("Current time at end of loop: " + new Date(this.tbrp.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime()));
        return this.tbrp.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime();
    }

    void fillWithChar(StringBuffer sb, char c, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
    }

    boolean extraFolder(int numPeriods, int periodsPerEra, int beginPeriod, int maxHistory) {
        int valueOfLastMonth = (beginPeriod + numPeriods) % periodsPerEra;
        return valueOfLastMonth < maxHistory;
    }

    long addTime(long time, long timeToWait) {
        return time + timeToWait;
    }

    void expectedFileAndDirCount(int expectedFileAndDirCount, int expectedDirCountMin, int expectedDirCountMax) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, fileList, "clean");
        ArrayList<File> dirList = new ArrayList<File>();
        this.findAllFoldersInFolderRecursively(dir, dirList);
        String msg = "expectedDirCountMin=" + expectedDirCountMin + ", expectedDirCountMax=" + expectedDirCountMax + " actual value=" + dirList.size();
        Assert.assertTrue((String)msg, (expectedDirCountMin <= dirList.size() && dirList.size() <= expectedDirCountMax ? 1 : 0) != 0);
    }

    void checkFileCount(int expectedCount) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findAllDirsOrStringContainsFilesRecursively(dir, fileList, "clean");
        Assert.assertEquals((long)expectedCount, (long)fileList.size());
    }

    void checkFileCountAtMost(int expectedCount) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findAllDirsOrStringContainsFilesRecursively(dir, fileList, "clean");
        int fileListSize = fileList.size();
        Assert.assertTrue((String)("file list size " + fileListSize + ", expectedCount=" + expectedCount), (fileListSize <= expectedCount ? 1 : 0) != 0);
    }

    int expectedCountWithoutFoldersWithInactivity(int maxHistory, int totalPeriods, int endOfInactivity) {
        int availableHistory = totalPeriods + 1 - endOfInactivity;
        int actualHistory = Math.min(availableHistory, maxHistory + 1);
        return actualHistory;
    }

    void genericFindMatching(final FileMatchFunction matchFunc, File dir, List<File> fileList, final String pattern, boolean includeDirs) {
        if (dir.isDirectory()) {
            File[] matchArray;
            for (File f : matchArray = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || matchFunc.match(f, pattern);
                }
            })) {
                if (f.isDirectory()) {
                    if (includeDirs) {
                        fileList.add(f);
                    }
                    this.genericFindMatching(matchFunc, f, fileList, pattern, includeDirs);
                    continue;
                }
                fileList.add(f);
            }
        }
    }

    private void findAllFoldersInFolderRecursively(File dir, List<File> fileList) {
        FileMatchFunction alwaysFalse = new FileMatchFunction(){

            @Override
            public boolean match(File f, String pattern) {
                return false;
            }
        };
        this.genericFindMatching(alwaysFalse, dir, fileList, null, true);
    }

    private void findAllDirsOrStringContainsFilesRecursively(File dir, List<File> fileList, String pattern) {
        FileMatchFunction matchFunction = new FileMatchFunction(){

            @Override
            public boolean match(File f, String pattern) {
                return f.getName().contains(pattern);
            }
        };
        this.genericFindMatching(matchFunction, dir, fileList, pattern, true);
    }

    void findFilesInFolderRecursivelyByPatterMatch(File dir, List<File> fileList, String pattern) {
        FileMatchFunction matchByPattern = new FileMatchFunction(){

            @Override
            public boolean match(File f, String pattern) {
                return f.getName().matches(pattern);
            }
        };
        this.genericFindMatching(matchByPattern, dir, fileList, pattern, false);
    }

    Set<String> groupByClass(List<File> fileList, String regex) {
        Pattern p = Pattern.compile(regex);
        HashSet<String> set = new HashSet<String>();
        for (File f : fileList) {
            String n = f.getName();
            Matcher m = p.matcher(n);
            m.matches();
            int begin = m.start(1);
            String reduced = n.substring(0, begin);
            set.add(reduced);
        }
        return set;
    }

    void checkPatternCompliance(int expectedClassCount, String regex) {
        Set<String> set = this.findFilesByPatternClass(regex);
        Assert.assertEquals((long)expectedClassCount, (long)set.size());
    }

    private List<File> findFilesByPattern(String regex) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, fileList, regex);
        return fileList;
    }

    private Set<String> findFilesByPatternClass(String regex) {
        List<File> fileList = this.findFilesByPattern(regex);
        Set<String> set = this.groupByClass(fileList, regex);
        return set;
    }

    void checkDirPatternCompliance(int expectedClassCount) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findAllFoldersInFolderRecursively(dir, fileList);
        for (File f : fileList) {
            Assert.assertTrue((f.list().length >= 1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)expectedClassCount, (long)fileList.size());
    }
}

