/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser.test;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.ExceptionalConverter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.testUtil.StatusChecker;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractPatternLayoutBaseTest<E> {
    public abstract PatternLayoutBase<E> getPatternLayoutBase();

    public abstract E getEventObject();

    public abstract Context getContext();

    @Test
    public void testUnStarted() {
        PatternLayoutBase<E> plb = this.getPatternLayoutBase();
        ContextBase context = new ContextBase();
        plb.setContext((Context)context);
        String s = plb.doLayout(this.getEventObject());
        Assert.assertEquals((Object)"", (Object)s);
    }

    @Test
    public void testConverterStart() {
        PatternLayoutBase<E> plb = this.getPatternLayoutBase();
        plb.setContext(this.getContext());
        plb.getInstanceConverterMap().put("EX", ExceptionalConverter.class.getName());
        plb.setPattern("%EX");
        plb.start();
        String result = plb.doLayout(this.getEventObject());
        Assert.assertFalse((boolean)result.contains("%PARSER_ERROR_EX"));
    }

    @Test
    public void testStarted() {
        PatternLayoutBase<E> plb = this.getPatternLayoutBase();
        ContextBase context = new ContextBase();
        plb.setContext((Context)context);
        String s = plb.doLayout(this.getEventObject());
        Assert.assertEquals((Object)"", (Object)s);
    }

    @Test
    public void testNullPattern() {
        PatternLayoutBase<E> plb = this.getPatternLayoutBase();
        ContextBase context = new ContextBase();
        plb.setContext((Context)context);
        plb.setPattern(null);
        plb.start();
        String s = plb.doLayout(this.getEventObject());
        Assert.assertEquals((Object)"", (Object)s);
        StatusChecker checker = new StatusChecker(context.getStatusManager());
        checker.assertContainsMatch("Empty or null pattern.");
    }

    @Test
    public void testEmptyPattern() {
        PatternLayoutBase<E> plb = this.getPatternLayoutBase();
        ContextBase context = new ContextBase();
        plb.setContext((Context)context);
        plb.setPattern("");
        plb.start();
        String s = plb.doLayout(this.getEventObject());
        Assert.assertEquals((Object)"", (Object)s);
        StatusChecker checker = new StatusChecker(context.getStatusManager());
        checker.assertContainsMatch("Empty or null pattern.");
    }
}

