/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.CaseCombinator;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;

public class SimpleRuleStoreTest {
    SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
    CaseCombinator cc = new CaseCombinator();

    @Test
    public void smoke() throws Exception {
        this.srs.addRule(new ElementSelector("a/b"), (Action)new XAction());
        for (String s : this.cc.combinations("a/b")) {
            System.out.println("s=" + s);
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            if (r.get(0) instanceof XAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void smokeII() throws Exception {
        this.srs.addRule(new ElementSelector("a/b"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("a/b"), (Action)new YAction());
        for (String s : this.cc.combinations("a/b")) {
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)2L, (long)r.size());
            if (!(r.get(0) instanceof XAction)) {
                Assert.fail((String)"Wrong type");
            }
            if (r.get(1) instanceof YAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testSlashSuffix() throws Exception {
        ElementSelector pa = new ElementSelector("a/");
        this.srs.addRule(pa, (Action)new XAction());
        for (String s : this.cc.combinations("a")) {
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            if (r.get(0) instanceof XAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail1() throws Exception {
        this.srs.addRule(new ElementSelector("*/b"), (Action)new XAction());
        for (String s : this.cc.combinations("a/b")) {
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            if (r.get(0) instanceof XAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail2() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new ElementSelector("*/c"), (Action)new XAction());
        for (String s : this.cc.combinations("a/b/c")) {
            List r = srs.matchActions(new ElementPath(s));
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            if (r.get(0) instanceof XAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail3() throws Exception {
        this.srs.addRule(new ElementSelector("*/b"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("*/a/b"), (Action)new YAction());
        for (String s : this.cc.combinations("a/b")) {
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            if (r.get(0) instanceof YAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail4() throws Exception {
        this.srs.addRule(new ElementSelector("*/b"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("*/a/b"), (Action)new YAction());
        this.srs.addRule(new ElementSelector("a/b"), (Action)new ZAction());
        for (String s : this.cc.combinations("a/b")) {
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            if (r.get(0) instanceof ZAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testSuffix() throws Exception {
        this.srs.addRule(new ElementSelector("a"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("a/*"), (Action)new YAction());
        for (String s : this.cc.combinations("a/b")) {
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertTrue((boolean)(r.get(0) instanceof YAction));
        }
    }

    @Test
    public void testDeepSuffix() throws Exception {
        this.srs.addRule(new ElementSelector("a"), (Action)new XAction(1));
        this.srs.addRule(new ElementSelector("a/b/*"), (Action)new XAction(2));
        for (String s : this.cc.combinations("a/other")) {
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNull((Object)r);
        }
    }

    @Test
    public void testPrefixSuffixInteraction1() throws Exception {
        this.srs.addRule(new ElementSelector("a"), (Action)new ZAction());
        this.srs.addRule(new ElementSelector("a/*"), (Action)new YAction());
        this.srs.addRule(new ElementSelector("*/a/b"), (Action)new XAction(3));
        for (String s : this.cc.combinations("a/b")) {
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertTrue((boolean)(r.get(0) instanceof XAction));
            XAction xaction = (XAction)((Object)r.get(0));
            Assert.assertEquals((long)3L, (long)xaction.id);
        }
    }

    @Test
    public void testPrefixSuffixInteraction2() throws Exception {
        this.srs.addRule(new ElementSelector("tG"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("tG/tS"), (Action)new YAction());
        this.srs.addRule(new ElementSelector("tG/tS/test"), (Action)new ZAction());
        this.srs.addRule(new ElementSelector("tG/tS/test/*"), (Action)new XAction(9));
        for (String s : this.cc.combinations("tG/tS/toto")) {
            List r = this.srs.matchActions(new ElementPath(s));
            Assert.assertNull((Object)r);
        }
    }

    class XAction
    extends Action {
        int id = 0;

        XAction() {
        }

        XAction(int id) {
            this.id = id;
        }

        public void begin(SaxEventInterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(SaxEventInterpretationContext ec, String name) {
        }

        public void finish(SaxEventInterpretationContext ec) {
        }

        public String toString() {
            return "XAction(" + this.id + ")";
        }
    }

    class YAction
    extends Action {
        YAction() {
        }

        public void begin(SaxEventInterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(SaxEventInterpretationContext ec, String name) {
        }

        public void finish(SaxEventInterpretationContext ec) {
        }
    }

    class ZAction
    extends Action {
        ZAction() {
        }

        public void begin(SaxEventInterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(SaxEventInterpretationContext ec, String name) {
        }

        public void finish(SaxEventInterpretationContext ec) {
        }
    }
}

