/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.SimpleConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.PropertyAction;
import ch.qos.logback.core.joran.action.TopElementAction;
import ch.qos.logback.core.joran.action.ext.StackAction;
import ch.qos.logback.core.joran.conditional.ElseAction;
import ch.qos.logback.core.joran.conditional.IfAction;
import ch.qos.logback.core.joran.conditional.ThenAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.StackModel;
import ch.qos.logback.core.model.TopModel;
import ch.qos.logback.core.model.conditional.ElseModel;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.model.conditional.ThenModel;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ImplicitModelHandler;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.NOPModelHandler;
import ch.qos.logback.core.model.processor.PropertyModelHandler;
import ch.qos.logback.core.model.processor.StackModelHandler;
import ch.qos.logback.core.model.processor.conditional.ElseModelHandler;
import ch.qos.logback.core.model.processor.conditional.IfModelHandler;
import ch.qos.logback.core.model.processor.conditional.ThenModelHandler;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IfThenElseTest {
    Context context = new ContextBase();
    StatusChecker checker = new StatusChecker(this.context);
    SimpleConfigurator simpleConfigurator;
    int diff = RandomUtil.getPositiveInt();
    static final String CONDITIONAL_DIR_PREFIX = "src/test/input/joran/conditional/";
    String ki1 = "ki1";
    String val1 = "val1";
    String sysKey = "sysKey";
    String dynaKey = "dynaKey";

    @Before
    public void setUp() throws Exception {
        HashMap<ElementSelector, Supplier<Action>> rulesMap = new HashMap<ElementSelector, Supplier<Action>>();
        rulesMap.put(new ElementSelector("x"), () -> new TopElementAction());
        rulesMap.put(new ElementSelector("x/stack"), () -> new StackAction());
        rulesMap.put(new ElementSelector("x/property"), () -> new PropertyAction());
        rulesMap.put(new ElementSelector("*/if"), () -> new IfAction());
        rulesMap.put(new ElementSelector("*/if/then"), () -> new ThenAction());
        rulesMap.put(new ElementSelector("*/if/else"), () -> new ElseAction());
        this.simpleConfigurator = new SimpleConfigurator(rulesMap){

            @Override
            protected void addInstanceRules(RuleStore rs) {
                super.addInstanceRules(rs);
                rs.addTransparentPathPart("if");
                rs.addTransparentPathPart("then");
                rs.addTransparentPathPart("else");
            }

            protected DefaultProcessor buildDefaultProcessor(Context context, ModelInterpretationContext mic) {
                DefaultProcessor defaultProcessor = super.buildDefaultProcessor(context, mic);
                defaultProcessor.addHandler(TopModel.class, NOPModelHandler::makeInstance);
                defaultProcessor.addHandler(StackModel.class, StackModelHandler::makeInstance);
                defaultProcessor.addHandler(PropertyModel.class, PropertyModelHandler::makeInstance);
                defaultProcessor.addHandler(ImplicitModel.class, ImplicitModelHandler::makeInstance);
                defaultProcessor.addHandler(IfModel.class, IfModelHandler::makeInstance);
                defaultProcessor.addHandler(ThenModel.class, ThenModelHandler::makeInstance);
                defaultProcessor.addHandler(ElseModel.class, ElseModelHandler::makeInstance);
                return defaultProcessor;
            }
        };
        this.simpleConfigurator.setContext(this.context);
    }

    @After
    public void tearDown() throws Exception {
        StatusPrinter.printIfErrorsOccured((Context)this.context);
        System.clearProperty(this.sysKey);
    }

    @Test
    public void whenContextPropertyIsSet_IfThenBranchIsEvaluated() throws JoranException {
        this.context.putProperty(this.ki1, this.val1);
        this.simpleConfigurator.doConfigure("src/test/input/joran/conditional/if0.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "END"});
    }

    @Test
    public void whenLocalPropertyIsSet_IfThenBranchIsEvaluated() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/conditional/if_localProperty.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "END"});
    }

    @Test
    public void whenNoPropertyIsDefined_ElseBranchIsEvaluated() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/conditional/if0.xml");
        this.verifyConfig(new String[]{"BEGIN", "b", "END"});
    }

    @Test
    public void whenContextPropertyIsSet_IfThenBranchIsEvaluated_NO_ELSE_DEFINED() throws JoranException {
        this.context.putProperty(this.ki1, this.val1);
        this.simpleConfigurator.doConfigure("src/test/input/joran/conditional/ifWithoutElse.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "END"});
    }

    @Test
    public void whenNoPropertyIsDefined_IfThenBranchIsNotEvaluated_NO_ELSE_DEFINED() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/conditional/ifWithoutElse.xml");
        this.verifyConfig(new String[]{"BEGIN", "END"});
        Assert.assertTrue((boolean)this.checker.isErrorFree(0L));
    }

    @Test
    public void nestedIf() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/conditional/nestedIf.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "c", "END"});
        Assert.assertTrue((boolean)this.checker.isErrorFree(0L));
    }

    @Test
    public void useNonExistenceOfSystemPropertyToDefineAContextProperty() throws JoranException {
        Assert.assertNull((Object)System.getProperty(this.sysKey));
        Assert.assertNull((Object)this.context.getProperty(this.dynaKey));
        this.simpleConfigurator.doConfigure("src/test/input/joran/conditional/ifSystem.xml");
        System.out.println(this.dynaKey + "=" + this.context.getProperty(this.dynaKey));
        Assert.assertNotNull((Object)this.context.getProperty(this.dynaKey));
    }

    @Test
    public void noContextPropertyShouldBeDefinedIfSystemPropertyExists() throws JoranException {
        System.setProperty(this.sysKey, "a");
        Assert.assertNull((Object)this.context.getProperty(this.dynaKey));
        System.out.println("before " + this.dynaKey + "=" + this.context.getProperty(this.dynaKey));
        this.simpleConfigurator.doConfigure("src/test/input/joran/conditional/ifSystem.xml");
        System.out.println(this.dynaKey + "=" + this.context.getProperty(this.dynaKey));
        Assert.assertNull((Object)this.context.getProperty(this.dynaKey));
    }

    private void verifyConfig(String[] expected) {
        Stack<String> witness = new Stack<String>();
        witness.addAll(Arrays.asList(expected));
        Stack aStack = (Stack)this.context.getObject("STACK_TEST");
        Assert.assertEquals(witness, (Object)aStack);
    }
}

