/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.action.PropertyAction;
import ch.qos.logback.core.joran.action.ext.StackAction;
import ch.qos.logback.core.joran.conditional.ElseAction;
import ch.qos.logback.core.joran.conditional.IfAction;
import ch.qos.logback.core.joran.conditional.ThenAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IfThenElseTest {
    Context context = new ContextBase();
    StatusChecker checker = new StatusChecker(this.context);
    TrivialConfigurator tc;
    int diff = RandomUtil.getPositiveInt();
    static final String CONDITIONAL_DIR_PREFIX = "src/test/input/joran/conditional/";
    String ki1 = "ki1";
    String val1 = "val1";
    String sysKey = "sysKey";
    String dynaKey = "dynaKey";
    StackAction stackAction = new StackAction();

    @Before
    public void setUp() throws Exception {
        HashMap<ElementSelector, Action> rulesMap = new HashMap<ElementSelector, Action>();
        rulesMap.put(new ElementSelector("x"), (Action)new NOPAction());
        rulesMap.put(new ElementSelector("x/stack"), this.stackAction);
        rulesMap.put(new ElementSelector("x/property"), (Action)new PropertyAction());
        rulesMap.put(new ElementSelector("*/if"), (Action)new IfAction());
        rulesMap.put(new ElementSelector("*/if/then"), (Action)new ThenAction());
        rulesMap.put(new ElementSelector("*/if/then/*"), (Action)new NOPAction());
        rulesMap.put(new ElementSelector("*/if/else"), (Action)new ElseAction());
        rulesMap.put(new ElementSelector("*/if/else/*"), (Action)new NOPAction());
        this.tc = new TrivialConfigurator(rulesMap);
        this.tc.setContext(this.context);
    }

    @After
    public void tearDown() throws Exception {
        StatusPrinter.printIfErrorsOccured((Context)this.context);
        System.clearProperty(this.sysKey);
    }

    @Test
    public void whenContextPropertyIsSet_IfThenBranchIsEvaluated() throws JoranException {
        this.context.putProperty(this.ki1, this.val1);
        this.tc.doConfigure("src/test/input/joran/conditional/if0.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "END"});
    }

    @Test
    public void whenLocalPropertyIsSet_IfThenBranchIsEvaluated() throws JoranException {
        this.tc.doConfigure("src/test/input/joran/conditional/if_localProperty.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "END"});
    }

    @Test
    public void whenNoPropertyIsDefined_ElseBranchIsEvaluated() throws JoranException {
        this.tc.doConfigure("src/test/input/joran/conditional/if0.xml");
        this.verifyConfig(new String[]{"BEGIN", "b", "END"});
    }

    @Test
    public void whenContextPropertyIsSet_IfThenBranchIsEvaluated_NO_ELSE_DEFINED() throws JoranException {
        this.context.putProperty(this.ki1, this.val1);
        this.tc.doConfigure("src/test/input/joran/conditional/ifWithoutElse.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "END"});
    }

    @Test
    public void whenNoPropertyIsDefined_IfThenBranchIsNotEvaluated_NO_ELSE_DEFINED() throws JoranException {
        this.tc.doConfigure("src/test/input/joran/conditional/ifWithoutElse.xml");
        this.verifyConfig(new String[]{"BEGIN", "END"});
        Assert.assertTrue((boolean)this.checker.isErrorFree(0L));
    }

    @Test
    public void nestedIf() throws JoranException {
        this.tc.doConfigure("src/test/input/joran/conditional/nestedIf.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "c", "END"});
        Assert.assertTrue((boolean)this.checker.isErrorFree(0L));
    }

    @Test
    public void useNonExistenceOfSystemPropertyToDefineAContextProperty() throws JoranException {
        Assert.assertNull((Object)System.getProperty(this.sysKey));
        Assert.assertNull((Object)this.context.getProperty(this.dynaKey));
        this.tc.doConfigure("src/test/input/joran/conditional/ifSystem.xml");
        System.out.println(this.dynaKey + "=" + this.context.getProperty(this.dynaKey));
        Assert.assertNotNull((Object)this.context.getProperty(this.dynaKey));
    }

    @Test
    public void noContextPropertyShouldBeDefinedIfSystemPropertyExists() throws JoranException {
        System.setProperty(this.sysKey, "a");
        Assert.assertNull((Object)this.context.getProperty(this.dynaKey));
        System.out.println("before " + this.dynaKey + "=" + this.context.getProperty(this.dynaKey));
        this.tc.doConfigure("src/test/input/joran/conditional/ifSystem.xml");
        System.out.println(this.dynaKey + "=" + this.context.getProperty(this.dynaKey));
        Assert.assertNull((Object)this.context.getProperty(this.dynaKey));
    }

    private void verifyConfig(String[] expected) {
        Stack<String> witness = new Stack<String>();
        witness.addAll(Arrays.asList(expected));
        Assert.assertEquals(witness, this.stackAction.getStack());
    }
}

