/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.action.TopElementAction;
import ch.qos.logback.core.joran.action.ext.BadBeginAction;
import ch.qos.logback.core.joran.action.ext.BadEndAction;
import ch.qos.logback.core.joran.action.ext.HelloAction;
import ch.qos.logback.core.joran.action.ext.TouchAction;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.junit.Assert;
import org.junit.Test;

public class SkippingInInterpreterTest {
    HashMap<ElementSelector, Action> rulesMap = new HashMap();
    Context context = new ContextBase();
    StatusManager sm = this.context.getStatusManager();

    SAXParser createParser() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        return spf.newSAXParser();
    }

    void doTest(String filename, Integer expectedInt, Class<?> exceptionClass) throws Exception {
        this.rulesMap.put(new ElementSelector("test"), (Action)new TopElementAction());
        this.rulesMap.put(new ElementSelector("test/badBegin"), new BadBeginAction());
        this.rulesMap.put(new ElementSelector("test/badBegin/touch"), new TouchAction());
        this.rulesMap.put(new ElementSelector("test/badEnd"), new BadEndAction());
        this.rulesMap.put(new ElementSelector("test/badEnd/touch"), new TouchAction());
        this.rulesMap.put(new ElementSelector("test/hello"), new HelloAction());
        this.rulesMap.put(new ElementSelector("test/isolate"), (Action)new NOPAction());
        this.rulesMap.put(new ElementSelector("test/isolate/badEnd"), new BadEndAction());
        this.rulesMap.put(new ElementSelector("test/isolate/badEnd/touch"), new TouchAction());
        this.rulesMap.put(new ElementSelector("test/isolate/touch"), new TouchAction());
        this.rulesMap.put(new ElementSelector("test/hello"), new HelloAction());
        TrivialConfigurator tc = new TrivialConfigurator(this.rulesMap);
        tc.setContext(this.context);
        tc.doConfigure("src/test/input/joran/skip/" + filename);
        String str = this.context.getProperty("name");
        Assert.assertEquals((Object)"Hello John Doe.", (Object)str);
        Integer i = (Integer)this.context.getObject("touched");
        if (expectedInt == null) {
            Assert.assertNull((Object)i);
        } else {
            Assert.assertEquals((Object)expectedInt, (Object)i);
        }
        List statusList = this.sm.getCopyOfStatusList();
        Status s0 = (Status)statusList.get(0);
        Assert.assertEquals((long)2L, (long)s0.getLevel());
        Assert.assertTrue((s0.getThrowable().getClass() == exceptionClass ? 1 : 0) != 0);
    }

    @Test
    public void testSkippingRuntimeExInBadBegin() throws Exception {
        this.doTest("badBegin1.xml", null, IllegalStateException.class);
    }

    @Test
    public void testSkippingActionExInBadBegin() throws Exception {
        this.doTest("badBegin2.xml", null, ActionException.class);
    }

    @Test
    public void testSkippingRuntimeExInBadEnd() throws Exception {
        this.doTest("badEnd1.xml", 2, IllegalStateException.class);
    }

    @Test
    public void testSkippingActionExInBadEnd() throws Exception {
        this.doTest("badEnd2.xml", 2, ActionException.class);
    }
}

