/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import java.util.Iterator;
import junit.framework.TestCase;

public class StatusBaseTest
extends TestCase {
    public void testAddStatus() {
        InfoStatus status = new InfoStatus("testing", (Object)this);
        status.add((Status)new ErrorStatus("error", (Object)this));
        Iterator it = status.iterator();
        StatusBaseTest.assertTrue((String)"No status was added", (boolean)it.hasNext());
        StatusBaseTest.assertTrue((String)"hasChilden method reported wrong result", (boolean)status.hasChildren());
        status = new InfoStatus("testing", (Object)this);
        try {
            status.add(null);
            StatusBaseTest.fail((String)"method should have thrown an Exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemoveStatus() {
        InfoStatus status = new InfoStatus("testing", (Object)this);
        ErrorStatus error = new ErrorStatus("error", (Object)this);
        status.add((Status)error);
        boolean result = status.remove((Status)error);
        Iterator it = status.iterator();
        StatusBaseTest.assertTrue((String)"Remove failed", (boolean)result);
        StatusBaseTest.assertFalse((String)"No status was removed", (boolean)it.hasNext());
        StatusBaseTest.assertFalse((String)"hasChilden method reported wrong result", (boolean)status.hasChildren());
        status = new InfoStatus("testing", (Object)this);
        error = new ErrorStatus("error", (Object)this);
        status.add((Status)error);
        result = status.remove(null);
        StatusBaseTest.assertFalse((String)"Remove result was not false", (boolean)result);
    }

    public void testEffectiveLevel() {
        ErrorStatus status = new ErrorStatus("error", (Object)this);
        WarnStatus warn = new WarnStatus("warning", (Object)this);
        status.add((Status)warn);
        StatusBaseTest.assertEquals((String)"effective level misevaluated", (int)status.getEffectiveLevel(), (int)2);
        status = new InfoStatus("info", (Object)this);
        warn = new WarnStatus("warning", (Object)this);
        status.add((Status)warn);
        StatusBaseTest.assertEquals((String)"effective level misevaluated", (int)status.getEffectiveLevel(), (int)1);
        status = new InfoStatus("info", (Object)this);
        warn = new WarnStatus("warning", (Object)this);
        ErrorStatus error = new ErrorStatus("error", (Object)this);
        status.add((Status)warn);
        warn.add((Status)error);
        StatusBaseTest.assertEquals((String)"effective level misevaluated", (int)status.getEffectiveLevel(), (int)2);
    }
}

