/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.SimpleConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.DefinePropertyAction;
import ch.qos.logback.core.joran.action.TopElementAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.model.DefineModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.TopModel;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.DefineModelHandler;
import ch.qos.logback.core.model.processor.ImplicitModelHandler;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.NOPModelHandler;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.HashMap;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class DefinePropertyActionTest {
    private static final String DEFINE_INPUT_DIR = "src/test/input/joran/define/";
    private static final String GOOD_XML = "good.xml";
    private static final String NONAME_XML = "noname.xml";
    private static final String NOCLASS_XML = "noclass.xml";
    private static final String BADCLASS_XML = "badclass.xml";
    SimpleConfigurator simpleConfigurator;
    Context context = new ContextBase();
    StatusChecker checker = new StatusChecker(this.context);

    @Before
    public void setUp() throws Exception {
        HashMap<ElementSelector, Supplier<Action>> rulesMap = new HashMap<ElementSelector, Supplier<Action>>();
        rulesMap.put(new ElementSelector("top"), TopElementAction::new);
        rulesMap.put(new ElementSelector("top/define"), DefinePropertyAction::new);
        this.simpleConfigurator = new SimpleConfigurator(rulesMap){

            protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
                defaultProcessor.addHandler(TopModel.class, NOPModelHandler::makeInstance);
                defaultProcessor.addHandler(DefineModel.class, DefineModelHandler::makeInstance);
                defaultProcessor.addHandler(ImplicitModel.class, ImplicitModelHandler::makeInstance);
            }
        };
        this.simpleConfigurator.setContext(this.context);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void good() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/define/good.xml");
        ModelInterpretationContext mic = this.simpleConfigurator.getModelInterpretationContext();
        String inContextFoo = mic.getProperty("foo");
        Assert.assertEquals((Object)"monster", (Object)inContextFoo);
    }

    @Test
    public void noName() throws JoranException {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/define/noname.xml");
        }
        finally {
            StatusPrinter.print((Context)this.context);
        }
        String inContextFoo = this.context.getProperty("foo");
        Assert.assertNull((Object)inContextFoo);
        this.checker.assertContainsMatch(2, "Missing attribute \\[name\\] in element \\[define\\]");
    }

    @Test
    public void noClass() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/define/noclass.xml");
        String inContextFoo = this.context.getProperty("foo");
        StatusPrinter.print((Context)this.context);
        Assert.assertNull((Object)inContextFoo);
        this.checker.assertContainsMatch(2, "Missing attribute \\[class\\] in element \\[define\\]");
    }

    @Test
    public void testBadClass() throws JoranException {
        this.simpleConfigurator.doConfigure("src/test/input/joran/define/badclass.xml");
        String inContextFoo = this.context.getProperty("foo");
        Assert.assertNull((Object)inContextFoo);
        this.checker.assertContainsMatch(2, "Could not create an PropertyDefiner of type");
    }

    @Ignore
    @Test
    public void canonicalHostNameProperty() throws JoranException {
        String configFileAsStr = "src/test/input/joran/define/canonicalHostname.xml";
        this.simpleConfigurator.doConfigure(configFileAsStr);
        Assert.assertNotNull((Object)this.context.getProperty("CANONICAL_HOST_NAME"));
    }
}

